/*
 * SpaceControlCanvas.java
 *
 * Created on October 30, 2005, 8:49 AM
 */

import java.awt.*;
//import java.awt.geom.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class SpaceControlCanvas extends DBCanvas
implements MouseListener {
    ListenString[] buttons;
    SpaceCanvas SC;
    Manager M;
    
    int padding=4;
    
    // Colors
    Color buttonBg, buttonFg, selectedBg;
    
    // The currently selected mode
    int mode;
    
    /** Creates a new instance of SpaceControlCanvas */
    public SpaceControlCanvas(SpaceCanvas SC, Manager M) {
        this.SC=SC;
        this.M=M;
        
        //setFont(new Font("sanserif", Font.PLAIN, 12));
        setFont(new Font("Helvetica",Font.PLAIN,12));
        addMouseListener(this);
        
        buttons=new ListenString[8];
        
        double x=padding,y=padding;
        buttons[0]=new ListenString("standard", this);
        buttons[0].setLeft(x);
        buttons[0].setTop(y);
        
        x=buttons[0].getRight()+padding;
        buttons[1]=new ListenString("[  ]", this);
        buttons[1].setLeft(x);
        buttons[1].setTop(y);
        
        x=buttons[1].getRight()+padding;
        buttons[2]=new ListenString("color", this);
        buttons[2].setLeft(x);
        buttons[2].setTop(y);
        
        x=buttons[2].getRight()+padding;
        buttons[6]=new ListenString("fit", this);
        buttons[6].setLeft(x);
        buttons[6].setTop(y);
        
        x=padding;
        y=buttons[0].getBottom()+padding;
        buttons[3]=new ListenString("raise", this);
        buttons[3].setLeft(x);
        buttons[3].setTop(y);
        
        x=buttons[3].getRight()+padding;
        buttons[4]=new ListenString("lower", this);
        buttons[4].setLeft(x);
        buttons[4].setTop(y);
        
        x=buttons[4].getRight()+padding;
        buttons[5]=new ListenString("erase", this);
        buttons[5].setLeft(x);
        buttons[5].setTop(y);

	//added by Rich
        x=buttons[5].getRight()+padding;
        buttons[7]=new ListenString("?", this);
        buttons[7].setLeft(x);
        buttons[7].setTop(y);


        
        //Setup Colors
        buttonBg=new Color(100,250,100);
        buttonFg=Color.black;
        selectedBg=new Color(255,255,0);
        setBackground(new Color(0,100,0));
        
        for (int i=0; i<buttons.length; i++){
            buttons[i].bgColor=buttonBg;
            buttons[i].fgColor=buttonFg;
        }
        mode=SC.mode;
        buttons[mode].bgColor=selectedBg;
    }
    
    /** set the canvas size to its minimal appropriate size. */
    public void setSize(){
        setSize(
        (int)(buttons[6].getRight()+padding),
        (int)(buttons[3].getBottom()+padding));
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        //g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
        //RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
         Dimension D=getSize();
	 g.setColor(new Color(0,255,255));
	 g.drawRect(0,0,D.width-1,D.height-1);
        for (int i=0; i<buttons.length; i++){
            buttons[i].render(g);
        }
    }
    
    public void mouseClicked(MouseEvent e) {
        for (int i=0; i<buttons.length; i++){
            if (buttons[i].contains(e.getX(),e.getY())) {
                buttons[mode].bgColor=buttonBg;
                mode=i;
                SC.mode=i;
                buttons[mode].bgColor=selectedBg;
                repaint();
		if(i==7) document();  //added by Rich
	
                return;
            }
        }
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }


    public void document() {
	M.setExplain("This window lets you control the effect of clicking button 2 in the main plot window.  Assuming that you have already drawn some orbit tiles, you have the following options for interacting with them:\n\nstandard: when you click on a tile this tile is highlighted and the applet stores the word associated with the tile. \n\ncolor: let's you recolor the tile according to the color on the color selector.\n\n raise: raises the tile in relation to other plotted tiles.\n\nlower: lowers the tile in connetion to other plotter tiles.\n\nerase: erases the tile.\n\nfit: this button resizes the tile to fit well on the screen.\n\n[]:  right now this is essentially the same as standard. We're going to add another function here soon.");
    }



    
}
