/*
 * SpaceTileManager.java
 *
 * Created on October 29, 2005, 11:14 AM
 */

import java.util.*;
import java.awt.geom.*;
import java.awt.*;
import java.lang.ref.WeakReference;
/**
 * This class organizes the objects that are to be drawn on the
 * parameter space. Other classes will utilize this one in order
 *
 * @author  pat
 */
public class SpaceTileManager
implements ParameterSpaceRenderer {
    private Manager M;
    
    /** This is the linked list of tiles */
    private LinkedList tiles;
    
    /** Creates a new instance of SpaceTileManager */
    public SpaceTileManager(Manager M) {
        this.M=M;
        
        tiles=new LinkedList();
        
        M.addRendererBottom(this);
    }
    
    /**
     ** Add a tile
     */
    public void addTile(Tile t) {
        if ((t!=null)&&(t.isPaintable())) {
            synchronized(tiles) {
                tiles.addLast(t);
            }
            M.selectTile(t);
            M.spaceChanged();
        }
    }
    
    /** Select the highest tile containing the point (x,y).
     * @return The tile if one is found, and null otherwise
     */
    public Tile selectTile(double x, double y){
        Tile tile;
        synchronized(tiles) {
            for (ListIterator it=tiles.listIterator(tiles.size());
            it.hasPrevious();){
                tile=(Tile)it.previous();
                if (tile.contains(x,y))
                    return tile;
            }
        }
        return null;
    }
    
    public void raise(Tile tile){
        synchronized(tiles) {
            tiles.remove(tile);
            tiles.addLast(tile);
        }
    }
    
    public void lower(Tile tile){
        synchronized(tiles) {
            tiles.remove(tile);
            tiles.addFirst(tile);
        }
    }
    
    public void delete(Tile tile){
        synchronized(tiles) {
            tiles.remove(tile);
        }
    }


    public void clear() {
	synchronized(tiles) {
	    tiles=new LinkedList();
	}
    }




    
    /**
     * Paint the tiles in order, transforming each by the AffineTransform t
     */
    public void render(Graphics2D g, AffineTransform t) {
        //System.out.println("Thread \""+Thread.currentThread().getName()+"\" rendering");
        Tile tile, selected=M.getSelectedTile();
        Shape s;
        synchronized(tiles) {
            for (ListIterator it=tiles.listIterator();
            it.hasNext();){
                tile=(Tile)it.next();
                if (tile==selected)
                    tile.paintSelected(g,t);
                else
                    tile.paint(g,t);
            }
        }
    }
    
    public void plotTile(Tile st) {
        //System.out.println("Received tile");
        addTile(st);
        M.spaceChanged();
    }
}
