import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;



public class Spine {

    /**This class contains methods which extract the defining
       functions from the combinatorial information calculated
       when we perform the combinatorial version of the unfolding.*/

    public Spine() {}

    /**Here is a palindrome test.  1 means palindrome*/

    public static int palindromeTest(CombinatorialTriangle[] T) {
	int N=T[0].c[0]+1;
	for(int i=1;i<N;++i) {
	    for(int j=0;j<=2;++j) {
	    if(T[i].b[j]+T[N-i].b[j]!=0) return(0);
	    }
	}
	return(1);
    }



    /**these are little routines which convert between our
       various ways of storing information*/

    public static int getDigit(String W,int q) {
	String S=new String();
	int m=0;
	int n=W.length();
	int qq=q;
	if(q<0) qq=q+n;
	if(q>=n) qq=q-n;
	S=W.substring(qq,qq+1);  
        if(S.compareTo("1")==0) m=0;
	if(S.compareTo("2")==0) m=1;
	if(S.compareTo("3")==0) m=2;
	return(m);
    }


    public static int lastDigit(String W) {
	return(getDigit(W,W.length()-1));
    }



    public static int[] getTriple(String W,int q) {
	int[] m=new int[3];
	int n=W.length();
	for(int i=-1;i<=1;++i) {
	    m[i+1]=getDigit(W,q+i);
	}
	return(m);
    }


    /**here j is the vertex type. 
       w[0] tells if the vertex is a top or bottom vertex.
       w[1] names the vertex
    */

    public static int[] typeToCoords(CombinatorialTriangle T,int j) {
	int[] w=new int[2];
	int up=1;
	if((T.c[0]==0)&&(j==1)) up=-1;
	if((T.c[0]==1)&&(j==2)) up=-1;
	if((T.c[0]==2)&&(j==0)) up=-1;
	up=up*T.parity;
	if(up==1) w[0]=1;
	if(up==-1) w[0]=2;
	if(up==-1) w[1]=T.c[2];
	if(up==+1) w[1]=T.c[1];
	return(w);
    }


    public static int findType(CombinatorialTriangle T,int up,int m) {
	int test=-T.parity;
	if(up==2) test=-test;
	int j=T.c[0]+test;
	if(j>=3) j=j-3;
	if(j<0) j=j+3;
	return(j);
    }

    public static int spineNumber(VertexPair V,CombinatorialTriangle[] T) {
	int n1=coordsToType(T[V.e1],V.o1);
        int n2=coordsToType(T[V.e2],V.o2);
	if(n1!=n2) return(3-n1-n2);
	if(n1==2) return(1);
	return(2);
    }

    public static int coordsToType(CombinatorialTriangle T,int m0) {
	return((3+T.c[0]+T.parity*(2*m0-3))%3);
    }





    /**a return of 
    -1 means that the pair is misordered
     1 means that the pair is correctly ordered
     2 or 3 means that the vertices are the
     two endpoints of an interior edge
    */


    public static int pairOrdering(VertexPair V,CombinatorialTriangle[] CT) {
      int n1,n2,n3,n4;
      n1=CT[V.e1].c[V.o1];
      n2=CT[V.e2].c[V.o2];
      n3=CT[V.e1].c[3-V.o1];
      n4=CT[V.e2].c[3-V.o2];

      if(V.o1==V.o2) {
        if(n1==n2) return(0);
        if(n1<n2) return(1);
        if(n1>n2) return(-1);
      }

      if((n1==n4)) return(2);
      if((n2==n3)) return(3);
      if(n3<n2) return(1);
      if(n1<n4) return(1);
      return(-1);
    }

    public static VertexPair swap(VertexPair V,int i) {
      VertexPair V2=new VertexPair(V.o1,V.e1,V.o2,V.e2);
      if(i==-1) {
        V2.o2=V.o1;
        V2.e2=V.e1;  
        V2.o1=V.o2;
        V2.e1=V.e2; 
      }
     return(V2);
    }








    /**now we have the routines which compute the spine*/

    /**first the "numerator" part*/

    public static int[] computeSpine(VertexPair V,CombinatorialTriangle[] CT) {
      int first,last,count;
      int[] n=new int[CT[0].c[0]+3];
      VertexPair V2=new VertexPair();
      int order=pairOrdering(V,CT);
      int spine=spineNumber(V,CT);

      //sign convention
      int convention=1;
      if((order==-1)&&(V.o1==1)&&(V.o2==2)) convention=-1;
      if((order== 2)&&(V.o1==1)&&(V.o2==2)) convention=-1;
      if((order== 1)&&(V.o1==2)&&(V.o2==1)) convention=-1;	
      if((order== 3)&&(V.o1==2)&&(V.o2==1)) convention=-1;

      if((V.o1==V.o2)&&(order==0)) {n[0]=0;n[1]=convention;n[2]=spine;return(n);}            //exceptional
      if((V.o1!=V.o2)&&(order==2)) {n[1]=V.e2;n[0]=1;n[2]=convention;n[3]=spine;return(n);}  //exceptional
      if((V.o1!=V.o2)&&(order==3)) {n[1]=V.e1;n[0]=1;n[2]=convention;n[3]=spine;return(n);}  //exceptional

      V2=swap(V,order);
      first=CT[V2.e1].e[0][V2.o1-1];
      last= CT[V2.e2].e[1][V2.o2-1];

      if(first>=last) {n[1]=first;n[0]=1;n[2]=convention;n[3]=spine;return(n);}              //exceptional
      count=2;   
      for(int i=first+1;i<last;++i) {        
        if(CT[i].a[spine]==1)  {
        n[count]=i; ++count; }
      }
      n[1]=first;
      n[count]=last;
      n[0]=count;
      n[count+1]=convention;
      n[count+2]=spine;
      return(n);
    }

    public static int getFirstTerm(VertexPair V,CombinatorialTriangle[ ] CT) {

      VertexPair V2=new VertexPair();
      int order=pairOrdering(V,CT);
      int spine=spineNumber(V,CT);

      if((V.o1==V.o2)&&(order==0)) return(0);
      if((V.o1!=V.o2)&&(order==2)) return(V.e2);
      if((V.o1!=V.o2)&&(order==3)) return(V.e1);

      V2=swap(V,order);
      return(CT[V2.e1].e[0][V2.o1-1]);
    }


    public static int getSign(VertexPair V,CombinatorialTriangle[] CT,int[][] d) {
	return(Function.getSign(getFirstTerm(V,CT),d));
    }







    /**the "denominator" part*/


    public static  int[] trim(int[] n) {
	int[] m=new int[n[0]];
	m[0]=n[0]-1;      
        for(int i=1;i<=m[0];++i) m[i]=n[i+1];
	return(m);
    }


    public static int[] fullSpine(VertexPair V,CombinatorialTriangle[] CT) {
      int spine=spineNumber(V,CT);
      return(fullSpine(spine,CT));
    }



    public static int[] fullSpine(int spine,CombinatorialTriangle[] CT) {
      int[] n=new int[CT[0].c[0]+1];
      int N=CT[0].c[0];
      n[1]=1;
      int count=2;   
      for(int i=2;i<N;++i) {        
         if(CT[i].a[spine]==1)  {
           n[count]=i; ++count; }
      }
      n[count]=N;
      n[0]=count;


  /**trimming the edges:  We trim off as much of the
     initial portion as possible and then make the length
     of the spine even.*/

    int[] w1=CT[n[1]].d[spine];
    int[] w2=CT[n[2]].d[spine];
    if((w1[0]==w2[0])&&(w1[1]==w2[1])) n=trim(n);     //kills repeaters

    w1=CT[n[1]].d[spine];
    w2=CT[n[2]].d[spine];
    if((w1[0]==0)&&(w1[1]==0)) n=trim(n);             //kills redundant first edge

    w1=CT[n[1]].d[spine];
    w2=CT[n[2]].d[spine];
    if((w1[0]==0)&&(w2[0]==0)) n=trim(n);             //kills extra type 1 tail
    if((w1[1]==0)&&(w2[1]==0)) n=trim(n);             //kills extra type 2 tail
    if((w1[0]==w1[1])&&(w2[0]==w2[1])) n=trim(n);     //kills extra type 3 tail

    if(n[0]%2==1) --n[0];                             //the spines always have even length

    return(n);
    }





    /**These routines are analogous to the evaluation routines in the
       Function class.  In our plotting algorithm we use the routines
       here because they are more direct.  They don't require us to
       define an auxilliary function object.  On the down side, the
       definitions are less transparent.*/


    //the 0th derivative - i.e. the function itself

    public static Complex evaluate(VertexPair V,CombinatorialTriangle[] CT,Complex ZZ) {
	Complex E=new Complex();
        int first,last,count;
        VertexPair V2=new VertexPair();
        int order=pairOrdering(V,CT);
        int spine=spineNumber(V,CT);
	Complex Z=new Complex(Math.PI*ZZ.x/2,Math.PI*ZZ.y/2);

        int convention=1;
        if((order==-1)&&(V.o1==1)&&(V.o2==2)) convention=-1;
        if((order== 2)&&(V.o1==1)&&(V.o2==2)) convention=-1;
        if((order== 1)&&(V.o1==2)&&(V.o2==1)) convention=-1;	
        if((order== 3)&&(V.o1==2)&&(V.o2==1)) convention=-1;

	//some special cases

	if((V.o1==V.o2)&&(order==0)) return(E);

        if((V.o1!=V.o2)&&(order==2)) {
	    E.x=convention*Math.cos(CT[V.e2].d[spine][0]*Z.x+CT[V.e2].d[spine][1]*Z.y);
	    E.y=convention*Math.sin(CT[V.e2].d[spine][0]*Z.x+CT[V.e2].d[spine][1]*Z.y);
	    return(E);
	}

        if((V.o1!=V.o2)&&(order==3)) {
	    E.x=convention*Math.cos(CT[V.e1].d[spine][0]*Z.x+CT[V.e1].d[spine][1]*Z.y);
	    E.y=convention*Math.sin(CT[V.e1].d[spine][0]*Z.x+CT[V.e1].d[spine][1]*Z.y);
	    return(E);
	}

        V2=swap(V,order);
        first=CT[V2.e1].e[0][V2.o1-1];
        last= CT[V2.e2].e[1][V2.o2-1];

        if(first>=last) {
          E.x=convention*Math.cos(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	  E.y=convention*Math.sin(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	  return(E);
	}

	//general case

         E.x=convention*Math.cos(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	 E.y=convention*Math.sin(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	 int sign=-1;
         for(int i=first+1;i<last;++i) {        
           if(CT[i].a[spine]==1)  {
             E.x=E.x+sign*convention*Math.cos(CT[i].d[spine][0]*Z.x+CT[i].d[spine][1]*Z.y);
	     E.y=E.y+sign*convention*Math.sin(CT[i].d[spine][0]*Z.x+CT[i].d[spine][1]*Z.y);
	     sign=-sign;
	   }
	 }
         E.x=E.x+sign*convention*Math.cos(CT[last].d[spine][0]*Z.x+CT[last].d[spine][1]*Z.y);
	 E.y=E.y+sign*convention*Math.sin(CT[last].d[spine][0]*Z.x+CT[last].d[spine][1]*Z.y);

	 return(E);
    }


    public static double evaluate(int SIGN,VertexPair V,CombinatorialTriangle[] CT,int[][] d,Complex Z) {
	Complex E=evaluate(V,CT,Z);
	Complex Q=Function.derivative(d,0,0,Z);
	E=Complex.times(E,Complex.conjugate(Q));
	return(SIGN*E.y);
    }

    public static double evaluate(int SIGN,VertexPair V,CombinatorialTriangle[] CT,Complex Q,Complex Z) {
	Complex E=evaluate(V,CT,Z);
	E=Complex.times(E,Complex.conjugate(Q));
	return(SIGN*E.y);
    }





    //first derivatives


    public static Complex derivative(int q,VertexPair V,CombinatorialTriangle[] CT,Complex ZZ) {
	Complex E=new Complex();
        int first,last,count;
        VertexPair V2=new VertexPair();
        int order=pairOrdering(V,CT);
        int spine=spineNumber(V,CT);
	Complex Z=new Complex(Math.PI*ZZ.x/2,Math.PI*ZZ.y/2);
	double cf=0;

        int convention=1;
        if((order==-1)&&(V.o1==1)&&(V.o2==2)) convention=-1;
        if((order== 2)&&(V.o1==1)&&(V.o2==2)) convention=-1;
        if((order== 1)&&(V.o1==2)&&(V.o2==1)) convention=-1;	
        if((order== 3)&&(V.o1==2)&&(V.o2==1)) convention=-1;

	//some special cases

	if((V.o1==V.o2)&&(order==0)) return(E);

        if((V.o1!=V.o2)&&(order==2)) {
	    cf=CT[V.e2].d[spine][q-1];
	    E.x=-cf*convention*Math.sin(CT[V.e2].d[spine][0]*Z.x+CT[V.e2].d[spine][1]*Z.y);
	    E.y=cf*convention*Math.cos(CT[V.e2].d[spine][0]*Z.x+CT[V.e2].d[spine][1]*Z.y);
	    return(E);
	}

        if((V.o1!=V.o2)&&(order==3)) {
            cf=CT[V.e1].d[spine][q-1];
	    E.x=-cf*convention*Math.sin(CT[V.e1].d[spine][0]*Z.x+CT[V.e1].d[spine][1]*Z.y);
	    E.y=cf*convention*Math.cos(CT[V.e1].d[spine][0]*Z.x+CT[V.e1].d[spine][1]*Z.y);
	    return(E);
	}

        V2=swap(V,order);
        first=CT[V2.e1].e[0][V2.o1-1];
        last= CT[V2.e2].e[1][V2.o2-1];

        if(first>=last) {
          cf=CT[first].d[spine][q-1];
          E.x=-cf*convention*Math.sin(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	  E.y=cf*convention*Math.cos(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	  return(E);
	}


	//general case
         cf=CT[first].d[spine][q-1];
         E.x=-cf*convention*Math.sin(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	 E.y=cf*convention*Math.cos(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	 int sign=-1;
         for(int i=first+1;i<last;++i) {        
           if(CT[i].a[spine]==1)  {
            cf=CT[i].d[spine][q-1];
             E.x=E.x-cf*sign*convention*Math.sin(CT[i].d[spine][0]*Z.x+CT[i].d[spine][1]*Z.y);
	     E.y=E.y+cf*sign*convention*Math.cos(CT[i].d[spine][0]*Z.x+CT[i].d[spine][1]*Z.y);
	     sign=-sign;
	   }
	 }
         cf=CT[last].d[spine][q-1];
         E.x=E.x-cf*sign*convention*Math.sin(CT[last].d[spine][0]*Z.x+CT[last].d[spine][1]*Z.y);
	 E.y=E.y+cf*sign*convention*Math.cos(CT[last].d[spine][0]*Z.x+CT[last].d[spine][1]*Z.y);

	 return(E);
    }



    public static double gradient(int sign,int q,VertexPair V,CombinatorialTriangle[] CT,Complex Q,Complex DQ,Complex zz) {
	Complex P=evaluate(V,CT,zz);
	Complex DP=derivative(q,V,CT,zz);
	Complex w1=Complex.times(P,Complex.conjugate(DQ));
	Complex w2=Complex.times(DP,Complex.conjugate(Q));
	Complex w=Complex.plus(w1,w2);
	return(sign*w.y);
    }


    public static double gradient(int sign,int q,VertexPair V,CombinatorialTriangle[] CT,int[][] d,Complex zz) {
	Complex P=evaluate(V,CT,zz);
	Complex DP=derivative(q,V,CT,zz);
	Complex Q=Function.derivative(d,0,0,zz);
	Complex DQ=new Complex();
	if(q==1) DQ=Function.derivative(d,1,0,zz);
	if(q==2) DQ=Function.derivative(d,0,1,zz);
	Complex w1=Complex.times(P,Complex.conjugate(DQ));
	Complex w2=Complex.times(DP,Complex.conjugate(Q));
	Complex w=Complex.plus(w1,w2);
	return(sign*w.y);
    }

    


    //second derivatives


    public static Complex derivative2(int q,VertexPair V,CombinatorialTriangle[] CT,Complex ZZ) {
	Complex E=new Complex();
        int first,last,count;
        VertexPair V2=new VertexPair();
        int order=pairOrdering(V,CT);
        int spine=spineNumber(V,CT);
	Complex Z=new Complex(Math.PI*ZZ.x/2,Math.PI*ZZ.y/2);
	double cf=0;

        int convention=1;
        if((order==-1)&&(V.o1==1)&&(V.o2==2)) convention=-1;
        if((order== 2)&&(V.o1==1)&&(V.o2==2)) convention=-1;
        if((order== 1)&&(V.o1==2)&&(V.o2==1)) convention=-1;	
        if((order== 3)&&(V.o1==2)&&(V.o2==1)) convention=-1;

	//some special cases

	if((V.o1==V.o2)&&(order==0)) return(E);

        if((V.o1!=V.o2)&&(order==2)) {

	    if(q==0) cf=CT[V.e2].d[spine][0]*CT[V.e2].d[spine][0];
	    if(q==1) cf=CT[V.e2].d[spine][1]*CT[V.e2].d[spine][0];
	    if(q==2) cf=CT[V.e2].d[spine][1]*CT[V.e2].d[spine][1];
	    E.x=-cf*convention*Math.cos(CT[V.e2].d[spine][0]*Z.x+CT[V.e2].d[spine][1]*Z.y);
	    E.y=-cf*convention*Math.sin(CT[V.e2].d[spine][0]*Z.x+CT[V.e2].d[spine][1]*Z.y);
	    return(E);
	}

        if((V.o1!=V.o2)&&(order==3)) {
            if(q==0) cf=CT[V.e1].d[spine][0]*CT[V.e1].d[spine][0];
	    if(q==1) cf=CT[V.e1].d[spine][1]*CT[V.e1].d[spine][0];
	    if(q==2) cf=CT[V.e1].d[spine][1]*CT[V.e1].d[spine][1];
	    E.x=-cf*convention*Math.cos(CT[V.e1].d[spine][0]*Z.x+CT[V.e1].d[spine][1]*Z.y);
	    E.y=-cf*convention*Math.sin(CT[V.e1].d[spine][0]*Z.x+CT[V.e1].d[spine][1]*Z.y);
	    return(E);
	}

        V2=swap(V,order);
        first=CT[V2.e1].e[0][V2.o1-1];
        last= CT[V2.e2].e[1][V2.o2-1];

        if(first>=last) {
          if(q==0) cf=CT[first].d[spine][0]*CT[first].d[spine][0];
	  if(q==1) cf=CT[first].d[spine][1]*CT[first].d[spine][0];
	  if(q==2) cf=CT[first].d[spine][1]*CT[first].d[spine][1];
          E.x=-cf*convention*Math.cos(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	  E.y=-cf*convention*Math.sin(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	  return(E);
	}


	//general case
         if(q==0) cf=CT[first].d[spine][0]*CT[first].d[spine][0];
	 if(q==1) cf=CT[first].d[spine][1]*CT[first].d[spine][0];
	 if(q==2) cf=CT[first].d[spine][1]*CT[first].d[spine][1];
         E.x=-cf*convention*Math.cos(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	 E.y=-cf*convention*Math.sin(CT[first].d[spine][0]*Z.x+CT[first].d[spine][1]*Z.y);
	 int sign=-1;
         for(int i=first+1;i<last;++i) {        
           if(CT[i].a[spine]==1)  {
            if(q==0) cf=CT[i].d[spine][0]*CT[i].d[spine][0];
	    if(q==1) cf=CT[i].d[spine][1]*CT[i].d[spine][0];
	    if(q==2) cf=CT[i].d[spine][1]*CT[i].d[spine][1];
             E.x=E.x-cf*sign*convention*Math.cos(CT[i].d[spine][0]*Z.x+CT[i].d[spine][1]*Z.y);
	     E.y=E.y-cf*sign*convention*Math.sin(CT[i].d[spine][0]*Z.x+CT[i].d[spine][1]*Z.y);
	     sign=-sign;
	   }
	 }
         if(q==0) cf=CT[last].d[spine][0]*CT[last].d[spine][0];
	 if(q==1) cf=CT[last].d[spine][1]*CT[last].d[spine][0];
	 if(q==2) cf=CT[last].d[spine][1]*CT[last].d[spine][1];
         E.x=E.x-cf*sign*convention*Math.cos(CT[last].d[spine][0]*Z.x+CT[last].d[spine][1]*Z.y);
	 E.y=E.y-cf*sign*convention*Math.sin(CT[last].d[spine][0]*Z.x+CT[last].d[spine][1]*Z.y);

	 return(E);
    }


    
    public static double second(int q,VertexPair V,CombinatorialTriangle[] CT,int[][] d,Complex zz) {

      if(q==0) {
       Complex P=evaluate(V,CT,zz);
       Complex DP=derivative(1,V,CT,zz);
       Complex DDP=derivative2(0,V,CT,zz);
       Complex Q=Function.derivative(d,0,0,zz);
       Complex DQ=Function.derivative(d,1,0,zz);
       Complex DDQ=Function.derivative(d,2,0,zz);
       Complex w1=new Complex();
       w1=Complex.plus(w1,Complex.times(P,Complex.conjugate(DDQ)));
       w1=Complex.plus(w1,Complex.times(DP,Complex.conjugate(DQ)));
       w1=Complex.plus(w1,Complex.times(DP,Complex.conjugate(DQ)));
       w1=Complex.plus(w1,Complex.times(DDP,Complex.conjugate(Q)));
       return(Math.abs(w1.y));
      }

      if(q==2) {
       Complex P=evaluate(V,CT,zz);
       Complex DP=derivative(2,V,CT,zz);
       Complex DDP=derivative2(2,V,CT,zz);
       Complex Q=Function.derivative(d,0,0,zz);
       Complex DQ=Function.derivative(d,0,1,zz);
       Complex DDQ=Function.derivative(d,0,2,zz);
       Complex w1=new Complex();
       w1=Complex.plus(w1,Complex.times(P,Complex.conjugate(DDQ)));
       w1=Complex.plus(w1,Complex.times(DP,Complex.conjugate(DQ)));
       w1=Complex.plus(w1,Complex.times(DP,Complex.conjugate(DQ)));
       w1=Complex.plus(w1,Complex.times(DDP,Complex.conjugate(Q)));
       return(Math.abs(w1.y));
      }

      if(q==1) {
       Complex P=evaluate(V,CT,zz);
       Complex D1P=derivative(1,V,CT,zz);
       Complex D2P=derivative(2,V,CT,zz);
       Complex DDP=derivative2(1,V,CT,zz);
       Complex Q=Function.derivative(d,0,0,zz);
       Complex D0Q=Function.derivative(d,1,0,zz);
       Complex D1Q=Function.derivative(d,0,1,zz);
       Complex DDQ=Function.derivative(d,1,1,zz);
       Complex w1=new Complex();
       w1=Complex.plus(w1,Complex.times(P,Complex.conjugate(DDQ)));
       w1=Complex.plus(w1,Complex.times(D2P,Complex.conjugate(D0Q)));
       w1=Complex.plus(w1,Complex.times(D1P,Complex.conjugate(D1Q)));
       w1=Complex.plus(w1,Complex.times(DDP,Complex.conjugate(Q)));
       return(Math.abs(w1.y));
      }
      return(0);
    }







    //some auxilliary quantities and tests based on the derivatives

    public static int[] absSecond(VertexPair V,CombinatorialTriangle[] CT,int[][] d) {
	int[] a=new int[3];
	int[][] numerator=Function.computeNumerator(V,CT);
        int[][] f=Function.foil(numerator,d);
	a[0]=Function.absoluteSecondDerivative(f,2,0);
	a[1]=Function.absoluteSecondDerivative(f,1,1);
	a[2]=Function.absoluteSecondDerivative(f,0,2);
	return(a);
    }


    public static Complex[] getRelevant(DyadicSquare Q,int direction) {
	Complex[] ZZ=new Complex[2];   
	Complex z=Q.getCenter();
        double width=Math.pow(0.5,Q.k+1);

	if(direction==1) {
	    ZZ[0]=new Complex(z.x+width,z.y+width);
	    ZZ[1]=new Complex(z.x-width,z.y-width);
	}

	if(direction==5) {
	    ZZ[1]=new Complex(z.x+width,z.y+width);
	    ZZ[0]=new Complex(z.x-width,z.y-width);
	}

	if(direction==2) {
	    ZZ[0]=new Complex(z.x,z.y+2.0*width);
	    ZZ[1]=new Complex(z.x,z.y-2.0*width);
	}

	if(direction==6) {
	    ZZ[1]=new Complex(z.x,z.y+2.0*width);
	    ZZ[0]=new Complex(z.x,z.y-2.0*width);
	}

	if(direction==3) {
	    ZZ[0]=new Complex(z.x-width,z.y+width);
	    ZZ[1]=new Complex(z.x+width,z.y-width);
	}

	if(direction==7) {
	    ZZ[1]=new Complex(z.x-width,z.y+width);
	    ZZ[0]=new Complex(z.x+width,z.y-width);
	}

	if(direction==4) {
	    ZZ[0]=new Complex(z.x-2.0*width,z.y);
	    ZZ[1]=new Complex(z.x+2.0*width,z.y);
	}

	if(direction==8) {
	    ZZ[1]=new Complex(z.x-2.0*width,z.y);
	    ZZ[0]=new Complex(z.x+2.0*width,z.y);
	}
	return(ZZ);
    }


    public static int signEvaluate(int sign,VertexPair V,CombinatorialTriangle[] CT,int[][] d,DyadicSquare Q,int direction) {
	if(direction==0) return(0);
    Complex[] ZZ=getRelevant(Q,direction);
    double min=evaluate(sign,V,CT,d,ZZ[1]);
    if(min>=0) return(2);
    double max=evaluate(sign,V,CT,d,ZZ[0]);
    if(max<=0) return(1);
    return(0);
}



    public static int signEvaluate(int sign,VertexPair V,CombinatorialTriangle[] CT,Complex[] data,DyadicSquare Q,int direction) {	
    if(direction==0) return(0);
    Complex[] ZZ=getRelevant(Q,direction);
    int pos1=direction;
    int pos2=direction+4;
    if(pos2>8) pos2=pos2-8;
    double min=evaluate(sign,V,CT,data[pos2],ZZ[1]);
    if(min>=0) return(2);
    double max=evaluate(sign,V,CT,data[pos1],ZZ[0]);
    if(max<=0) return(1);
    return(0);
}


    public static int crudePositiveTest(int sign,VertexPair V,CombinatorialTriangle[] CT,int[][] d,DyadicSquare Q,int[] a) {
	double[] x=new double[20];
	Complex Z=Q.getCenter();
	x[0]=evaluate(sign,V,CT,d,Z);
	x[1]=Math.PI*Math.pow(0.5,Q.k+2);
	x[2]=x[1]*x[1];
	x[3]=Math.abs(gradient(sign,1,V,CT,d,Z));
	x[4]=Math.abs(gradient(sign,2,V,CT,d,Z));
	x[5]=x[1]*(x[3]+x[4]);
	x[9]=x[2]*(a[0]+2*a[1]+a[2]);
	x[10]=x[5]+x[9];
	x[11]=x[0]-x[10];
	if(x[11]>0) return(1);
	return(0);
    }


    public static int crudePositiveTest(int sign,VertexPair V,CombinatorialTriangle[] CT,Complex[] data,DyadicSquare Q,int[] a) {
	double[] x=new double[20];
	Complex Z=Q.getCenter();
	x[0]=evaluate(sign,V,CT,data[0],Z);
	x[1]=Math.PI*Math.pow(0.5,Q.k+2);
	x[2]=x[1]*x[1];
	x[3]=Math.abs(gradient(sign,1,V,CT,data[0],data[9],Z));
	x[4]=Math.abs(gradient(sign,2,V,CT,data[0],data[10],Z));
	x[5]=x[1]*(x[3]+x[4]);
	x[9]=x[2]*(a[0]+2*a[1]+a[2]);
	x[10]=x[5]+x[9];
	x[11]=x[0]-x[10];
	if(x[11]>0) return(1);
	return(0);
    }




    public static int crudeNegativeTest(int sign,VertexPair V,CombinatorialTriangle[] CT,int[][] d,DyadicSquare Q,int[] a) {
	double[] x=new double[20];
	Complex Z=Q.getCenter();
	x[0]=evaluate(sign,V,CT,d,Z);
	x[1]=Math.PI*Math.pow(0.5,Q.k+2);
	x[2]=x[1]*x[1];
	x[3]=Math.abs(gradient(sign,1,V,CT,d,Z));
	x[4]=Math.abs(gradient(sign,2,V,CT,d,Z));
	x[5]=x[1]*(x[3]+x[4]);
	x[9]=x[2]*(a[0]+2*a[1]+a[2]);
	x[10]=x[5]+x[9];
	x[11]=x[0]+x[10];
	if(x[11]<0) return(1);
	Q.print();
	return(0);
    }


    public static int crudeNegativeTest(int sign,VertexPair V,CombinatorialTriangle[] CT,Complex[] data,DyadicSquare Q,int[] a) {
	double[] x=new double[20];
	Complex Z=Q.getCenter();
	x[0]=evaluate(sign,V,CT,data[0],Z);
	x[1]=Math.PI*Math.pow(0.5,Q.k+2);
	x[2]=x[1]*x[1];
	x[3]=Math.abs(gradient(sign,1,V,CT,data[0],data[9],Z));
	x[4]=Math.abs(gradient(sign,2,V,CT,data[0],data[10],Z));
	x[5]=x[1]*(x[3]+x[4]);
	x[9]=x[2]*(a[0]+2*a[1]+a[2]);
	x[10]=x[5]+x[9];
	x[11]=x[0]+x[10];
	if(x[11]<0) return(1);
	Q.print();
	return(0);
    }



    
    public static int[] completeList(int ii,CombinatorialTriangle[] CT) {
        int count,OLD,NEW;
        int[] n=new int[CT[0].c[0]];
        count=0;
        OLD=1;
        
        for(int i=1;i<=CT[0].c[0];++i) {
            NEW=CT[i].c[ii];
            if(NEW>OLD) {
                OLD=NEW;
                ++count;
                n[count]=i-1;
            }
        }
        
        if(2*count<CT[0].c[0]) {
            ++count;
            n[count]=CT[0].c[0];
        }
        
        n[0]=CT[0].c[0]/2;
        return(n);
    }
    

}
