/*
 * StringListCanvas.java
 *
 * Created on December 13, 2005, 2:33 PM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public abstract class StringListCanvas extends DBCanvas
implements MouseListener, MouseMotionListener {
    String[] S;
    ListenString[] LS;
    
    static final int padding=4;
    public int selected=-1;
    
    // translation to scroll by
    int ty, pressed_y;
    
    Color bg, box, highlight, text;
    
    /** Creates a new instance of StringListCanvas */
    public StringListCanvas() {
        setFont(new Font("sanserif", Font.PLAIN, 12));
        
    }
    
    /** This should be called first to setup colors*/
    public void setColors(Color bg, Color box, Color highlight, Color text){
        setBackground(bg);
        this.bg=bg;
        this.box=box;
        this.highlight=highlight;
        this.text=text;
    }
    
    /** then this */
    public void setNames(String[] S) {  
        LS=new ListenString[S.length];
        double x=padding, y=padding;
        for (int i=0; i<LS.length; i++) {
            LS[i]=new ListenString(S[i],this);
            LS[i].setColors(text,box);
            LS[i].setLeft(x);
            LS[i].setTop(y);
            y=LS[i].getBottom()+padding;
        }
        
        addMouseListener(this);
        addMouseMotionListener(this);
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        if (LS.length>0) {
            if (ty<-(LS[LS.length-1].getBottom()+
            padding-getHeight()))
                ty=-(int)(LS[LS.length-1].getBottom()+
                padding-getHeight());
        }
        if (ty>0)
            ty=0;
        
        for (int i=0; i<LS.length; i++) {
            LS[i].render(g,0,ty);
        }
    }
    
    public abstract void deselect();
    public abstract void select(String str);
    
    public void mouseDragged(MouseEvent e) {
        if (e.getY()!=pressed_y) {
            ty=ty+e.getY()-pressed_y;
            pressed_y=e.getY();
            repaint();
        }
    }
    
    public void mouseMoved(MouseEvent e) {
    }
    
    
    public void mouseClicked(MouseEvent e) {
        for (int i=0; i<LS.length;i++){
            if (LS[i].contains(e.getX(),e.getY()-ty)) {
                if (selected==i) {
                    LS[selected].setColors(text,box);
                    selected=-1;
                    deselect();
                    repaint();
                    return;
                } else {
                    if (selected!=-1) {
                        LS[selected].setColors(text,box);                        
                    }
                    selected=i;
                    LS[selected].setColors(text,highlight);
                    select(LS[selected].str);
                    repaint();
                    return;
                }
            }
        }
        if (selected!=-1) {
            LS[selected].setColors(text,box);
            selected=-1;
            deselect();
            repaint();
            return;
        }
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
        pressed_y=e.getY();
    }
    
    public void mouseReleased(MouseEvent e) {
    }
}
