/**
 * This class handles some basic triangle operations. In particular,
 * I need to know the sign of the area of a triangle absolutely.
 */

public final class TriangleGeometry {
    /** Determine the sign of the area of a triangle absolutely. 
     * @return 1 if the sign is positive, 0 if the triangle is degenerate, 
     * and -1 if the triangle has negative signed area.
     */
    public static int sign(double x1, double y1,
			   double x2, double y2,
			   double x3, double y3){
    	SignDecider 
	    sd=new SignDecider(),
	    X1=new SignDecider(x1),
	    X2=new SignDecider(x2),
	    X3=new SignDecider(x3),
	    Y1=new SignDecider(y1),
	    Y2=new SignDecider(y2),
	    Y3=new SignDecider(y3);
	sd.addProductTo(X1,Y2);
	sd.addProductTo(X2,Y3);
	sd.addProductTo(X3,Y1);
	sd.subtractProductFrom(X1,Y3);
	sd.subtractProductFrom(X2,Y1);
	sd.subtractProductFrom(X3,Y2);
	return sd.sign();

//      // This would be the equivalent computation with out my sign class	
// 	double d=x1*y2+x2*y3+x3*y1-x1*y3-x2*y1-x3*y2;
// 	if (d>0) {
// 	    return 1;
// 	} 
// 	if (d<0) {
// 	    return -1;
// 	}
// 	return 0;
    }
    
    /** Determine the sign of the area of a triangle absolutely. 
     * @return 1 if the sign is positive, 0 if the triangle is degenerate, 
     * and -1 if the triangle has negative signed area.
     */
    public static int sign(Complex z1, Complex z2, Complex z3) {
	return sign(z1.x,z1.y,
		    z2.x,z2.y,
		    z3.x,z3.y);
    } 
    
    /** Determine the sign of the area of a triangle absolutely. 
     * @return 1 if the sign is positive, 0 if the triangle is degenerate, 
     * and -1 if the triangle has negative signed area.
     */
    public static int sign(ListenTriangle T){
    	SignDecider 
	    sd=new SignDecider(),
	    X1=new SignDecider(T.z[0].x),
	    X2=new SignDecider(T.z[1].x),
	    X3=new SignDecider(T.z[2].x),
	    Y1=new SignDecider(T.z[0].y),
	    Y2=new SignDecider(T.z[1].y),
	    Y3=new SignDecider(T.z[2].y);
	sd.addProductTo(X1,Y2);
	sd.addProductTo(X2,Y3);
	sd.addProductTo(X3,Y1);
	sd.subtractProductFrom(X1,Y3);
	sd.subtractProductFrom(X2,Y1);
	sd.subtractProductFrom(X3,Y2);
	return sd.sign();

//      // This would be the equivalent computation with out my sign class	
// 	double d=x1*y2+x2*y3+x3*y1-x1*y3-x2*y1-x3*y2;
// 	if (d>0) {
// 	    return 1;
// 	} 
// 	if (d<0) {
// 	    return -1;
// 	}
// 	return 0;
    }

	
}
