/*
 * TwistWordCanvas.java
 *
 * Created on November 11, 2005, 7:40 AM
 */

import java.awt.*;
import java.awt.geom.*;

/**
 *
 * @author  pat
 */
public class TwistWordCanvas extends DBCanvas implements HearingSelectTile, HearingParameter {
    
    Manager M;
    String word;
    HolonomyPosition[] hol;
    Complex tri;
    GeneralPath path;
    
    static final Complex[] shift={
        new Complex(-0.5, Math.sqrt(3)/2),
        new Complex(-0.5, -Math.sqrt(3)/2),
        new Complex(1,0)
    };
    
    int mode;
    
    static Color pathColor=Color.white;
    
    /** Creates a new instance of TwistWordCanvas */
    public TwistWordCanvas(Manager M) {
        this.M=M;
        M.hearSelectTile(this);
        M.hearParameter(this);
        
        setBackground(Color.black);
        
        word=M.getWord();
        LoopWord lw=new LoopWord(word);
        hol=lw.createHolonomy();
        
        tri=M.getZ();
        
        mode=0;
        draw();
    }
    
    public void paint(Graphics gfx){
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        Rectangle2D rect=path.getBounds2D();
        AffineTransform T=new AffineTransform();
        
        double
        s1=getWidth()/rect.getWidth(),
        s2=getHeight()/rect.getHeight(),s;
        if (s1<s2) {
            s=s1;
        } else {
            s=s2;
        }
        T.translate(getWidth()/2.0, getHeight()/2.0);
        T.scale(0.95,0.95);
        T.scale(s,s);
        T.translate(-rect.getCenterX(),-rect.getCenterY());
        
        g.setColor(pathColor);
        g.setStroke(new BasicStroke(2));
        g.draw(T.createTransformedShape(path));
    }
    
    public void draw() {
        if (mode==0) {
            int sign=1;
            path=new GeneralPath();
            Complex x=new Complex();
            path.moveTo(0,0);
            for (int i=0; i<word.length()-1; i++) {
                if (sign==1)
                    x=x.plus(shift[(int)(word.charAt(i)-'1')]);
                else
                    x=x.minus(shift[(int)(word.charAt(i)-'1')]);
                path.lineTo((float)x.x,(float)x.y);
                sign=-sign;
            }
            path.closePath();
            return;
        }
        
        Projection3D P;
        switch (mode) {
            case 1:
                P=Projection3D.Standard();
                break;
            case 2:
                P=Projection3D.Normal(tri);
                break;
            default:
                P=Projection3D.Dot(tri);
        }
        Complex[] z=P.act(hol);
        path=new GeneralPath();
        
        path.moveTo((float)(z[0].x),(float)(z[0].y));
        for (int i=1; i<z.length; i++) {
            path.lineTo((float)(z[i].x),(float)(z[i].y));
        }
        path.closePath();
    }
    
    public void parameterChanged() {
        tri=M.getZ();
        if (mode>=2) {
            draw();
            repaint();
        }
    }
    
    public void selectTile(Tile t) {
        word=t.getStringWord();
        LoopWord lw=new LoopWord(word);
        hol=lw.createHolonomy();
        draw();
        repaint();
    }
    
    public void selectedTileModified() {
    }
    
}
