/*
 * UnfoldContainer.java
 *
 * Created on November 2, 2005, 10:54 PM
 */

import java.awt.*;
import java.awt.event.*;
/**
 * This class combines the various unfolding canvases into a single component.
 *
 * @author  pat
 */
public class UnfoldContainer extends Container {
    Manager M;
    UnfoldCanvas U;
    UnfoldControlCanvas UC;
    BoxAnalyzerCanvas BAC;
    FunctionCanvas F;
    
    Container C;
    /** Creates a new instance of UnfoldContainer */
    public UnfoldContainer(Manager M) {
        this.M=M;
        
        // the order of these lines is becoming quite delicate
        // ...ugh
        
        C=new Container();
        C.setLayout(new BorderLayout());
        
        U=new UnfoldCanvas(M,this);
        F=new FunctionCanvas(M);
        UC=new UnfoldControlCanvas(M,U,F);
        U.addUnfoldControlCanvas(UC);
        UC.addUnfoldContainer(this);
        
        if (UC.L[16].on==1) // add only if it wants to display functions
            C.add(F,"North");
        
        F.setSize(695,65);
        U.setSize(615,165);
        UC.setSize(80,165);
        F.setBackground(new Color(0,0,80));
        U.setBackground(Color.black);
        
        
        setLayout(new BorderLayout());
        add(UC,"West");
        add(U,"Center");
        add(C,"South");
        
        setBackground(Color.black);
        
        if (U.shouldBoxAnalyze()) {
            showBoxAnalyzer();
        }
   }
    
    /** This function hides the enclosed Function canvas */
    public void hideFunction(){
        C.remove(F);
        C.validate();
        validate();
    }
    
    /** This function shows the enclosed Function canvas */
    public void showFunction(){
        C.add(F,"North");
        C.validate();
        validate();
    }
    
    public void showBoxAnalyzer() {
        if (UC==null) {
            System.out.println("ok...");
        }
         if (BAC==null) {
            if (U==null) {
                System.out.println("huh?");
            }
            BAC=new BoxAnalyzerCanvas(U);
            C.add(BAC,"South");
            C.validate();
            validate();
        }
        BAC.update();
    }
    
    public void hideBoxAnalyzer() {
        if (BAC!=null) {
            C.remove(BAC);
            C.validate();
            validate();
            BAC=null;
        }
    }
    
    /** This must be called when the containing popup is closed, so that
     * the manager no longer tries to contact these components. */
    public void removeManagement(){
        M.remove(UC);
        M.remove(U);
        M.remove(F);
    }
}
