import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class UnfoldControlCanvas extends DBCanvas implements MouseListener {
    Manager M;
    UnfoldCanvas U;
    FunctionCanvas F;
    UnfoldContainer UContainer;

    ListenSquare[] L=new ListenSquare[25];
    int mode,choice,override;
    int[] t=new int[4];
    int select;
    int[] v1=new int[5];
    int[] v2=new int[5];
    int dyadic;

    public UnfoldControlCanvas(Manager M, UnfoldCanvas U, FunctionCanvas F) {
        // Add the Manager
        this.M=M;
        
        // Add UnfoldCanvas
        this.U=U;
        
        // Add FunctionCanvas
        this.F=F;
        
        
        addMouseListener(this);

	 /**color info*/
	 L[1]=new ListenSquare(68,0,12,12,Color.white);	 
	 /**colors*/
	 L[2]=new ListenSquare(16,16,12,12,new Color(0,50,50));
	 L[3]=new ListenSquare(2,16,12,12,new Color(0,120,120));
	 L[4]=new ListenSquare(2,30,12,12,new Color(0,200,200));
	 L[5]=new ListenSquare(2,44,12,12,Color.white);
	 L[6]=new ListenSquare(2,58,12,12,new Color(255,255,0));
	 L[7]=new ListenSquare(16,58,12,12,new Color(255,0,255));  
	 L[8]=new ListenSquare(16,44,12,12,Color.black);	

	 L[2].on=1;
	 L[3].on=1;
	 L[4].on=1;
	 L[5].on=1;
	 L[6].on=1;
	 L[7].on=1;	 
         L[8].on=1;

         L[9]=new ListenSquare(2,72,12,12,Color.white);
         L[19]=new ListenSquare(16,72,12,12,new Color(0,200,200));
         L[10]=new ListenSquare(16,30,12,12,Color.yellow);  
         L[20]=new ListenSquare(2,86,12,12,Color.yellow);  //leaders
         L[11]=new ListenSquare(2,2,12,12,Color.yellow);

	 /**spine controls*/

	 L[12]=new ListenSquare(2,121,37,18,new Color(0,150,0));
	 L[13]=new ListenSquare(41,121,36,18,new Color(0,150,0));
	 L[15]=new ListenSquare(2,103,30,16,new Color(0,200,0));  //spine
	 L[16]=new ListenSquare(34,103,28,16,new Color(0,200,0)); //function	

	 L[18]=new ListenSquare(65,104,12,12,Color.white);  //spine info
	 
         
	L[15].on=1;
	L[16].on=1;
	L[10].on=1;
	L[12].on=1;
	v1[0]=1;

	for(int i=1;i<5;++i) {
	    v1[i]=0;
	    v2[i]=0;
	}
	choice=0;
	mode=1;
	select=-1;
	dyadic=0;

    }

    // set this if it is contained in an UnfoldContainer
    public void addUnfoldContainer(UnfoldContainer UContainer){
        this.UContainer=UContainer;
    }


      public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      Dimension D=this.getSize();
      int h=D.height;
	/**color setup*/
        g.setColor(new Color(100,0,0));
	g.fillRect(0,0,80,h);
	g.setColor(Color.white);
	g.drawRect(0,0,80,h);



	for(int i=2;i<=8;++i) L[i].render(g,L[i].C);	

	L[9].render(g,Color.white);
	L[19].render(g,Color.white);
        L[10].render(g,new Color(50,100,255));
        L[20].render(g,new Color(50,100,255));
        L[11].render(g,Color.white);

	/**spine setup*/
        g.setColor(new Color(0,70,0));
	g.fillRect(0,100,80,h-100);
	g.setColor(Color.white);
	g.drawRect(0,100,80,h-100);

	L[12].render(g,new Color(0,0,0));	
        L[13].render(g,new Color(0,0,0));	
	L[15].render(g,new Color(0,100,0));
	L[16].render(g,new Color(0,100,0));

	L[1].infoRender(g);
        L[18].infoRender(g);

	g.setColor(Color.white);  
        g.setFont(new Font("Helvetica",Font.PLAIN,10));
	g.drawString("rescale",18,12);
        g.drawString("leaders y/n",18,96);

	g.drawString("edge/tri",34,26);
	g.drawString("strip",34,40);
	g.drawString("fg/bg",36,54);
	g.drawString("spines",34,68);
        g.drawString("set col",34,82);  

        g.drawString("spine",5,114);
        g.drawString("func",39,114);

        
        
	showAngles(g);
	showVertices(g);

	g.setColor(Color.white);
	g.drawRect(0,0,D.width-1,D.height-1);
    }




    public void resetSpine() {
	eraseMarks();
	for(int i=1;i<=3;++i) {v1[i]=0;v2[i]=0;}
    }





    public void showAngles(Graphics g) {
	g.setColor(new Color(0,50,0));
	g.fillRect(2,142,75,18);	
        g.setColor(new Color(0,255,0));
	g.drawRect(2,142,75,18);
	int n=U.W.length();

	if((choice>0)&&(select<=n)) {
	  CombinatorialTriangle T=CombinatorialTriangle.copy(U.CT[select]);
	  g.setColor(Color.white);
	  if(choice==1) {
	    Integer I0=new Integer(T.b[0]);
	    Integer I1=new Integer(T.b[1]);
	    Integer I2=new Integer(T.b[2]);
	    g.drawString(I0.toString(),5,155);
            g.drawString(I1.toString(),30,155);
            g.drawString(I2.toString(),55,155);
	  }

	  if((choice>1)&&(choice<=4)) {
	      int[] m=new int[3];
	      if(choice==2) m=T.d[2];
	      if(choice==3) m=T.d[0];
	      if(choice==4) m=T.d[1];
            Integer I0=new Integer(m[0]);
	    Integer I1=new Integer(m[1]);
            g.drawString(I0.toString(),5,155);
            g.drawString(I1.toString(),45,155);
	  }


	  if(choice>4) {
          String S=new String();   
	  int[] m=Spine.typeToCoords(T,choice-5);
	      if(m[0]==1) S="a";
	      if(m[0]==2) S="b";
	      Integer I1=new Integer(m[1]);
              g.drawString(S,4,155);
              g.drawString(I1.toString(),11,155);
	      int q=Spine.coordsToType(T,m[0]);
	      Integer I2=new Integer(q);  
              g.drawString(I2.toString(),70,155);

	  }
	}
    }

    public void showVertices(Graphics g) {
	      g.setColor(Color.white);
	      String S1=new String();

	      Integer I1=new Integer(v1[3]);
	      if(v1[1]==1) S1="a";
	      if(v1[1]==2) S1="b";
	      if(v1[3]>0) {
		  g.drawString(S1,4,133);
		  g.drawString(I1.toString(),11,133);
	      }

	      String S2=new String();
	      Integer I2=new Integer(v2[3]);
	      if(v2[1]==1) S2="a";
	      if(v2[1]==2) S2="b";
	      if(v2[3]>0) {
		  g.drawString(S2,44,133);
		  g.drawString(I2.toString(),51,133);
	      }

    }



    public void recolor(Point X,int n) {
	if(n>0) {
	    Color C=L[5].C;
	    Complex B=U.B;
	    double A=U.A;
	  choice=0;
	  for(int i=n+1;i>0;--i) {
	    if(choice==0) {
		if(L[15].on==0) choice=U.T[i].modify(A,B,X,C,4);
		if(L[15].on==1) choice=U.T[i].modify(A,B,X,C,8);
	        if(choice>0) select=i;
	    }
	  }
	
	  if(select>0) {

	  CombinatorialTriangle T=CombinatorialTriangle.copy(U.CT[select]);
          int[] m=new int[3];
	  if(choice>4) {
	    m=Spine.typeToCoords(T,choice-5);

            if(v1[0]==1) {
	      v1[1]=m[0];     //up or down
	      v1[2]=select;   //triangle number
              v1[3]=m[1];     //vertex number
              v1[4]=choice-5;
	    }

            if(v1[0]==2) {
	       v2[1]=m[0];
	       v2[2]=select;
               v2[3]=m[1];
               v2[4]=choice-5;
	    }
	  }
	  }
	  repaint();
	}
    }


   public void mouseEntered(MouseEvent e) {} 
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mouseClicked(MouseEvent e) {
      e.consume();
      Point X=new Point();
      X.x=e.getX();
      X.y=e.getY();


      if(L[11].inside(X)==1) {            
          U.A=1.0;
          U.B=new Complex();
      }

      for(int j=2;j<=7;++j) {
       
      if(L[j].inside(X)==1) {
	  L[j].C=M.getColor();
	  U.doUnfold();
      }
      }

      if(L[8].inside(X)==1) {
	  L[8].C=M.getColor();
	  U.setBackground(L[8].C);
      }

      if(L[9].inside(X)==1) {
	  L[2].C=new Color(170,170,170);  
	  L[3].C=new Color(100,100,100);
	  L[4].C=new Color(50,50,50);
	  L[5].C=Color.black;
          L[6].C=new Color(80,80,80);
          L[7].C=new Color(110,110,110);
	  L[8].C=Color.white;
	  eraseMarks();
	  U.setBackground(Color.white);
	  U.doUnfold();
      }

      if(L[19].inside(X)==1) {
	  L[2].C=new Color(0,50,50);
	  L[3].C=new Color(0,120,120);
	  L[4].C=new Color(0,200,200);
          L[5].C=new Color(0,120,255);
          L[6].C=new Color(255,255,0);
          L[7].C=new Color(255,0,255);
	  L[8].C=Color.black;
	  eraseMarks();
	  U.setBackground(Color.black);
	  U.doUnfold();
      }

      if(L[10].inside(X)==1) L[10].on=1-L[10].on;
      if(L[20].inside(X)==1) L[20].on=1-L[20].on;

      if(L[12].inside(X)==1) {L[12].on=1;L[13].on=0;v1[0]=1;}
      if(L[13].inside(X)==1) {L[12].on=0;L[13].on=1;v1[0]=2;}

      if(L[18].inside(X)==1) document1();
      if(L[1].inside(X)==1) document2();

      if(L[15].inside(X)==1) L[15].on=1-L[15].on;

      if(L[16].inside(X)==1) {
	  // function button
	  L[16].on=1-L[16].on;
	  if (UContainer!=null)
	      if (L[16].on==1)
		  UContainer.showFunction();
                else
                    UContainer.hideFunction();
      }
      repaint();
      U.repaint();
      
      }


    VertexPair getCurrent() {
       VertexPair V=new VertexPair(v1[1],v1[2],v2[1],v2[2]);
       return(V);
    }


    public void  spineFunction() {
      if((v1[0]>0)&&(v1[1]*v2[1]>0)) {
        if(L[15].on==1) {doSpine();}
	if(L[16].on==1) {
	    VertexPair V=getCurrent();
	    U.T[v1[2]].on[5+v1[4]]=1;  
            U.T[v2[2]].on[5+v2[4]]=1;
	    doFunction(V);
	    F.repaint();
	}
      }
    }



    public void eraseMarks() {  
          for(int i=0;i<=U.W.length();++i) {
	      for(int j=0;j<=8;++j) U.T[i].on[j]=0;
	      for(int j=1;j<=3;++j) U.T[i].C[j]=L[3].C;
	  }
    }

    public void doSpine() {
	int test=Spine.palindromeTest(U.CT);

	if((v1[1]>0)&&(v1[1]*v2[1]>0)) {
	    VertexPair V=new VertexPair(v1[1],v1[2],v2[1],v2[2]);
	    eraseMarks();
	    U.T[v1[2]].on[5+v1[4]]=1;  
            U.T[v2[2]].on[5+v2[4]]=1;

	    int LL=U.W.length();
            int spine=Spine.spineNumber(V,U.CT);
	    int[] n=Spine.computeSpine(V,U.CT); 
	   
	    int sp=0;
	    if(spine==2) sp=2;
	    if(spine==1) sp=1;
	    if(spine==0) sp=3;

	    
	    if(test==0) {

		/**denominator - not computed in palindrome case*/
            int[] d=Spine.fullSpine(spine,U.CT);   
	    for(int i=1;i<=d[0];++i) {
	       U.T[d[i]].on[sp]=2;
	       U.T[d[i]].C[sp]=L[7].C;
	       if(U.CT[d[i]+1].c[0]==spine)   { 
                   U.T[d[i]+1].on[sp]=2;
	           U.T[d[i]+1].C[sp]=L[7].C;
	       }
	    }
	    }

	    /**numerator*/
	    for(int i=1;i<=n[0];++i) {
	       U.T[n[i]].on[sp]=1;
	       U.T[n[i]].C[sp]=L[6].C;
	       if(U.CT[n[i]+1].c[0]==spine)   { 
                   U.T[n[i]+1].on[sp]=1;
	           U.T[n[i]+1].C[sp]=L[6].C;
	       }
	    }

	}
    }


    public void doFunction(VertexPair V) {
	    int L=M.getWordLength();
	    int test=Spine.palindromeTest(U.CT);
	    if(test==0) doRegularFunction(V);
	    if(test==1) doPalindromeFunction(V);
    }


   public void doRegularFunction(VertexPair V) {

	    int[][] n=Function.computeNumerator(V,U.CT);   
            int[][] d=Function.computeDenominator(V,U.CT);
	    int sign=Function.getSign(n[0][1],d);

	    F.n[0][0]=n[0][0];  
	    for(int j=0;j<=3;++j) {
	    for(int i=0;i<=n[0][0];++i) {
		if(j<3)   F.n[j][i]=n[j][i];
		if(j==3)  F.n[j][i]=sign*n[j][i];
		if(j<3)   F.N[j][i]=new Integer(n[j][i]);
		if(j==3)  F.N[j][i]=new Integer(sign*n[j][i]);
	    }}

	    F.d[0][0]=d[0][0];
	    for(int j=0;j<=3;++j) {
	    for(int i=0;i<=d[0][0];++i) {
		F.d[j][i]=d[j][i];
		F.D[j][i]=new Integer(d[j][i]);
	    }}

            int[][] f=Function.foil(F.n,F.d);
	    F.f[0][0]=f[0][0];
	    for(int j=0;j<=2;++j) {
	    for(int i=1;i<=f[0][0];++i) {
		F.f[j][i]=f[j][i];
		F.F[j][i]=new Integer(f[j][i]);
	    }}
   }
    




   public void doPalindromeFunction(VertexPair V) {
            F.palindrome=1;
	    int[][] f=PalindromeFunction.getFunction(V,U.CT);

	    F.n[0][0]=f[0][0];  
	    for(int j=1;j<=3;++j) {
	    for(int i=0;i<=f[0][0];++i) {
		F.n[j][i]=f[j-1][i];
	        F.N[j][i]=new Integer(f[j-1][i]);
	    }}

	    F.d[0][0]=0;

	    F.f[0][0]=f[0][0];
	    for(int j=0;j<3;++j) {
	    for(int i=1;i<=f[0][0];++i) {
		F.f[j][i]=f[j][i];
		F.F[j][i]=new Integer(f[j][i]);
	    }}
   }





    public void document1() {
	M.setExplain("This green console displays the combinatorial information associated to the triangles in the unfolding. We use this combinatorial information to build the functions which tell us the difference in heights of pairs of vertices. We call these functions the 'defining functions'. \n\n The display just to the left of this info button shows the combinatorial data associated to each of the three kinds of objects in the unfolding: vertices, edges, and triangles. \n\n Vertices: The vertices running along the top of the unfolding are labelled as b1,b2,b3... and the vertices running along the bottom of the unfolding are labelled as a1,a2,a3... when you select a vertex on the unfolding, you see the label of the vertex you have selected.\n\n edges:  Each edge has associated to it a pair of integers (A,B) called its turning pair.  Assuming that we are at the point (x,y) in parameter space, the line through the first edge must be rotated through an angle of \n\n (Ax+By) times Pi/2 \n\n to become parallel to the edge in question.  Here we measure the angle mod Pi. When you select and edge on the unfolding the turning angles are displayed. \n\n Triangles:  Each triangle has associated to it a triple of integers. The triple of integers describes the location in the hexagonal grid of the word path associated to the word. The turning angle of an edge is computed from the triple of integers associated to either of the two triangles which contains the edge.  (The formula is easier to see if we multiply the turning angles by 3.) When you click on a triangle, the triple of integers is displayed.\n\n The two windows at the right hand side of this console give you a mechanism to select a pair of vertices.  If you click on one of these windows and then click on a vertex you assign that vertex to the window.  By doing this for both windows you select a pair of vertices. Once you select a pair of vertices, several things are computed:\n\n If the 'spine' button is on then you see a path of thick edges connecting the two vertices.  You also see a thinner path which runs across the whole picture. We call these paths the spines.  The spines are used, in conjunction with the turning numbers discussed above, to compute the defining function for the pair of vertices.  In brief, the thick part of the spine determines an exponential sum P and then the thin part determines an exponential sum Q.  The defining function is then the imaginary part of P times Q-conjugate.\n\n If the 'function' button is on, you will see the defining function displayed below in shorthand notation. You will also see the value of the defining function evaluated at the selected point in parameter space. ");
    }



    public void document2() {
	M.setExplain("This window allows you to globally recolor the unfolding.  There are 6 colors you can select: \n\n The triangle color;\n\n the outline color; \n\n the color of the strip which appears when the unfolding has straight line corresponding to periodic billiard path;\n\n the background color; \n\n the colors of the two kinds of spines. (The info buttons in the green console below explain these spines.)\n\n  At any time you can either reset the colors or else change them to grays.  You can also make the strip invisible, and rescale the unfolding to fit exactly in the rectangle.");
    }


    public void document3() {
	M.setExplain("When we compute the defining functions for the vertices, we use the convention that the function measures the y coordinate of the right vertex minus the y coordinate of the left vertex.  Here left and right refer to the positions of the vertices along the spine connecting them.  However, when one of the vertices lies on the top of the unfolding and the other one lies along the bottom we would like to allow for a different convention: We compute the y coordinate of the top vertex minus the y coordinate of the bottom vertex. Here top and bottom are meant in the combinatorial sense: the top vertices are the vertices b1,b2,... and the bottom vertices are the vertices a1,a2...  If all the defining functions for such pairs are positive, then the geometric and combinatorial notions of top and bottom always coincide, and the word represents a periodic billiard path for the given triangle. The 'sign override' button, when turned on, overrides our normal convention in favor of the top/bottom convention.");
    }


}
