/*
 * SpaceCanvas.java
 *
 * Created on October 29, 2005, 8:53 AM
 */

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author  pat
 */
public class WhereAmICanvas extends DBCanvas implements
HearingSpaceChange, MouseListener {
    
    Manager M;
    
    // the view being highlighted
    Rectangle2D.Double view;
    
    // This Affine Transform takes the viewing area to the [0,1]x[0,1] unit square.
    AffineTransform square;
    // This controls user zooming of the canvas
    AffineTransform zoom;
    // The resulting transform used for drawing
    AffineTransform transform;
    // The inverse of transform
    AffineTransform inverse;
    
    
    ////////// OBJECTS
    ListenSquare Doc;
    
    // used for painting
    private Image offscreen;
    private int width;
    private int height;
    
    // used when a redraw is needed
    boolean forceRedraw=false;
    
    /** Creates a new instance of SpaceCanvas */
    public WhereAmICanvas(Manager M) {
        this.M=M;
        M.hearSpaceChange(this);
        
        setFont(new Font("sanserif", Font.PLAIN, 12));
        
        // set width and height to dummy values:
        width=height=0;
        
        zoom=new AffineTransform();
        
        ////////// COLORS
        setBackground(new Color(0,0,50));
        
        ////////// OBJECTS
        Doc=new ListenSquare(0,0,12,12,Color.black);
        Doc.on=1;
        
        view=M.getViewingRectangle();
        
        addMouseListener(this);
    }
    
    /** Reset the main AffineTransform
     * This should be called after zooming in or out
     * and after resizing the canvas */
    public  void resetTransform(){
        transform=new AffineTransform(square);
        transform.concatenate(zoom);
        try {
            inverse=transform.createInverse();
        } catch (Exception e) {
            System.out.println("Non-invertible transform exception. This error should never happen");
        }
    }
    
    /** Create the AffineTransform, square,
     * which sends the [0,1]x[0,1] square to the interior of canvas.
     * It adds a 5% border.
     */
    public  void resetSquare(){
        int width=this.width-1, height=this.height-1;
        
        // set transform to be the identity affine transform
        square=new AffineTransform();
        
        int size;
        if (width<height)
            size=width;
        else
            size=height;
        
        // STEP 2:
        // translate the [0,w]x[0,h] box to the viewing area
        // [0,w]x[0,h].
        square.translate(0, // x component
        size+0); //  y component
        
        // STEP 1:
        // scale the [0,1]x[0,1] box to the width of the canvas
        // these function takes double values!
        square.scale(size, // scale in the x direction
        -size ); // scale in the y direction
        
        resetTransform();
    }
    
    public  void paint(Graphics gfx) {
        if ((offscreen==null)||(width!=getWidth())||(height!=getHeight()))
            forceRedraw=true;
        if (forceRedraw) {
            changed();
            forceRedraw=false;
        }
        gfx.drawImage(offscreen, 0, 0, this);
        
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON); { // Render the rectangle
            GeneralPath gp=new GeneralPath(GeneralPath.WIND_EVEN_ODD);
            gp.moveTo(0,0);
            gp.lineTo(1,0);
            gp.lineTo(1,1);
            gp.lineTo(0,1);
            gp.closePath();
            gp.moveTo((float)view.x,(float)view.y);
            gp.lineTo((float)view.getMaxX(),(float)view.y);
            gp.lineTo((float)view.getMaxX(),(float)view.getMaxY());
            gp.lineTo((float)view.x,(float)view.getMaxY());
            gp.closePath();
            
            g.setColor(new Color(255,255,255,127));
            Shape S;
            g.fill(S=transform.createTransformedShape(gp));
            g.setColor(Color.white);
            g.draw(S);
            
            g.setColor(Color.blue);
            
            g.draw(transform.createTransformedShape(
            new Line2D.Double(0,view.y,view.x,view.y)));
            g.draw(transform.createTransformedShape(
            new Line2D.Double(0,view.getMaxY(),view.x,view.getMaxY())));
            
            g.draw(transform.createTransformedShape(
            new Line2D.Double(view.getMaxX(),view.y,1,view.y)));
            g.draw(transform.createTransformedShape(
            new Line2D.Double(view.getMaxX(),view.getMaxY(),1,view.getMaxY())));
            
            g.draw(transform.createTransformedShape(
            new Line2D.Double(view.x,0,view.x,view.y)));
            g.draw(transform.createTransformedShape(
            new Line2D.Double(view.getMaxX(),0,view.getMaxX(),view.y)));
            
            g.draw(transform.createTransformedShape(
            new Line2D.Double(view.x,view.getMaxY(),view.x,1)));
            g.draw(transform.createTransformedShape(
            new Line2D.Double(view.getMaxX(),view.getMaxY(),view.getMaxX(),1)));
            
            
        }{ // Render the button
            Doc.infoRender(g);
        }
    }
    
    public  void changed() {
        if (offscreen!=null)
            offscreen.flush();
        if ((width!=getWidth())||(height!=getHeight())){
            width=getSize().width;
            height=getSize().height;
            resetSquare();
        }
        offscreen = createImage(getSize().width, getSize().height);
        Graphics g2 = offscreen.getGraphics();
        Graphics2D g=(Graphics2D) g2;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        M.render(g, transform);
        g.dispose();
        g2.dispose();
    }
    
    public  void spaceChanged() {
        forceRedraw=true;
        repaint();
    }
    
    public  void setViewingRectangle(Rectangle2D.Double rect) {
        view=rect;
        repaint();
    }
    
    public void mouseClicked(MouseEvent e) {
        if (Doc.inside(new Point(e.getX(), e.getY()))==1){
            M.setExplain("This window allows you to keep track of what portion of the parameter space you are looking at.");
            return;
        }
        
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
}
