import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;




public class WordIcon {
    int x,y,w,h,mode,on;
    String W;
    public WordIcon(int x,int y,int w,int h,String W,int mode) {
	this.x=x;
	this.y=y;
	this.h=h;
	this.w=w;
	this.W=W;
	this.mode=mode;
	this.on=0;
    }


    public static Complex[] rawPath(String W) {

	Complex[] V=new Complex[1000];
	String S=new String();
	double pi=Math.PI;
	double arg1=pi/6+pi/2;
	double arg2=arg1+2*pi/3;
	double arg3=arg2+2*pi/3;

	Complex v1=new Complex(Math.cos(arg1),Math.sin(arg1));
	Complex v2=new Complex(Math.cos(arg2),Math.sin(arg2));
	Complex v3=new Complex(Math.cos(arg3),Math.sin(arg3));
	Complex v4=new Complex(0,0);
	Complex v5=new Complex(0,0);
	Complex vv=new Complex(0,0);

	int n=W.length();
	for(int i=0;i<n;++i) {
	 S=W.substring(i,i+1);
         if(S.compareTo("1")==0) {vv.x=v1.x;vv.y=v1.y;}
	 if(S.compareTo("2")==0) {vv.x=v2.x;vv.y=v2.y;}
	 if(S.compareTo("3")==0) {vv.x=v3.x;vv.y=v3.y;}

	 if(i%2==1) {vv.x=-vv.x;vv.y=-vv.y;}
	 v4.x=v4.x+vv.x;
	 v4.y=v4.y+vv.y;
	 V[i]=new Complex(v4.x,v4.y);
	}
	V[n]=new Complex(V[0].x,V[0].y);
	return(V);
    }


    /**this routine finds the bounding box of the raw path, and
       also computes the center of the b.box*/

    public Complex[] getLocation(Complex[] V,int n) {
	double mx,my,Mx,My;
      mx=1000000;
      my=1000000;
      Mx=-1000000;
      My=-1000000;
      for(int i=0;i<n;++i) {
	if(mx>V[i].x) mx=V[i].x;
	if(Mx<V[i].x) Mx=V[i].x;
	if(my>V[i].y) my=V[i].y;
	if(My<V[i].y) My=V[i].y;
      }
      Complex[] Z=new Complex[2];
      Z[0]=new Complex(Mx-mx,My-my);
      Z[1]=new Complex((Mx+mx)/2.0,(My+my)/2.0);
      return(Z);
    }



    public int oddSquareTest() {
	int N=W.length();
	int d2=-1;
	int d1=-1;
	for(int i=0;i<N;++i) {
	    d1=Spine.getDigit(W,i);
	    d2=Spine.getDigit(W,i+N/2);
	    if(d1!=d2) return(0);
	}
	return(1);
    }


    public int palindromeTest() {
	CombinatorialTriangle[] CT=CombinatorialTriangle.unfold(W);
	int palindrome=Spine.palindromeTest(CT);
	return(palindrome);
    }




    /**here is the main routine*/

    public void pathRender(Graphics2D g,Color C1,Color C2,Color C3,Color C4,Color C5,Color C6,Color C7,Color C8,Color C9,Color C10,Color C11) {
	int n=W.length();




	if(n>0) {
        g.translate(x,y);

	int palindrome=palindromeTest();
	int oddsquare=oddSquareTest();

	if(oddsquare+palindrome==0) {
	if(on==0) g.setColor(C1);
	if(on==1) g.setColor(C2);
	g.fillRect(0,0,w,h);
	if(on==0) g.setColor(C2);
	if(on==1) g.setColor(C3);
        g.drawRect(0,0,w,h);
	}


	if(palindrome==1) {
	if(on==0) g.setColor(C6);
	if(on==1) g.setColor(C7);
	g.fillRect(0,0,w,h);
	if(on==0) g.setColor(C7);
	if(on==1) g.setColor(C8);
        g.drawRect(0,0,w,h);
	}


	if(oddsquare==1) {
	if(on==0) g.setColor(C9);
	if(on==1) g.setColor(C10);
	g.fillRect(0,0,w,h);
	if(on==0) g.setColor(C10);
	if(on==1) g.setColor(C11);
        g.drawRect(0,0,w,h);
	}



	Complex[] V=rawPath(W);
	Complex[] Z=getLocation(V,n);
	double size=Z[0].x;
	if(size<Z[0].y) size=Z[0].y;
	int bb=w;
	if(bb>h) bb=h;
	size=bb/size;
	size=size*.95;

	double xx=Z[1].x;
	double yy=Z[1].y;
	g.setColor(C5);
	float x1,y1,x2,y2;

	GeneralPath path=new GeneralPath();
	x1=(float)((V[0].x-xx)*size+w/2);
	y1=(float)((V[0].y-yy)*size+h/2);
            path.moveTo(x1,y1);

	for(int i=0;i<n;++i) {
	    x2=(float)((V[i+1].x-xx)*size+w/2);
	    y2=(float)((V[i+1].y-yy)*size+h/2);
            path.lineTo(x2,y2);
	}

            g.draw(path);
       
	Integer I=new Integer(n);

        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	if(mode==0)	g.drawString(I.toString(),1,h+13);
	if(mode==1)	g.drawString(I.toString(),1,-4);
	if(mode==2)     g.drawString(I.toString(),h+8,h-2);
        g.translate(-x,-y);
    }
	
    }


    public int inside(Point p) {
        int test=0;
	if((p.x>x)&&(p.x<x+w)&&(p.y>y)&&(p.y<y+h)) test=1;
	return(test);
    }






}


