/*
 * BLikeTile.java
 *
 * Created on December 8, 2005, 7:43 AM
 */

import java.awt.*;
import java.awt.geom.*;
import java.util.TreeSet;

/**
 * This class stores and manipulates data for the Billiard-Like tiles.
 *
 * Eventually, I want this to store some addition data. Namely, the
 * rational lines that form the boundary components.
 *
 * @author  pat
 */
public class BLikeTile implements Tile {
    public String W;
    public GeneralPath GP;
    public Color C;
    
    /** initialize everything yourself! */
    private BLikeTile(){}
    
    /** "Plots the BLike Tile"
     * That is, it creates something that is plotable from a word 
     * Returns null in case the tile is the null set. */
    public static BLikeTile plot(String word, Color C, Interrupter I){
        BLikeTile t=new BLikeTile();
        t.W=word;
        t.C=C;
        
        LoopWord w=new LoopWord(word);
        HolonomyPosition[] hol=w.createHolonomy();
        TreeSet[][] leftOf=w.createLeftOf();
        PatConvexHull ch=w.computeTile(hol,leftOf);
        if (ch==null) {
            return null;
        }
        t.GP=ch.toGeneralPath();
        return t;
    }
    
    public String getStringWord() {
        return W;
    }
    
    public boolean isPaintable() {
        return true;
    }
    
    public boolean isSaveable() {
        return true;
    }
    
    
    public void paint(Graphics2D g, AffineTransform T) {
        g.setColor(C);
        g.fill(T.createTransformedShape(GP));
        g.setColor(Color.black);
        g.draw(T.createTransformedShape(GP));        
    }
    
    public void paintSelected(Graphics2D g, AffineTransform T) {
        g.setColor(C);
        g.fill(T.createTransformedShape(GP));
        g.setColor(Color.white);
        g.setStroke(new BasicStroke((float)2.0));
        g.setColor(Color.white);
        g.draw(T.createTransformedShape(GP));
        g.setStroke(new BasicStroke((float)1.0));
    }
    
    public String saveString() {
        return
        "START BLike\n"+
        "WORD "+W+"\n"+
        "END";
    }
    
    public Rectangle2D getBounds() {
        return GP.getBounds2D();
    }
    
    public boolean contains(double x, double y) {
        return GP.contains(x,y);
    }
    
    public void setColor(Color C) {
        this.C=C;
    }
    
}
