/*
 * BasicMath.java
 *
 * Created on October 28, 2005, 11:05 AM
 */

/**
 * This class contains some static functions that do some basic mathematics.
 *
 * @author  pat
 */
public final class BasicMath {
    
    /** gcd of two integers */
    public static int gcd(int a, int b){
        while (true){
            if (b==0)
                return a;
            a=a%b;
            if (a==0)
                return b;
            b=b%a;
        }
    }
    
    /** gcd of all the integers in an array */
    public static int gcd(int[] x){
        if (x.length==1)
            return x[0];
        int g=gcd(x[0],x[1]);
        for (int i=2; i<x.length; i++)
            g=gcd(g, x[i]);
        return g;
    }
    
    /** reduce an integer array by division by the positive gcd */
    public static void reduceByGcd(int[] x){
        int g=gcd(x);
        if (g<0)
            g=-g;
        if (g!=0)
            for (int i=0; i<x.length; i++){
                x[i]/=g;
            }
    }
    
    /** Standard cross product of two points in Z^3 */
    public static int[] cross(int[] a, int[] b){
        int[] ret=new int[3];
        ret[0]=a[1]*b[2]-a[2]*b[1];
        ret[1]=a[2]*b[0]-a[0]*b[2];
        ret[2]=a[0]*b[1]-a[1]*b[0];
        return ret;
    }
    
    /** Standard euclidean dot product */
    public static int dot(int[] a, int[] b){
        int ret=0;
        for (int i=0; i<a.length; i++)
            ret+=a[i]*b[i];
        return ret;
    }
    
    /** Return -1 if x is negative, 1 if positive, and 0 if zero. */
    public static int sign(int x) {
        if (x<0)
            return -1;
        if (x>0)
            return 1;
        return 0;
    }
    
}
