/*
 * BasicSearchCanvas.java
 *
 * Created on October 30, 2005, 10:19 AM
 */

import java.awt.*;
import java.awt.event.*;
/**
 *
 * @author  pat
 */
public class BasicSearchCanvas extends DBCanvas
implements BasicSearcher, MouseListener, KeyListener, FocusListener{
    Manager M;
    
    SearchControl SC;
    
    ListenString seek, depthButton, seekType, doc;
    
    // Colors
    Color buttonBg, buttonFg;
    Color interruptBg, interruptFg;
    
    boolean active=false;
    
    // constants
    static final int padding=5;
    
    /** Creates a new instance of BasicSearchCanvas */
    public BasicSearchCanvas(Manager M) {
        this.M=M;
        SC=new SearchControl(M,this);
        
        setFont(new Font("sanserif", Font.PLAIN, 12));
        
        setBackground(new Color(100,0,100));
        buttonBg=new Color(255,80,255);
        buttonFg=Color.black;
        interruptBg=Color.red;
        interruptFg=Color.white;
        
        
        double x=padding,y=padding;
        seekType=new ListenString(SC.getSearchType(),SC.seek_types, this);
        seekType.setLeft(x);
        seekType.setTop(y);
        seekType.setColors(buttonFg, buttonBg);
        
        x=seekType.getRight()+padding;
        doc=new ListenString("?", this);
        doc.setLeft(x);
        doc.setTop(y);
        doc.setColors(buttonFg, buttonBg);
        
        x=padding;
        y=seekType.getBottom()+padding;
        seek=new ListenString("seek", this);
        seek.setLeft(x);
        seek.setTop(y);
        seek.setColors(buttonFg, buttonBg);
        
        x=seek.getRight()+padding;
        depthButton=new ListenString("2798", this);
        depthButton.setLeft(x);
        depthButton.setTop(y);
        depthButton.setColors(buttonFg, buttonBg);
        
        int depth=50;
        depthButton.str=""+depth;
        SC.setDepth(depth);
        
        addMouseListener(this);
        addKeyListener(this);
        addFocusListener(this);
    }
    
    /** set the canvas size to its minimal appropriate size. */
    public void setSize(){
        setSize(
        (int)(doc.getRight()+padding),
        (int)(depthButton.getBottom()+padding));
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        //g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
        //RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        
        doc.render(g);
        seekType.render(g);
        seek.render(g);
        depthButton.render(g);
        Dimension D=getSize();
        g.setColor(new Color(255,0,255));
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    public void doneBasicSearch(BasicSearchResults list) {
        if (list!=null) {
            M.setBasicResults(list);
        } else {
            System.err.println("Search Failed.");
        }
        seek.setColors(buttonFg, buttonBg);
        seek.str="seek";
        repaint();
    }
    
    public void toggleState() {
        active=!active;
        if (active) {
            depthButton.setColors(buttonFg, Color.white);
        } else {
            depthButton.setColors(buttonFg, buttonBg);
        }
    }
    
    public void mouseClicked(MouseEvent e) {
        if (depthButton.contains(e.getX(),e.getY())) {
            toggleState();
            repaint();
            return;
        }
        if (seekType.contains(e.getX(),e.getY())) {
            SC.inc();
            seekType.str=SC.getSearchType();
            repaint();
            return;
        }
        if (seek.contains(e.getX(),e.getY())) {
            if (SC.searching()){
                SC.interrupt();
                seek.str="seek";
                seek.setColors(buttonFg, buttonBg);
                repaint();
            } else {
                SC.startSearch();
                seek.str="halt";
                seek.setColors(interruptFg, interruptBg);
                repaint();
            }
            return;
        }
        if (doc.contains(e.getX(),e.getY())) {
            M.setExplain("The top button allows you to select the type of search to do. The bottom button allows you to search, or cancel a search. You can select the search depth by entering a number on the keyboard after clicking in the box.");
        }
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void keyPressed(KeyEvent e) {
        //System.out.println("KeyPressed="+e.paramString());
    }
    
    public void keyReleased(KeyEvent e) {
        //System.out.println("KeyReleased="+e.paramString());
    }
    
    public void keyTyped(KeyEvent e) {
        if (active) {
            if (e.getKeyChar()==KeyEvent.VK_ENTER) {
                toggleState();
                repaint();
                return;
            }
            if (e.getKeyChar()==KeyEvent.VK_DELETE) {
                SC.setDepth(0);
                depthButton.str="0";
                repaint();
                return;
            }
            int depth=SC.getDepth();
            //System.out.println("KeyTyped="+e.paramString());
            if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE) {
                depth=depth/10;
            }
            int ch=(int)(e.getKeyChar()-'0');
            if ((ch>=0)&&(ch<10)){
                depth=10*depth+ch;
            }
            if (depth!= SC.getDepth()) {
                SC.setDepth(depth);
                depthButton.str=""+depth;
                repaint();
            }
        }
    }
    
    public void focusGained(FocusEvent e) {
    }
    
    public void focusLost(FocusEvent e) {
        if (active) {
            toggleState();
            repaint();
        }
    }
    
}
