import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class Certify {
    public Certify() {}



    /*****CERFIFICATE*****/
/*the goal of this routine is to tell
  if the gradient of a function, as
  it varies over a square in the 
  parameter space, lies in a quadrant.
  The values (grad1,grad2)
  give the gradient at the center of
  the point.  The terms (b1,b2)
  are bounds on the 2nd derivatives.
  These bounds guarantee that:

  grad1-bb1*r < grad1(x) <grad1+bb1*r
  grad2-bb2*r < grad2(x) <grad2+bb2*r

  where r is either the diam of the
  box or twice the diam, depending on
  which test we are using.  Here are the
  returns of the function:

  0 not certified
  1 certified, grad in ++ quadrant
  2 certified, grad in 0+ quadrant
  3 certified, grad in -+ quadrant
  4 certified, grad in -0 quadrant
  5 certified, grad in -- quadrant
  6 certified, grad in 0- quadrant
  7 certified, grad in +- quadrant
  8 certified, grad in +0 quadrant

  The bounds we use are contained in the array a[].
  a[0]=bound on partial xx
  a[1]=bound on partial xy
  a[2]=bound on partial yy
*/


    /**z not McScaled during routine. uses McB coordinates for z*/


    public static int certify(int sign,VertexPair V,CombinatorialTriangle[] CT,int[][] d,DyadicSquare Q,int[] a) {
        double grad1,grad2;
	grad1=Spine.gradient(sign,1,V,CT,d,Q.getCenter());
	grad2=Spine.gradient(sign,2,V,CT,d,Q.getCenter());
	return(doMainStep(grad1,grad2,a,Q.k));
    }


    /**This version uses some precomputed data about the denominator function*/

    public static int certify(int sign,VertexPair V,CombinatorialTriangle[] CT,Complex[] data,DyadicSquare Q,int[] a) {
        double grad1,grad2;
	grad1=Spine.gradient(sign,1,V,CT,data[0],data[9],Q.getCenter());
	grad2=Spine.gradient(sign,2,V,CT,data[0],data[10],Q.getCenter());
	return(doMainStep(grad1,grad2,a,Q.k));
    }




    /**Now that we have the basic first and second derivatives computed,
       the rest is algebra*/


    public static int doMainStep(double grad1,double grad2,int[] a,int k) {
	double[] x=new double[8];
        double step,a1,a2,b1,b2;

   //test standard quadrant:

        step=Math.PI*Math.pow(0.5,k+2);  //square radius
        a1=a[0]+a[1];
        a2=a[1]+a[2];
        b1=step*a1;
        b2=step*a2;

        x[1]=0;x[2]=0;x[3]=0;x[4]=0;
        if((grad1+b1>0)&&(grad1-b1>0)) x[1]=1;
        if((grad2+b2>0)&&(grad2-b2>0)) x[2]=1;
        if((grad1+b1<0)&&(grad1-b1<0)) x[3]=1;
        if((grad2+b2<0)&&(grad2-b2<0)) x[4]=1;

        if((x[1]>0)&&(x[2]>0)) return(1);
        if((x[2]>0)&&(x[3]>0)) return(3);
        if((x[3]>0)&&(x[4]>0)) return(5);
        if((x[4]>0)&&(x[1]>0)) return(7);

       //standard quadrant test has failed.
       //now we look at a square twice as
       //large and try to show that the gradient
       //lies in some quadrant.

       step=Math.PI*Math.pow(0.5,k+1); //twice square radius
       a1=Math.max(a[0],a[1]);
       a2=Math.max(a[1],a[2]);
       b1=step*a1;
       b2=step*a2;

       x[1]=grad1+b1;
       x[2]=grad2+b2;
       x[3]=grad1-b1;
       x[4]=grad2-b2;

       x[5]=Math.abs(x[1]);
       if(x[5]<Math.abs(x[3])) x[5]=Math.abs(x[3]);
       x[6]=Math.abs(x[2]);
       if(x[6]<Math.abs(x[6])) x[6]=Math.abs(x[4]);
       if(( x[2]>x[5])&&( x[4]>x[5]))   return(2);
       if((-x[1]>x[6])&&(-x[3]>x[6])) return(4);
       if((-x[2]>x[5])&&(-x[4]>x[5]))   return(6);
       if(( x[1]>x[6])&&( x[3]>x[6])) return(8);
       return(0);
    }




}


