import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class ColorSelectorCanvas extends DBCanvas implements MouseListener {
    Manager M;
    ListenSquare[] R=new ListenSquare[16];
    ListenSquare[] G=new ListenSquare[16];
    ListenSquare[] B=new ListenSquare[16];
    ListenSquare DO;
    Color C;

    public ColorSelectorCanvas(Manager M, int W,int H) {
        // setup the manager
        this.M=M;
        
        addMouseListener(this);
	double x=0;
	double y=0;
	double w=W/3.0;
	double h=H/18.0;

	for(int i=0;i<16;++i) {
	    y=i*h*1.0;
	    R[i]=new ListenSquare(0,y,w,h,Color.gray);
	}

	for(int i=0;i<16;++i) {
	    y=i*h*1.0;
	    G[i]=new ListenSquare(1*w,y,w,h,Color.gray);
	}

	for(int i=0;i<16;++i) {
	    y=i*h*1.0;
	    B[i]=new ListenSquare(2*w,y,w,h,Color.gray);
	}

	DO=new ListenSquare(0,H-13,12,12,Color.black);
	DO.on=1;

	/**initial choices*/
	R[15].on=1;
	G[0].on=1;
	B[15].on=1;
	C=new Color(255,0,255);
        // tell M about the current color
        M.setColor(C);
   }



    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      computeColor();
      g.setColor(C);   
      Dimension D=this.getSize();
      g.fillRect(0,8*D.height/9,D.width,D.height/9);

      for(int i=0;i<16;++i)  R[i].renderSmooth(g,Color.red);
      for(int i=0;i<16;++i)  G[i].renderSmooth(g,Color.green);
      for(int i=0;i<16;++i)  B[i].renderSmooth(g,new Color(50,100,255));

      g.setColor(Color.white);
      g.drawRect(0,0,D.width-1,D.height-1);
      DO.infoRender(g);

    }

    public void computeColor() {
	int r=0;
	int g=0;
	int b=0;

	for(int i=0;i<16;++i) {
	    if(R[i].on==1) r=16*i+15;
	}

	for(int i=0;i<16;++i) {
	    if(G[i].on==1) g=16*i+15;
	}

	for(int i=0;i<16;++i) {
	    if(B[i].on==1) b=16*i+15;
	}

	C=new Color(r,g,b);
        // tell M about the new Color
        M.setColor(C);
    }


   public void mousePressed(MouseEvent e) {}   
   public void mouseReleased(MouseEvent e) {}
   public void mouseEntered(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mouseClicked(MouseEvent e) {

      Point X=new Point();
      e.consume();
      X.x=e.getX();
      X.y=e.getY();

      int tr=-1;
      int tg=-1;
      int tb=-1;
     

      for(int i=0;i<16;++i) {
          if(R[i].inside(X)==1) tr=i;
      }


      for(int i=0;i<16;++i) {
          if(G[i].inside(X)==1) tg=i;
      }


      for(int i=0;i<16;++i) {
          if(B[i].inside(X)==1) tb=i;
      }


      if(tr>=0) {
	  for(int i=0;i<16;++i) R[i].on=0;
	  R[tr].on=1;
      }

      if(tg>=0) {
	  for(int i=0;i<16;++i) G[i].on=0;
	  G[tg].on=1;
      }

      if(tb>=0) {
	  for(int i=0;i<16;++i) B[i].on=0;
	  B[tb].on=1;
      }

      if(DO.inside(X)==1) document();
      repaint();

   }


    public void document() {
	M.setExplain("This window is the color selector. You choose the red, green, and blue components of the color using the buttons on this window.  Whenever the applet gives you a chance to recolor something, the new color will be the one you have selected using this window.");
    }



}
