import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    
    /** Create the complex number 0 */
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    }
    
    /** Create the complex number x+i*y */
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    /* Copy constructor */
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }
    
    /* -------------------------------------------
     *
     *   Utility Functions
     */
    
    /** Set this complex number to be equal to z, and return this.
     * z and this will not share data. */
    public Complex set(Complex z) {
        x=z.x;
        y=z.y;
        return this;
    }
    
    /* -------------------------------------------
     *
     *   STATIC ARITHMETIC
     */
    
    /** Returns the norm of z.
     * Call like this:
     * <pre>Complex.norm(z)</pre>
     */
    public static double norm(Complex z) {
        return Math.sqrt(z.x*z.x+z.y*z.y);
    }
    
    /** Return the unit complex number with the same argument.
     * <br>Call like this:
     * <pre>Complex.unit(z)</pre>
     */
    public static Complex unit(Complex z) {
        double d=z.norm(z);
        return new Complex(z.x/d,z.y/d);
    }
    
    /** Static addition... Call like this:
     * <pre>Complex.plus(a,b)</pre>
     */
    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    
    /** Static subtraction... Call like this:
     * <pre>Complex.minus(a,b)</pre>
     */
    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    
    /** Static Multiplication.
     * <br>Call like this:
     * <pre>Complex.times(a,b)</pre>
     */
    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }
    
    /** Static inverse.
     * <br>Call like this:
     * <pre>Complex.inverse(a)</pre>
     */
    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    
    /** Static division. Call like this:
     * <pre>Complex.divide(a,b)</pre>
     */
    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    /** Static conjugation.
     * Call like this:
     * <pre>Complex.conjugate(a)</pre>
     */
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }
    
    /** Static Euclidean dot product.
     * Call Like this:
     * <pre>Complex.dot(v,w)</pre>
     */
    public static double dot(Complex a, Complex b) {
        return a.x*b.x+a.y*b.y;
    }
    
    //* Static distance */
    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
        return(norm(z));
    }
    
    
    
    
    
    
    
    
    /* -------------------------------------------------
     *
     *   REGULAR ARITHMETIC
     */
    
    /** Returns the norm of z.
     * Call like this:
     * <pre>z.norm()</pre>
     */
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }
    
    
    /** Compute the unit complex number with the same argument as this.
     * Call like this:
     * <pre>z.unit()</pre>
     */
    public Complex unit() {
        double d=norm();
        return new Complex(x/d,y/d);
    }
    
    
    /** Add this complex number to z and return the result.
     * <br>Call like this:
     * <pre>a.plus(b)</pre>
     */
    public Complex plus(Complex z) {
        return new Complex(x+z.x, y+z.y);
    }
    
    
    
    /** Subtract z from this complex number and return the result.
     * <br>This is unchanged.
     * <br>Call like this:
     * <pre>a.minus(b)</pre>
     */
    public Complex minus(Complex z) {
        return new Complex(x-z.x, y-z.y);
    }
    
    /** Multiplication.
     * <br>Call like this:
     * <pre>a.times(b)</pre>
     */
    public Complex times(Complex z) {
        return new Complex(x*z.x-y*z.y,
        x*z.y+y*z.x);
    }
    
    
    /** Inverse.
     * <br>Call like this:
     * <pre>a.inverse()</pre>
     */
    public Complex inverse() {
        double d=x*x+y*y;
        return new Complex(x/d,-y/d);
    }
    
    
    /** Division. Call like this to get a/b:
     * <pre>a.divide(b)</pre>
     */
    public Complex divide(Complex z2) {
        return times(inverse(z2));
    }
    
    
    /** Conjugation.
     * Call like this:
     * <pre>a.conjugate()</pre>
     */
    public Complex conjugate() {
        return new Complex(x,-y);
    }
    
    /** Static Euclidean dot product.
     * Call Like this:
     * <pre>v.dot(w)</pre>
     */
    public double dot(Complex a) {
        return a.x*x+a.y*y;
    }
    
    public boolean equals(Complex a) {
        return ((a.x==x)&&(a.y==y));
    }
    
    
    
    /* ----------------------------------------------------
     *
     * OTHER FUNCTIONS
     */
    
    public double arg(){
        return Math.atan2(y,x);
    }
    
    /** Compute the area of the given triangle.
     * Call like this:
     * <pre>Complex.area(a,b,c)</pre>
     */
    public static double area(Complex z1,Complex z2,Complex z3) {
        double a;
        Complex[] z=new Complex[5];
        for(int i=1;i<=9;++i) z[i]=new Complex();
        z[1]=z1.minus(z2,z1);
        z[2]=z1.minus(z3,z1);
        z[3]=z1.conjugate(z[2]);
        z[4]=z1.times(z[1],z[3]);
        a=-z[4].y;
        return(a);
    }
    
    public Complex scale(Complex z,double r) {
        Complex w=new Complex();
        w.x=r*x+(1.0-r)*z.x;
        w.y=r*y+(1.0-r)*z.y;
        return(w);
    }

    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

