

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.BoxLayout;


public class Deg100Canvas extends DBCanvas implements MouseListener,Runnable  {
    Manager M;
    Deg100Data D;
    Deg100Document DD;
    int select;
    int select2;
    ListenSquare[] S=new ListenSquare[270];
    ListenSquare[] V=new ListenSquare[10];
    WordIcon WI;
    ListenSquare[] X=new ListenSquare[20];
    ListenSquare[][] Y=new ListenSquare[3][6];
    int option;
    Interrupter I;
    int message;
    int boxes;
    int depth;
    int time;
    int exceptions[][]=new int[20][2];
    String[] bigint=new String[2];


    public Deg100Canvas(Manager M) {
	this.M=M;
	addMouseListener(this);
        setBackground(new Color(100,0,100));
	setSize(325,518);
	this.D=new Deg100Data();
	Color C=new Color(0,100,100);
	Color C2=new Color(100,0,100);
	defineSpecialPolygons(new Color(50,100,255));
	defineSeries0(C);	
        defineSeries1(C2);	
        defineSeries2(C2);
	defineSeries3(C2);
	defineSeries4(C2);
	defineVertexBoxes();
	select=-1; 
	Color CC=new Color(200,0,200);
        WI=new WordIcon(130,361,187,107,"",1);
	X[0]=new ListenSquare(126,343,196,128,CC);
	message=0;
	boxes=0;
	depth=0;
	time=0;


	for(int i=0;i<=2;++i) {
	    for(int j=0;j<=2;++j) {
		Y[i][j]=new ListenSquare(50+28*i,425+15*j,10,10,new Color(50,100,255));
	    }}
	Y[0][0].on=1;
	Color C3=new Color(50,100,255);
	X[1]=new ListenSquare(7,375,12,12,C3); //recognize
	X[8]=new ListenSquare(7,345,12,12,C3);	//off button
        X[9]=new ListenSquare(7,360,12,12,C3);  //clear button  
        X[11]=new ListenSquare(58,345,47,12,C3); //documentation	
        X[12]=new ListenSquare(160,346,11,11,CC); 	  
	X[8].on=0;    
	X[11].on=0;  //documentation
	X[10]=new ListenSquare(108,345,12,12,C2); //info button


	X[2]=new ListenSquare(126,5,95,44,CC);	
        X[3]=new ListenSquare(5,5,118,56,CC);   
        X[4]=new ListenSquare(5,66,118,51,CC);  
        X[6]=new ListenSquare(126,52,95,289,CC);
	X[7]=new ListenSquare(223,5,99,336,CC);  

        X[5]=new ListenSquare(5,122,118,51,CC); 
        X[13]=new ListenSquare(5,178,118,51,CC);   
        X[14]=new ListenSquare(5,234,118,51,CC);  
        X[15]=new ListenSquare(5,290,118,51,CC); 
	X[16]=new ListenSquare(5,343,118,128,CC);
	X[17]=new ListenSquare(5,473,300,44,C3);

	option=0;
	X[12].on=1;
	DD=new Deg100Document(M);
    }





        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,    
            RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font("Helvetica",Font.PLAIN,10)); 
            for(int i=17;i>=0;--i) X[i].render(g,new Color(50,100,255));  
            drawTiles(g);   
            if(select>=0) drawVertices(-68,62,select,g);  
	    if(X[12].on==0) wordRender(g);
	    if(X[12].on==1) iconRender(g);
            X[10].infoRender(g);
	    drawWords(g);
            X[12].render(g,new Color(50,100,255));  

	    for(int i=0;i<=1;++i) {
	    for(int j=0;j<=2;++j) {
		Y[i][j].render(g,new Color(50,100,255));
	    }
	    }
            Y[2][0].render(g,new Color(50,100,255));
            Y[2][2].render(g,new Color(50,100,255));

	    drawMessage(g);
	}


    public void drawMessage(Graphics g) { 
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,10)); 

	if(message==1) {
	    Integer BOXES=new Integer(boxes);
	    Integer DEPTH=new Integer(depth);
	    Integer TIME=new Integer(time);
	    String s="boxes "+BOXES.toString()+"   ";
	    s=s+"depth "+DEPTH.toString()+"   ";
	    s=s+"time "+TIME.toString()+" millis";
	    g.drawString(s,9,485);
	    if(exceptions[0][0]>0) {
		g.drawString("exceptions:",10,506);
		for(int i=1;i<=exceptions[0][0];++i) {
		    Integer E0=new Integer(exceptions[i][0]);
		    Integer E1=new Integer(exceptions[i][1]);
		    g.drawString(E1.toString(),25*i+60,501);  
                    g.drawString(E0.toString(),25*i+60,513);
		}
	    }
	}


	if(message==2) {
            g.drawString(bigint[0]+"   "+bigint[1],9,498);
            g.drawString("2^27 times vertex coordinates equals",9,485);
	}

	if(message==3) {
	    Integer BOXES=new Integer(boxes);
	    Integer DEPTH=new Integer(depth);
            Integer TIME=new Integer(time);
            String s="total boxes "+BOXES.toString()+"   ";
	    s=s+"max depth "+DEPTH.toString()+"   ";
            s=s+"total time "+TIME.toString()+" millis";
	    g.drawString(s,9,485);
	}

	if(message==5) {
	    g.drawString("The covering property for P1-P6 is implied by the",9,485);
	    g.drawString("covering property for P7-P221.  We don't have to",9,498);   
            g.drawString("check these tiles directly.",9,511);
	}
	if(message==6) {
	g.drawString("These tile are not part of the",9,485);
	g.drawString("dyadic covering.",9,498);
	}

    }


	public void drawWords(Graphics g) {
            g.setColor(Color.white);
            g.setFont(new Font("Helvetica",Font.PLAIN,10)); 
            if(X[11].on==0) g.drawString("doc. off",65,356);     
            if(X[11].on==1) g.drawString("doc. on",65,356); 

            g.drawString("off",23,356);  
            g.drawString("clear",23,371); ;  
            g.drawString("recognize",23,386); 


	    g.translate(0,45);
	    g.drawString("plot",40,376);
	    g.drawString("verify",67,376);
	    g.drawString("cover",96,376);
	    g.drawString("single",8,388);    
            g.drawString("group",8,403);   
            g.drawString("all",8,418);  
	    g.translate(0,-45);

            if(X[12].on==0) g.drawString("mode 1: word",175,357);
            if(X[12].on==1) g.drawString("mode 2: hexpath",175,357);
	}

    public Complex[] getPolygon(int choice) {	
            int n=D.P[choice].n;
            Complex[] BOB=new Complex[n];
	    for(int i=0;i<n;++i) {
		BOB[i]=new Complex(D.P[choice].x[i]/512.0,D.P[choice].y[i]/512.0);
	    }
	    return(BOB);
    }


    public void singleCoverFancy(int choice) {
	if((choice>=7)&&(choice<=221)) {
	Deg100IntegerPolygon dummy=new Deg100IntegerPolygon();
	int[][] record=dummy.subdivisionAlgorithm(D,choice);
	hardClear();
	if(record[0][0]>0) {
	    for(int i=1;i<=D.P[choice].n;++i) {
		M.setColor(Color.red);
		for(int j=1;j<=record[i][0];++j) {
		    S[record[i][j]].on=1;  
                    S[record[i][j]].C=Color.yellow;
		    singlePlot(record[i][j]);
		}
	    }
	    S[choice].on=1;
	    S[choice].C=Color.yellow;
	    M.setColor(Color.yellow);
	    singlePlot(choice);
	}
	}
	if(choice<7) {message=5;repaint();}
	if(choice>221) {message=6;repaint();}
    }


    public void singleCover(int choice) {
	Deg100IntegerPolygon dummy=new Deg100IntegerPolygon();
	int[][] record=dummy.subdivisionAlgorithm(D,choice);
	if(record[0][0]>0) {
	    S[choice].on=1;
	    S[choice].C=Color.yellow;
	}
	repaint();
    }





		
    public void singlePlot(int choice) {
          M.selectTile(new SearchTile(D.P[choice].W));
	  M.n=D.P[choice].n;
	  M.POLY[0]=getPolygon(choice);
	  WI.W=D.P[choice].W;
	  select=choice;setCenter();
          PlottingPoly plotter=new PlottingPoly(M,this);
          I=new Interrupter();
          Tile tile=plotter.plot(D.P[choice].W, I);
	  S[choice].on=1; 
	  S[choice].C=M.getColor(); 
          M.plotTile(tile); 
	  repaint();
    }


    public void singleProve(int choice) {
	if((choice>=7)&&(choice<=221)) {
          M.selectTile(new SearchTile(D.P[choice].W));
	  M.n=D.P[choice].n;
          M.POLY[0]=getPolygon(choice);
	  WI.W=D.P[choice].W;
          PlottingPoly2 plotter=new PlottingPoly2(M,this);  
          I=new Interrupter();
          Tile tile=plotter.plot(D.P[choice].W, I);
	  S[choice].on=1; 
	  S[choice].C=M.getColor(); 
          M.plotTile(tile);   
          message=1;
	  depth=M.depth;
	  boxes=M.boxes;
	  time=M.time;
	  exceptions[0][0]=M.exceptions[0][0];
	  for(int i=1;i<=exceptions[0][0];++i) {
	      exceptions[i][0]=M.exceptions[i][0];
	      exceptions[i][1]=M.exceptions[i][1];
	  }

	  repaint();
	}
    }



	
    public void totalCover() {
	option=6;
	Thread T=new Thread(this);
	T.start();
    }

    public void totalPlot() {
	option=1;
	Thread T=new Thread(this);
	T.start();
    }

    public void neighborPlot() {
	option=5;
	select2=select;
	Thread T=new Thread(this);
	T.start();
    }


    public void totalProve() {
	option=3;
	Thread T=new Thread(this);
	T.start();
    }

    public void groupProve() {
	option=4;
	Thread T=new Thread(this);
	T.start();
    }


    public void groupPlot() {
	option=2;
	Thread T=new Thread(this);
	T.start();
    }


    public void run() {

	if(option==1) {
	  for(int i=1;i<=221;++i) {
             singlePlot(i);
	  }
	}

	if(option==6) {
	  for(int i=7;i<=221;++i) {
             singleCover(i);
	  }
	}

	if((select<222)&&(option==5)) {
	    hardClear();
	  for(int i=1;i<=221;++i) {
	      M.setColor(Color.blue);
	      if(doesIntersect(i,select2)==1) {
	        singlePlot(i);
	      }
	  }
	  M.setColor(Color.yellow);
	  singlePlot(select2);
	}

	if(option==3) {
	    int depth2=0;
	    int boxes2=0;
	    int time2=0;
	  for(int i=7;i<=221;++i) {
             singleProve(i);
	     boxes2=boxes2+boxes;
	     time2=time2+time;
	     if(depth2<depth) depth2=depth;
	  }
	  message=3;
	  boxes=boxes2;
	  depth=depth2;
	  time=time2;
	}

	if(option==2) {

	    if(select<7) singlePlot(select);

	if((select>=7)&&(select<=29)) {
	    for(int i=7;i<=29;++i) singlePlot(i);
	}

	if((select>=30)&&(select<=221)) {
	    for(int i=30;i<=221;++i) singlePlot(i);
	}

	if((select>=222)&&(select<=226)) {
	    for(int i=222;i<=226;++i) singlePlot(i);
	}

	if((select>=227)&&(select<=228)) {
	    for(int i=227;i<=228;++i) singlePlot(i);
	}

	if((select>=229)&&(select<=248)) {
	    for(int i=229;i<=248;++i) singlePlot(i);
	}

	if((select>=249)&&(select<=258)) {
	    for(int i=249;i<=258;++i) singlePlot(i);
	}

	if((select>=259)&&(select<=268)) {
	    for(int i=259;i<=268;++i) singlePlot(i);
	}
	}

	if(option==4) {
	    int depth2=0;
	    int boxes2=0;
	    int time2=0;
	    message=0;

	  if((select>=7)&&(select<=29)) {
	    for(int i=7;i<=29;++i) {
              singleProve(i);
	      boxes2=boxes2+boxes;
	      time2=time2+time;
	      if(depth2<depth) depth2=depth;
	    }
	    depth=depth2;
	    boxes=boxes2;
	    time=time2;
	    message=3;
	  }

	  if((select>=30)&&(select<=221)) {
	    for(int i=30;i<=221;++i) {
              singleProve(i);
              if(depth2<depth) depth2=depth;
	      boxes2=boxes2+boxes;
	      time2=time2+time;
	    }
	    depth=depth2;
	    boxes=boxes2;
	    time=time2;
	    message=3;
	  }
	}

    }


    public void selectAction(Point xX) {
	int act=0;
	int ii=-1;
	int jj=-1;
	for(int i=0;i<=2;++i) {
	    for(int j=0;j<=2;++j) {
		if(Y[i][j].inside(xX)==1) {
                  Y[i][j].on=1;
		  ii=i;
		  jj=j;
		}
	    }
	}
	if((ii==2)&&(jj==1)) ii=-1;

	if(ii>=0) {
	for(int i=0;i<=2;++i) {
	    for(int j=0;j<=2;++j) {
		Y[i][j].on=0;
	    }
	}
	Y[ii][jj].on=1;
	X[8].on=0;
	X[9].on=0;
	}
    }



    public void nullAction() {
	for(int i=0;i<=2;++i) {
	    for(int j=0;j<=2;++j) {
		Y[i][j].on=0;
	    }
	}
	X[8].on=0;
	X[9].on=0;
    }





       public void iconRender(Graphics2D g) {
            Color C1=new Color(60,0,0);
            Color C2=new Color(60,0,0);
            Color C3=new Color(255,0,0);
            Color C4=Color.white;
            Color C5=Color.white;  
            Color C6=new Color(0,0,60);
            Color C7=new Color(0,0,60);
            Color C8=new Color(0,0,255); 
            Color C9=new Color(0,60,0);
            Color C10=new Color(0,60,0);
            Color C11=new Color(0,255,0);
	    WI.pathRender(g,C1,C2,C3,C4,C5,C6,C7,C8,C9,C10,C11);
	}



       public void wordRender(Graphics2D g) {
	   String A=WI.W;   
	   int len=A.length();
           g.setColor(Color.white);
           g.setFont(new Font("Helvetica",Font.PLAIN,12));
	   Integer Len=new Integer(len);
	   g.drawString(Len.toString(),131,357);

           g.setFont(new Font("Monospaced",Font.PLAIN,10));
	   int a=126;
	   int b=370;
	   for(int i=0;i<len;++i) {
	       int j=i+1;
	       if(i%4==0) a=a+4;
	       String AA=A.substring(i,j);
	       g.drawString(AA,a,b+1);
	       if(j%32==0) {b=b+12;a=126;}
	       if(j%32!=0) a=a+5;
	   }
	}


    public int doesIntersect(int i,int j) {
	Complex[] Z1=getPolygon(i);
	Complex[] Z2=getPolygon(j);
	int test=ConvexIntersector.checkDisjoint(Z1,Z2);
	if(test<3) return(1);
	return(0);
    }



        

 public void drawTiles(Graphics g) {
     for(int i=1;i<=6;++i) {if(S[i].on==0) S[i].renderRed(g,S[i].C);}
     for(int i=7;i<=221;++i) {if(S[i].on==0) S[i].renderMagenta(g,S[i].C);}
     for(int i=222;i<=268;++i) {if(S[i].on==0) S[i].renderCyan(g,S[i].C);}
     for(int i=1;i<=6;++i) {if(S[i].on==1) S[i].renderRed(g,S[i].C);}     
     for(int i=7;i<=221;++i) {if(S[i].on==1) S[i].renderMagenta(g,S[i].C);}  
     for(int i=222;i<=268;++i) {if(S[i].on==1) S[i].renderCyan(g,S[i].C);}

   //labels
   g.setFont(new Font("Helvetica",Font.PLAIN,10)); 
   g.setColor(Color.white);


   if((select>0)&&(select<=221)) {
     Integer II=new Integer(select);
     g.drawString("interior tiles",140,65);
     g.drawString("vertices of P"+II.toString(),230,18);
   }

   if(select>=222) {
     g.drawString("interior tiles",140,65);
     g.drawString("vertices of tile",230,18);
   }



   g.drawString("...",106,23);
   g.drawString("...",106,38);
   g.drawString("...",106,303);
   g.drawString("...",106,318);
   g.drawString("covers P1",52,57);
   g.drawString("P2",85,113);
   g.drawString("P3",85,169);
   g.drawString("covers P4",52,225);
   g.drawString("covers P5",52,281);
   g.drawString("covers P6",52,337);


 }


    //boundary markings  


      public void defineSpecialPolygons(Color col) {  
        for(int i=1;i<=6;++i) {
	   S[i]=new ListenSquare(105,-10+56*i,12,col);
	}

	//not used
	S[0]=new ListenSquare(-1,-1,0,0,Color.white);

      }


    //generic tiles

    public void defineSeries0(Color col) {  
      int a=0;
      int b=0;
      for(int i=-8;i<=18;++i) {
	  a=(int)(Math.floor(i/8.0));
	  b=i-a*8;
	   S[i+15]=new ListenSquare(129+11*b,21+11*a,11,col);
      }

      for(int i=16;i<=213;++i) {
	  a=(int)(Math.floor(i/8.0));
	  b=i-a*8;
	   S[i+14]=new ListenSquare(129+11*b,50+11*a,11,col);
      }
    }



      //Pi/4 series of tiles
   public void defineSeries1 (Color col) {
      S[222]=new ListenSquare(8,203,22,col);
      for(int i=1;i<=3;++i) {
      S[222+i]=new ListenSquare(-3+11*i,181,11,col);
      }
      for(int i=0;i<=2;++i) {
      S[225+i]=new ListenSquare(8+11*i,192,11,col);
      }
   }



      //Pi/5 series of tiles
   public void defineSeries2(Color col) {
      for(int i=0;i<=1;++i) {
      S[227+i]=new ListenSquare(8,256+12*i,12,col);
      }
   
   }



      //Pi/6 series of tiles
   public void defineSeries3(Color col) {
      for(int i=0;i<=9;++i) {
      S[249+i]=new ListenSquare(8+9*i,297,9,col);
      }

      for(int i=0;i<=9;++i) {
      S[259+i]=new ListenSquare(8+9*i,312,9,col);
      }
   
   }



    //0 series of tiles
    public void defineSeries4(Color col) {
      for(int i=0;i<=9;++i) {
      S[229+i]=new ListenSquare(8+9*i,17,9,col);
      }

      for(int i=0;i<=9;++i) {
      S[239+i]=new ListenSquare(8+9*i,32,9,col);
      }
    }
    


        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
	    e.consume();
	    Point xX=new Point();
	    xX.x=e.getX();
	    xX.y=e.getY();
	    selectAction(xX);
	    int test2=whichPolygon(xX);  
	    if(select>=0) {
               int test3=whichVertex(xX);
               if(test3>=0) {
                V[test3].on=1;
                double x=D.P[select].x[test3];
                double y=D.P[select].y[test3];
		Complex Z=new Complex(x/512.0,y/512.0);
		Deg100IntegerPolygon DIP=new Deg100IntegerPolygon(D.P[select]);
		bigint[0]=DIP.K1[test3].toString();
		bigint[1]=DIP.K2[test3].toString();
		message=2;
		M.setParameter(Z);
	       }
	    }

	    if(X[1].inside(xX)==1) recognize();
	    if(X[8].inside(xX)==1) {nullAction();X[8].on=1;}
	    if(X[9].inside(xX)==1) hardClear();
	    if(X[11].inside(xX)==1) X[11].on=1-X[11].on;
	    if(X[12].inside(xX)==1) X[12].on=1-X[12].on;

	    if(X[10].inside(xX)==1) DD.summary();
	    if(X[11].on*X[4].inside(xX)==1) DD.boundary();
	    if(X[11].on*X[1].inside(xX)==1) DD.wordDisplay();
	    if(X[11].on*X[7].inside(xX)==1) DD.vertexDisplay();

	    if(X[11].on*X[3].inside(xX)==1) DD.P1Explain();
	    if(X[11].on*X[4].inside(xX)==1) DD.P2Explain();
	    if(X[11].on*X[5].inside(xX)==1) DD.P3Explain();
	    if(X[11].on*X[13].inside(xX)==1) DD.P4Explain();
	    if(X[11].on*X[14].inside(xX)==1) DD.P5Explain();
	    if(X[11].on*X[15].inside(xX)==1) DD.P6Explain();
	    repaint();
        }


   public int whichVertex(Point XX) {
      int nv=D.P[select].n;
      int test3=-1;
      for(int i=0;i<nv;++i) {
	  V[i].on=0;
	  if(V[i].inside(XX)==1) test3=i;
      }
      return(test3);
   }


    
    public Complex getCenter() {
	int len=D.P[select].n;
	double x=0;
	double y=0;

	for(int i=0;i<len;++i) { 
            x=x+D.P[select].x[i];
	    y=y+D.P[select].y[i];
	}
	x=x/len;
	y=y/len;
	x=x/512.0;
	y=y/512.0;
	Complex Z=new Complex(x,y);
	return(Z);
    }

    public void setCenter() {
	Complex Z=getCenter();
	M.setParameter(Z);
    }



    public void removeManagement(){
        M.remove(this);
        M.spaceChanged();
    }

    
    public void recognize() {
	String W1=M.getWord();
	int ii=0;
	for(int i=268;i>=7;--i) {
	    String W2=D.P[i].W;
	    if(W1.compareTo(W2)==0) ii=i;
	}
	if(ii>0) {
	    select=ii;
	    for(int i=1;i<=268;++i) S[i].on=0;
	    S[ii].on=1;
	    repaint();
	}
    }





  public int whichPolygon(Point XX) {
      int test2=-1;

      for(int i=0;i<=D.N;++i) {
	  if(S[i].inside(XX)==1) test2=i;
      }  
      if(test2>=0) {
          select=test2;  
          M.selectTile(new SearchTile(D.P[select].W));
	  M.POLY[0]=getPolygon(select);
	  M.n=D.P[select].n;
	  WI.W=D.P[select].W;
	  setCenter();  

	  if(Y[0][0].on==1) singlePlot(select);
	  if(Y[0][1].on==1) groupPlot();
	  if(Y[0][2].on==1) totalPlot();

	  if(Y[1][0].on==1) singleProve(select);
	  if(Y[1][1].on==1) groupProve();
	  if(Y[1][2].on==1) totalProve();

	  if(Y[2][0].on==1) singleCoverFancy(select);
	  if(Y[2][2].on==1) totalCover();
	  if(X[9].on==1) hardClear();


          for(int j=0;j<8;++j) V[j].on=0;
      }

      return(test2);
  }

    public void hardClear() {
	for(int i=1;i<=268;++i) S[i].on=0;
	M.STM.clear();
	M.spaceChanged();
	repaint();
    }


    public void  defineVertexBoxes () {
      for(int i=0;i<=7;++i) 
      V[i]=new ListenSquare(225,303-38*i,94,35,new Color(155,0,155));
    }

   public void drawVertices(int x,int y,int ind, Graphics g) {

    int nn=D.P[ind].n;
    int tt=D.P[ind].type;
    Integer I=new Integer(0);

    for(int i=0;i<nn;++i) V[i].render(g,Color.black);

    g.translate(x,y);
    g.setFont(new Font("Helvetica",Font.PLAIN,10)); 

    for(int i=0;i<nn;++i) {  

	  if(tt==1) {
	    g.setColor(Color.white);
            g.drawString(I.toString(D.P[ind].k1[i]),300,254-38*i);
	    g.drawString(I.toString(D.P[ind].n1[i]),312,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);
            g.drawString("2",306,273-38*i); 

	    g.translate(52,0);
	    g.setColor(Color.white);
            g.drawString(I.toString(D.P[ind].k2[i]),300,254-38*i);
	    g.drawString(I.toString(D.P[ind].n2[i]),312,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);
            g.drawString("2",306,273-38*i);
	    g.translate(-52,0);
	  }

	  if(tt==2) {
            g.setColor(Color.white);
            g.drawString(I.toString(D.P[ind].k1[i]),300,254-38*i);
	    g.drawString(I.toString(D.P[ind].n1[i]),300,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);

	    g.translate(52,0);
            g.setColor(Color.white);
            g.drawString(I.toString(D.P[ind].k2[i]),300,254-38*i);
	    g.drawString(I.toString(D.P[ind].n2[i]),300,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);
	    g.translate(-52,0);
	  }

	  if(tt==3) {  
            g.setFont(new Font("Helvetica",Font.PLAIN,8)); 
	     g.setColor(Color.white);
	     Double sx=new Double(D.P[ind].x[i]/512.0);
	     Double sy=new Double(D.P[ind].x[i]/512.0);
	     String SX=sx.toString();
	     String SY=sy.toString();
	     SX=SX.substring(0,8);
	     SY=SY.substring(0,8);
	     g.drawString(SX,300,256-38*i);
	     g.drawString(SY,350,256-38*i);
	  }
    }


    g.setFont(new Font("Helvetica",Font.PLAIN,12));

    if(tt==3) {
       g.setColor(new Color(255,0,255));
       g.drawString("Vertices are",300,32); 
       g.drawString("not rational",300,47);  
       g.drawString("multiples",300,62); 
       g.drawString("of Pi/2.",300,77); 
    }

    g.translate(-x,-y);
   }

   






}







