import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class Deg100Cover {
    Complex[][] POLY=new Complex[270][8];
    DyadicSquare[] IN=new DyadicSquare[10000];
    int IN_N;
    DyadicSquare[] D=new DyadicSquare[10000];
    int D_N;
    int[] length=new int[270];

    
    public Deg100Cover(Complex[][] POLY) {
	this.POLY=POLY;
	IN_N=0; 
        D_N=1;
        int[] x={1,1};
        int[] y={1,1};
        D[0]=new DyadicSquare(x,y,0);
    }


     public DyadicTile basicPlot() {
        double time1=System.currentTimeMillis();
        while((IN_N<8000)&&(D_N>0)) processSquare();

        GeneralPath gp=new GeneralPath();
        for(int i=0;i<IN_N;++i) {
            gp.append(IN[i].toGeneralPathSpecial(), false);
        }
        DyadicTile DT=new DyadicTile("", gp, Color.red);

        double time2=System.currentTimeMillis();
        double time=time2-time1;
        System.out.println("time: "+time);

        return DT;
     }


    void processSquare() {
        int action=determineAction();
        if(action==-1) --D_N;
        if(action==0) refineList();
        if(action==1) addToInsiders();
    }
    
    
    public void refineList() {
        DyadicSquare A=D[D_N-1];
        D[D_N-1]=DyadicSquare.subdivide(0,0,A);
        D[D_N+0]=DyadicSquare.subdivide(0,1,A);
        D[D_N+1]=DyadicSquare.subdivide(1,1,A);
        D[D_N+2]=DyadicSquare.subdivide(1,0,A);
        D_N=D_N+3;
    }
    
    
    public void addToInsiders() {
	DyadicSquare A=D[D_N-1];
        IN[IN_N]=new DyadicSquare(A.x,A.y,A.k);
        ++IN_N;
        --D_N;
    }

    
    public int determineAction() {
        DyadicSquare A=D[D_N-1];
	Complex Z=A.getCenter();
	if(Z.x+Z.y>1) return(-1);

	if((Z.x+Z.y==1)&&(A.k>5)) return(1);

	System.out.println("length "+D_N+"  "+IN_N);

	int test=interiorTest();
	return(test);
    }
    

    public int interiorTest() {
	DyadicSquare A=D[D_N-1];
	for(int i=1;i<=268;++i) {
	    if(ConvexIntersector.checkDisjoint(A,POLY[i])==1) return(1);
	}
	return(0);
    }
    

}