import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class Deg100Verifier {
    int mode;
    int detail; // detail of the plot to do
    int type_of_plot;
    int filter;
    Color C;
    Complex Z;
    int count;
    int max;
    int[][] exceptions=new int[20][2];
    
    //defining functions
    int[][][] denominator=new int[3][3][1000];
    int[][] numerator=new int[4][1000];
    CombinatorialTriangle[] CT;
    int[] top;
    int[] bot;
    int palindrome;
    int spine;
    String W;
    int sign;
    VertexPair V;
    int[][] record=new int[2][2000];
    
    //lists of dyadic squares
    DyadicSquare INIT;
    DyadicSquare[] D=new DyadicSquare[10000];
    DyadicSquare[] IN=new DyadicSquare[10000];
    int D_N,IN_N;
    
    //memory
    VertexPair[] VP=new VertexPair[5000];
    Complex[][] CORNER=new Complex[3][3];
    int corner[]=new int[3];
    Complex[][] data=new Complex[3][11];
    int SMALL;
    
    //billiard like input
    Complex[] BL;
    Complex BL_CENTER;
    Complex[] POLY;
    int right,obtuse;
    DyadicPlotterInit DPI;
    
    
    public Deg100Verifier(Complex[] Z,int type_of_plot, int filter,
				String word, Color C,Complex z) {
	this.POLY=Z;  //key line
        this.type_of_plot=type_of_plot;
	this.filter=filter;
        this.C=C;
	this.Z=z;
        doReset(word);
    }


        public DyadicTile basicPlot() {
        double time1=System.currentTimeMillis();
        if (BL==null) return null; // b-like tile is empty
	count=0;
	max=0;
	exceptions[0][0]=0;
        while(D_N>0) processSquare();


        GeneralPath gp=new GeneralPath();
        if (IN_N==0) return(null);
        for(int i=0;i<IN_N;++i) {
            gp.append(IN[i].toGeneralPathSpecial(), false);
        }
        DyadicTile DT=new DyadicTile(W, gp, C);

	if(type_of_plot==2) {
	  DT.record=record;
	  DT.record_active=1;
	  DT.Z=Z;
	  DT.Z=IN[0].getCenter();
          DT.dyadic_size=IN[0].k;
	}

        double time2=System.currentTimeMillis();
        double time=time2-time1;
	DT.depth=max;
	DT.boxes=IN_N;
	DT.time=(int)(time);
	DT.exceptions[0][0]=exceptions[0][0];
	for(int i=1;i<=exceptions[0][0];++i) {
	    DT.exceptions[i][0]=exceptions[i][0];
	    DT.exceptions[i][1]=exceptions[i][1];
	}
        return DT;
    }


    
    public void doReset(String word) {
        DPI=new DyadicPlotterInit(word,filter);
        BL=DPI.BL;
        BL_CENTER=DPI.BL_CENTER;
        INIT=DPI.INIT;
        D[0]=DPI.D;
        record=DPI.record;
        CT=DPI.CT;
        palindrome=DPI.palindrome;
        right=DPI.right;
        obtuse=DPI.obtuse;
        V=new VertexPair();
        VP[0]=new VertexPair(0,0,0,0);
        VP[0].cert=0;
        SMALL=4;
        W=word;
        top=Spine.completeList(1,CT);
        bot=Spine.completeList(2,CT);
        D_N=1;
        IN_N=0;
        denominator[0]=Function.computeDenominator(0,CT);
        denominator[1]=Function.computeDenominator(1,CT);
        denominator[2]=Function.computeDenominator(2,CT);
        
    }
    
    
    
    
    
    /**FUNCTION CREATION AND EVALUATION*/
    
    //in the non-palindrome case, this routine just sets the sign and spine number
    
    public int[][] getSignedNumerator() {
        int[][]f=new int[0][0];
        if(palindrome==0) {
            spine=Spine.spineNumber(V,CT);
            sign=Spine.getSign(V,CT,denominator[spine]);
        }
        if(palindrome==1) {
            spine=Spine.spineNumber(V,CT);
            f=PalindromeFunction.getFunction(denominator[spine],V,CT);
        }
        return(f);
    }

    
    //this routine uses the function certificates computed below.
    public int signEvaluate(int cert) {
	DyadicSquare A=D[D_N-1];
        if(palindrome==1) return(PalindromeFunction.signEvaluate(numerator,A,cert));
        if(palindrome==0) {
            int test=0;
            int gm=getMatchNumber();
            if(gm>SMALL) test=Spine.signEvaluate(sign,V,CT,data[spine],A,cert);
            if(gm<=SMALL) test=Spine.signEvaluate(sign,V,CT,denominator[spine],A,cert);
            return(test);
        }
        return(0);
    }



    /**FUNCTION CERTIFICATES:  These routines are designed to certify that
       a given defining function is quadrantic in a given square.  A function
       is quadrantic in a region if its gradient lies in a quadrant throughout
       that region.  The first routine does the computations.  This routine
       is somewhat costly to compute, and so we store any certificates
       we do compute, for later use.  The second and third routines manage
       this storing and looking up of certificates.*/

    
    public int certify() {
        DyadicSquare A=D[D_N-1];
        if(palindrome==1) {
            return(PalindromeFunction.certify(numerator,A));
        }
        
        if(palindrome==0) {
            
            int[] a=lookup3();
            if(a[0]+a[1]+a[2]==0) {
                a=Spine.absSecond(V,CT,denominator[spine]);
                ++VP[0].cert;
                VP[VP[0].cert]=new VertexPair(V.o1,V.e1,V.o2,V.e2,a[0],a[1],a[2]); }
            int test=0;
            int test2=0;
            int gm=getMatchNumber();
            if(gm>SMALL)   test=Certify.certify(sign,V,CT,data[spine],A,a);
            if(gm<=SMALL)  test=Certify.certify(sign,V,CT,denominator[spine],A,a);
            return(test);
            
        }
        return(0);
    }


    public int[] lookupCertify(int q) {
	DyadicSquare A=D[D_N-1];
	int[] cert=new int[2];
	cert[0]=0;
	cert[1]=0;
        if(q==1) cert[1]=lookup1();  
        if(q==2) cert[1]=lookup2();       
        if(cert[1]>0)  cert[0]=cert[1];
        if(cert[1]==0) cert[0]=certify();
	return(cert);
    }

    public void recordCertify(int q,int[] cert) {
	DyadicSquare A=D[D_N-1];
	if(q==1) {
        if((cert[1]==0)&&(cert[0]>0)) {      //record certificate for later use
            ++A.V1[0].cert;
            int L=A.V1[0].cert;
            A.V1[L]=new VertexPair(V.o1,V.e1,V.o2,V.e2);
            A.V1[L].cert=cert[0];
        }}

	if(q==2) {
        if((cert[1]==0)&&(cert[0]>0)) {      //record certificate for later use
            ++A.V2[0].cert;
            int L=A.V2[0].cert;
            A.V2[L]=new VertexPair(V.o1,V.e1,V.o2,V.e2);
            A.V2[L].cert=cert[0];
        }}
    }








    
    
    
    /**LOOKING UP STORED INFORMATION*/
    
    
    
    public int compare(VertexPair VV1,VertexPair VV2) {
        if(VV1.o1!=VV2.o1) return(0);
        if(VV1.e1!=VV2.e1) return(0);
        if(VV1.o2!=VV2.o2) return(0);
        if(VV1.e2!=VV2.e2) return(0);
        return(VV2.cert);
    }
    
    public int lookup1() {
        int N=D[D_N-1].V1[0].cert;
        int cert=0;
        for(int i=N;i>=1;--i) {
            cert=compare(V,D[D_N-1].V1[i]);
            if(cert!=0) return(cert);
        }
        return(0);
    }
    
    
    
    public int lookup2() {
        int N=D[D_N-1].V2[0].cert;
        int cert=0;
        for(int i=N;i>=1;--i) {
            cert=compare(V,D[D_N-1].V2[i]);
            if(cert!=0) return(cert);
        }
        return(0);
    }
    
    
    public int[] compare3(VertexPair VV1,VertexPair VV2) {
        int[] a=new int[3];
        a[0]=0;
        a[1]=0;
        a[2]=0;
        int test=1;
        if(VV1.o1!=VV2.o1) test=0;
        if(VV1.e1!=VV2.e1) test=0;
        if(VV1.o2!=VV2.o2) test=0;
        if(VV1.e2!=VV2.e2) test=0;
        if(test==1) {
            a[0]=VV2.a20;
            a[1]=VV2.a11;
            a[2]=VV2.a02;
        }
        return(a);
    }
    
    
    public int[] lookup3() {
        int N=VP[0].cert;
        int[] a=new int[3];
        a[0]=0;
        a[1]=0;
        a[2]=0;
        for(int i=N;i>=1;--i) {
            a=compare3(V,VP[i]);
            if(a[0]!=0) return(a);
        }
        return(a);
    }
    
    public int getMatchNumber() {
        return(D[D_N-1].top[0]*D[D_N-1].bot[0]);
    }
    
    






    
    
    /**HERE IS THE ALGORITHM*/
    
    public void processSquare() {
	++count;
	if(max<D[D_N-1].k) max=D[D_N-1].k;
        int action=determineAction();
        if(action==-1) --D_N;
        if(action==0) refineList();
        if(action==1) addToInsiders();
    }
    
    
    public void refineList() {
        DyadicSquare A=D[D_N-1];
        D[D_N-1]=DyadicSquare.subdivideAndRemember(0,0,A);
        D[D_N+0]=DyadicSquare.subdivideAndRemember(0,1,A);
        D[D_N+1]=DyadicSquare.subdivideAndRemember(1,1,A);
        D[D_N+2]=DyadicSquare.subdivideAndRemember(1,0,A);
        D_N=D_N+3;
    }
    
    
    public void addToInsiders() {
	DyadicSquare A=D[D_N-1];
        IN[IN_N]=new DyadicSquare(A.x,A.y,A.k);
        IN[IN_N].top=new int[300];
        IN[IN_N].bot=new int[300];
        IN[IN_N].top[0]=A.top[0];
        IN[IN_N].bot[0]=A.bot[0];

        for(int i=1;i<=A.top[0];++i) {
            IN[IN_N].top[i]=A.top[i];
        }
        
        for(int i=1;i<=A.bot[0];++i) {
            IN[IN_N].bot[i]=A.bot[i];
        }

        if((mode<4)&&(type_of_plot>=2)) {
            Z=A.getCenter(); // set Z
            D_N=0;
        }

        ++IN_N;
        --D_N;
    }

    
    
    
    public int determineAction() {
        DyadicSquare A=D[D_N-1];

	//in box mode, check if box contains point
        if(type_of_plot==2) {
            int touch=ConvexIntersector.checkTouch(Z,A.toPolygon());
            if(touch==0) return(-1);
        }

	//on the acute side
	Complex U=A.getCenter();
	if(U.x+U.y>1) return(-1);
        
	//in general, check if box intersects polygon
        int test=ConvexIntersector.checkDisjoint(A,POLY);
        if(test==3) return(-1);                    //does not intersect 
        if(test==2) return(0);                     //contains 
        
        
	//if there are many matches to be played we precompute the denominators
        int gm=getMatchNumber();
        if(gm>SMALL) {
            data[0]=Function.assignData(denominator[0],A);
            data[1]=Function.assignData(denominator[1],A);
            data[2]=Function.assignData(denominator[2],A);
	}
        
        tournament();
        int p=playoffs();
	return(p);
    }
    
    
    
    
    public void tournament() {
        int STOP=1;
        while(STOP!=0) STOP=round(1);
	STOP=1;
	while(STOP!=0) STOP=round(2);
    }
    
    
    public int round(int q) {
        
        int match=0;
        int count=0;
        int previous=0;
        int elim=0;
        int BEFORE=0;
	DyadicSquare A=D[D_N-1];
        
        if(q==1) BEFORE=A.top[0];
        if(q==2) BEFORE=A.bot[0];
        
        for(int i=1;i<BEFORE;++i) {
            
            if(q==1) {
                V.o1=1;V.e1=top[A.top[i+0]];
                V.o2=1;V.e2=top[A.top[i+1]];
            }
            
            if(q==2) {
                V.o1=2;V.e1=bot[A.bot[i+0]];
                V.o2=2;V.e2=bot[A.bot[i+1]];
            }
            
            
            //the match
            elim=0;
            match=0;
            if(previous==2) elim=1;
            if(elim==0) match=ordinaryMatch();
            if(match==1) elim=1;
            //match is done
            
            if((q==1)&&(match==1)) record[0][A.top[i]]=A.top[i+1];
            if((q==2)&&(match==1)) record[1][A.bot[i]]=A.bot[i+1];
            
            if((q==1)&&(previous==2)) record[0][A.top[i]]=A.top[i-1];
            if((q==2)&&(previous==2)) record[1][A.bot[i]]=A.bot[i-1];
            
            if(elim==0) {
                ++count;
                if(q==1) A.top[count]=A.top[i];
                if(q==2) A.bot[count]=A.bot[i];
            }
            
            previous=match;
        }
        
        //*last element*/
        if((q==1)&&(match!=2)) {++count;A.top[count]=A.top[BEFORE];}
        if((q==2)&&(match!=2)) {++count;A.bot[count]=A.bot[BEFORE];}
        
        int tlen=A.top[0];        int blen=A.bot[0];
        if((q==1)&&(match==2)) record[0][A.top[tlen]]=A.top[tlen-1];
        if((q==2)&&(match==2)) record[1][A.bot[blen]]=A.bot[blen-1];
        
        //loop is done
        if(count==0) ++count;
        
        if(q==1) A.top[0]=count;
        if(q==2) A.bot[0]=count;
        return(BEFORE-count);
    }
    
    
    
    public int playoffs() {
        int match;
        int fail=0;
	DyadicSquare A=D[D_N-1];
        for(int i=1;i<=A.top[0];++i) {
            for(int j=1;j<=A.bot[0];++j) {
                V.o1=1;V.e1=top[A.top[i]];
                V.o2=2;V.e2=bot[A.bot[j]];
                match=playoffMatch();
                if(match==0) fail=1;
                if(match==1) return(-1);
		if(match==3) addToExceptions(A.top[i],A.bot[j]);
            }
        }
        if(fail==1) return(0);
        return(1);
    }


    public int checkCertified() {
	DyadicSquare A=D[D_N-1];
        int[] cert=new int[2];
        int gm=getMatchNumber();
	if(A.age[0]==0) {
          for(int i=1;i<=A.top[0];++i) {
            for(int j=1;j<=A.bot[0];++j) {
                V.o1=1;V.e1=top[A.top[i]];
                V.o2=2;V.e2=bot[A.bot[j]];
	        numerator=getSignedNumerator();
                cert=lookupCertify(2);  
                if(cert[0]==0) return(0);
		recordCertify(2,cert);
            }
	  }
	}
        return(2);
    }
    

    
    
    public int ordinaryMatch() {
        numerator=getSignedNumerator();
	int match=0;
	int[] cert=lookupCertify(1);
	recordCertify(1,cert);
        match=signEvaluate(cert[0]);              
        if(V.o1*V.o2==1) match=3-match;    
	if(match==1) return(1);
	if(match==2) return(2);
        return(0);
    }

    //for right-abutting tile

    
    
    /**this routine is the same as the previous one, except that
     * we're more conservative about storing certificates.  We
     * don't want the list of certificates to blow up.*/
    
    public int playoffMatch() {
	int quick=0;
	quick=lookup2();
	if(quick>10) return(2);
        numerator=getSignedNumerator();

	//for palindromes we decide if the function vanishes along the right-angled line
	int vanish=0;
	if(palindrome==1) vanish=PalindromeFunction.crudeVanishingTest(numerator);
        if(vanish==1) return(3);
	int match=0;	
        int[] cert=new int[2];
	cert=lookupCertify(2);
        match=signEvaluate(cert[0]);  //do actual match
	if(match==2) cert[0]=10+cert[0];
        if(getMatchNumber()<25) recordCertify(2,cert);
        return(match);
    }
    
    public void addToExceptions(int i,int j) {
	int match=0;
	for(int ii=1;ii<=exceptions[0][0];++ii) {
	    if((i==exceptions[ii][0])&&(j==exceptions[ii][1])) match=1;
	}
	if(match==0) {
	    ++exceptions[0][0];
	    exceptions[exceptions[0][0]][0]=i;
	    exceptions[exceptions[0][0]][1]=j;
	}
    }
    
}
