import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class DyadicPlotterInit {
    Complex[] BL;
    Complex BL_CENTER;
    int obtuse;
    int right;
    int[][] rel;
    Complex[][] CORNER=new Complex[3][3];
    int[] corner=new int[3];
    DyadicSquare INIT;
    DyadicSquare D;
    CombinatorialTriangle[] CT;
    int palindrome;
    PolygonChopper PC;
    int[][] record=new int[2][300];
    int filter;
    String W;


    public DyadicPlotterInit(String W,int filter) {
       this.W=W;
       BL=LoopWord.BlikeVertices(W);  
       int[][] rel=LoopWord.relevantVertices(W);  
       PC=new PolygonChopper(W);
       palindrome=PC.palindrome;
       CT=PC.CT;
       int[] x={1,1};
       int[] y={1,1};
       INIT=new DyadicSquare(x,y,0);
       D=new DyadicSquare(x,y,0);
       int qq=W.length()/2;
       if(Spine.palindromeTest(PC.CT)==1) qq=W.length()/4+1;
       INIT.top=initPlayers(qq);
       INIT.bot=initPlayers(qq);  
       D.top=initPlayers(qq);
       D.bot=initPlayers(qq); 
       setCenter();
       setCorner(0);
       setCorner(1);
       setCorner(2);
       this.filter=filter;
       initVertices();

    }

    public int[] initPlayers(int q) {
        int[] play=new int[q+1];
        play[0]=q;
        for(int i=1;i<=q;++i) play[i]=i;
        return(play);
    }

    
    /**for some reason the signs of our functions aren't
     * computed right when our word is a palindrome starting
     * with 12 or 21.  In this case, we just turn off the
     * palindromic enhancement.*/
    
    public int awkwardWord(String X) {
        int d1=1+Spine.getDigit(X,0);
        int d2=1+Spine.getDigit(X,1);
        if(d1*d2==2) return(1);
        return(0);
    }



    public void setCorner(int i) {
        Complex Z=new Complex();
        if(i==0) Z=new Complex(1,0);
        if(i==1) Z=new Complex(0,1);
        if(i==2) Z=new Complex(1,1);
        int test=-1;
        for(int j=0;j<BL.length;++j) {
            if(Complex.dist(BL[j],Z)==0) test=j;
        }
        if(test==-1) {
            CORNER[i][0]=new Complex(Z.x,Z.y);
            CORNER[i][1]=new Complex(Z.x,Z.y);
            CORNER[i][2]=new Complex(Z.x,Z.y);
        }
        
        if(test>=0) {
            corner[i]=1;
            int i1=test-1;
            if(i1<0) i1=BL.length-1;
            int i2=test+1;
            if(i2==BL.length) i2=0;
            CORNER[i][0]=BL[test];
            CORNER[i][1]=BL[i1];
            CORNER[i][2]=BL[i2];
            
            int test1=0;
            int count1=0;
            Complex Z1=new Complex();
            while((test1==0)&&(count1<40)) {
                double t1=Math.pow(0.5,count1);
                Z1=new Complex((1-t1)*BL[test].x+t1*BL[i1].x,(1-t1)*BL[test].y+t1*BL[i1].y);
                test1=PC.testBelonging(INIT,Z1);
                ++count1;
            }
            
            int test2=0;
            int count2=0;
            Complex Z2=new Complex();
            while((test2==0)&&(count2<40)) {
                double t2=Math.pow(0.5,count2);
                Z2=new Complex((1-t2)*BL[test].x+t2*BL[i2].x,(1-t2)*BL[test].y+t2*BL[i2].y);
                test2=PC.testBelonging(INIT,Z2);
                ++count2;
            }
            
            int count=count1;
            if(count<count2) count=count2;
            double t=Math.pow(0.5,count);
            Z1=new Complex((1-t)*BL[test].x+t*BL[i1].x,(1-t)*BL[test].y+t*BL[i1].y);
            Z2=new Complex((1-t)*BL[test].x+t*BL[i2].x,(1-t)*BL[test].y+t*BL[i2].y);
            CORNER[i][1]=Z1;
            CORNER[i][2]=Z2;
            
        }
    }

    
    public void setCenter() {
        Complex Z=new Complex();
        int test=0;
        for(int i=0;i<BL.length;++i) {
            Z=Complex.plus(Z,BL[i]);
            if(BL[i].x+BL[i].y==1) ++test;
        }
        right=0;
        if(test>1) right=1;
        BL_CENTER=new Complex(Z.x/BL.length,Z.y/BL.length);
        obtuse=0;
        if(BL_CENTER.x+BL_CENTER.y<1) obtuse=1;
    }



    //these routines either do or don't use the vertices which come from
    //pat's billiard-like algorithm, depending on the mode

    public void initVertices() {
	if(filter>0) useBLVertices();
	if(filter==0) useAllVertices();
    }

    
    public void useBLVertices() {

        for(int i=0;i<INIT.top.length;++i) record[0][i]=0;
        for(int i=0;i<INIT.bot.length;++i) record[1][i]=0;
        record[0][0]=INIT.top.length;
        int[][] rel=LoopWord.relevantVertices(W);
        int count0=0;
	int count1=0;
        for(int i=1;i<=rel[1].length;++i) {
	    if(rel[1][i-1]<INIT.top.length) {
	      ++count0;
              D.bot[count0]=rel[1][i-1];
              record[1][rel[1][i-1]]=rel[1][i-1];
	    }
        }
        D.bot[0]=count0;
        
        for(int i=1;i<=rel[0].length;++i) {
	    if(rel[0][i-1]<INIT.bot.length) {
	      ++count1;
              D.top[count1]=rel[0][i-1];
              record[0][rel[0][i-1]]=rel[0][i-1];
	    }
        }
        D.top[0]=count1;
    }


    public void useAllVertices() {
        for(int i=0;i<INIT.top.length;++i) record[0][i]=i;
        for(int i=0;i<INIT.bot.length;++i) record[1][i]=i;
        record[0][0]=INIT.top.length;
    }


}