
import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class DyadicRational {
    int n;  //numerator
    int d;  //denominator is 2^d

    public DyadicRational(int n,int d) {
	this.n=n;
	this.d=d;
    }

    public DyadicRational() {}



/*this routine reduces a dyadic to the
  lowest common denominator*/

public static DyadicRational simplify(DyadicRational d)
{
    DyadicRational e=new DyadicRational(d.n,d.d);
    if(e.n==0) return(e);
    while(e.n%2==0) {
      e.n=e.n/2;
      --e.d;
    }
  return(e);
}

  public static double toDouble(DyadicRational D) {
    return(1.0*D.n*Math.pow(0.5,D.d));
  }

  public static int compare(DyadicRational D,double x) {
       double d=D.toDouble(D);
       if(d<=x) return(-1);
       if(d>x) return(1);
       return(0);
  }



    public static DyadicRational augment(DyadicRational D,int i) {
	DyadicRational E=new DyadicRational(D.n,D.d);
        while(E.d<i) {
         ++E.d;
         E.n=E.n*2;
	}
	return(E);
    }



    public static DyadicRational plus(DyadicRational D1,DyadicRational D2) {
	int d=D1.d;
        if(d<D2.d) d=D2.d;
        DyadicRational E1=augment(D1,d);
        DyadicRational E2=augment(D2,d);
	DyadicRational E=new DyadicRational(E1.n+E2.n,d);
        E=simplify(E);
        return(E);
    }



    public static DyadicRational minus(DyadicRational D1,DyadicRational D2) {
	int d=D1.d;
        if(d<D2.d) d=D2.d;
        DyadicRational E1=augment(D1,d);
        DyadicRational E2=augment(D2,d);
	DyadicRational E=new DyadicRational(E1.n-E2.n,d);
        E=simplify(E);
        return(E);
    }

    public static DyadicRational confine(DyadicRational D) {
	DyadicRational E=new DyadicRational(D.n,D.d);
	if(E.n<0) E.n=0;
	int x=(int)(Math.pow(2,E.d));
	if(E.n>x) E.n=x;
	return(E);
    }
	   

    public static DyadicRational approximate(double x,int q) {
	double nn=x*Math.pow(2.0,q);
	DyadicRational E=new DyadicRational(0,0);	
        E.n=(int)(nn);
	E.d=q;
	E=simplify(E);
	return(E);
    }




    public static int content(double x) {
	int q=0;
	if(x<.00000000001) return(-1);
	double test=1;
	while(test>x) {
	    ++q;
	    test=Math.pow(0.5,q);
	}
	return(q);
    }
    public void print() {
	System.out.println("Dyadic: "+this.n+" "+this.d);
    }

}
