import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/*This is a basic class for a rectangular button button*/

public class DyadicSquare {
    int[] x=new int[2];   //xcoord of center
    int[] y=new int[2];   //ycoord of center
    int k;        //base 2 log of radius
    int on;
    int[] top;
    int[] bot;
    VertexPair[] V1=new VertexPair[1000];
    VertexPair[] V2=new VertexPair[1000];
    int[] age=new int[2];
    
    public DyadicSquare(int[] x,int[] y,int k) {
        this.x=x;
        this.y=y;
        this.k=k;
        this.on=0;
	V1[0]=new VertexPair();
	V2[0]=new VertexPair();
	V1[0].cert=0;
	V2[0].cert=0;
	age[0]=0;
	age[1]=0;
    }

    public DyadicSquare(int i,int j,int k) {
	this.x[0]=i;
	this.x[1]=k;
	this.y[0]=j;
	this.y[1]=k;
	this.k=k-1;
	age[0]=0;
	age[1]=0;
    }

    
    public DyadicSquare() {
	V1[0]=new VertexPair();
	V2[0]=new VertexPair();	
        V1[0].cert=0;
	V2[0].cert=0;
	age[0]=0;
	age[1]=0;

    }



    
    
    
    public ListenSquare toListenSquare() {
        double xx=x[0]*Math.pow(0.5,x[1]);
        double yy=1.0-y[0]*Math.pow(0.5,y[1]);
        double r=Math.pow(0.5,k+1);
        
        ListenSquare L=new ListenSquare(xx-r,yy-r,2*r,Color.black);
        L.on=this.on;
        return(L);
    }


    public void printPlayers() {
	System.out.print("top ");
	for(int i=1;i<=top[0];++i) System.out.print(top[i]+" ");
	System.out.println("");
	System.out.print("bot ");
	for(int i=1;i<=bot[0];++i) System.out.print(bot[i]+" ");
        System.out.println("");
    }

    public void printPairs() {
	System.out.println("pairs 1");
	for(int i=1;i<=V1[0].cert;++i) {
	    System.out.print(i+"   : ");
	    V1[i].print();
	}	
	System.out.println("pairs 1");
        for(int i=1;i<=V1[0].cert;++i) {
	    System.out.print(i+"   : ");
	    V2[i].print();
	}
    }




    
    public Complex[] toPolygon() {
	Complex[] z=new Complex[4];
        double xx=x[0]*Math.pow(0.5,x[1]);
        double yy=1.0-y[0]*Math.pow(0.5,y[1]);
        double r=Math.pow(0.5,k+1);
	z[0]=new Complex(xx-r,yy-r);
	z[1]=new Complex(xx+r,yy-r);
	z[2]=new Complex(xx+r,yy+r);
	z[3]=new Complex(xx-r,yy+r);
	return(z);
    }


    
    
    public ListenSquare toListenSquare(int w,int h) {
        double xx=x[0]*Math.pow(0.5,x[1]);
        double yy=y[0]*Math.pow(0.5,y[1]);
        double r=Math.pow(0.5,k+1);
        ListenSquare L=new ListenSquare(w*xx-r*w,h*yy-r*h,2*r*w,2*r*h,Color.black);
        L.on=this.on;
        return(L);
    }
    
    
    public void print() {
        System.out.println(x[0]+" "+x[1]);
        System.out.println(y[0]+" "+y[1]);
        System.out.println(k);
	Complex Z=this.getCenter();
	Z.print();
    }
    

    public Complex getCenter() {
	Complex z=new Complex();
    	z.x=Math.pow(0.5,x[1])*x[0];
	z.y=1.0-Math.pow(0.5,y[1])*y[0];
	return(z);
    }

    
    public int inside(Point p) {
        ListenSquare L=this.toListenSquare();
        return(L.inside(p));
    }
    


    public int inside(Complex z) { 
        double xx=x[0]*Math.pow(0.5,x[1]);
        double yy=y[0]*Math.pow(0.5,y[1]);
        double r=Math.pow(0.5,k+1);
	if(z.x<xx-r) return(0);
	if(z.x>xx+r) return(0);
	if(z.y<yy-r) return(0);
	if(z.y>yy+r) return(0);
	return(1);
    }




    public void render(Graphics g,Color CC) {
        ListenSquare L=this.toListenSquare();
        L.on=1;
        L.render(g,CC);
    }
    
    public void renderSmooth(Graphics2D g,int w,int h) {
        ListenSquare L=this.toListenSquare(w,h);
        Color CC=Color.black;
        if(on==0) CC=new Color(50,0,0);
        if(on==1) CC=Color.red;
        if(on==2) CC=new Color(50,100,255);
        if(on==3) CC=new Color(255,255,0);
        L.renderSmooth2(g,CC);
    }
    
    public GeneralPath toGeneralPath(){
        double xx=x[0]*Math.pow(0.5,x[1]);
        double yy=1.0-y[0]*Math.pow(0.5,y[1]);
        double r=Math.pow(0.5,k+1);
        
        GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(xx-r),(float)(yy-r));
        gp.lineTo((float)(xx+r),(float)(yy-r));
        gp.lineTo((float)(xx+r),(float)(yy+r));
        gp.lineTo((float)(xx-r),(float)(yy+r));
        gp.closePath();
        return gp;
    }


    public GeneralPath toGeneralPathSpecial(){
        double xx=x[0]*Math.pow(0.5,x[1]);
        double yy=1.0-y[0]*Math.pow(0.5,y[1]);
        double r=Math.pow(0.5,k+1);
        
        GeneralPath gp=new GeneralPath();

        gp.moveTo((float)(xx-r),(float)(yy-r));
        gp.lineTo((float)(xx+r),(float)(yy-r));
        if(xx+yy!=1) gp.lineTo((float)(xx+r),(float)(yy+r));
        gp.lineTo((float)(xx-r),(float)(yy+r));
        gp.closePath();
        return gp;
    }







    
    public Color getColor() {
        if (on==0)
            return new Color(50,0,0);
        if(on==1)
            return Color.red;
        if(on==2)
            return new Color(50,100,255);
        if(on>=3)
        return new Color(0,0,200);
	return Color.red;
    }
    
    public static DyadicSquare subdivide(int i,int j,DyadicSquare Q) {
        DyadicSquare R=new DyadicSquare();
        R.k=Q.k+1;
        R.x[1]=Q.x[1]+1;
        R.y[1]=Q.y[1]+1;
        int ii=1-2*i;
        int jj=1-2*j;
        R.x[0]=2*Q.x[0]+ii;
        R.y[0]=2*Q.y[0]+jj;
        return(R);
    }



    public static DyadicSquare subdivideAndRemember(int uu,int vv,DyadicSquare Q) {

 
        //copying the list of players: part 1
        int N1=Q.top[0];
        int N2=Q.bot[0];
        int[] temp1=new int[N1+1];
        int[] temp2=new int[N2+1];
        for(int i=0;i<=N1;++i) temp1[i]=Q.top[i];
        for(int i=0;i<=N2;++i) temp2[i]=Q.bot[i];
        
        //copying the list of vertexpairs: part 1
        int o1,e1,o2,e2,c;
        int N3=Q.V1[0].cert;
        VertexPair[] temp3=new VertexPair[N3+1];
        for(int i=0;i<=N3;++i) {
            o1=Q.V1[i].o1;
            e1=Q.V1[i].e1;
            o2=Q.V1[i].o2;
            e2=Q.V1[i].e2;
            c=Q.V1[i].cert;
            temp3[i]=new VertexPair(o1,e1,o2,e2,c);
        }
        
        //copying the list of vertexpairs: part 1
        int N4=Q.V2[0].cert;
        VertexPair[] temp4=new VertexPair[N4+1];
        for(int i=0;i<=N4;++i) {
            o1=Q.V2[i].o1;
            e1=Q.V2[i].e1;
            o2=Q.V2[i].o2;
            e2=Q.V2[i].e2;
            c=Q.V2[i].cert;
            temp4[i]=new VertexPair(o1,e1,o2,e2,c);
        }
        
        /********start of  physical subdivision*******/
        DyadicSquare R=DyadicSquare.subdivide(uu,vv,Q);
        /*********end of physical subdivision**************/
        
        //copying the list of players.  Part 2:
            R.top=new int[N1+1];
            R.bot=new int[N2+1];
            for(int j=0;j<=N1;++j) R.top[j]=temp1[j];
            for(int j=0;j<=N2;++j) R.bot[j]=temp2[j];
        
        //copying the list of vertexpairs.  Part 2:
            R.V1=new VertexPair[1000];
            for(int j=0;j<=N3;++j) {
                o1=temp3[j].o1;
                e1=temp3[j].e1;
                o2=temp3[j].o2;
                e2=temp3[j].e2;
                c=temp3[j].cert;
                R.V1[j]=new VertexPair(o1,e1,o2,e2,c);
            }
        
        //copying the list of vertexpairs.  Part 2:
            R.V2=new VertexPair[1000];
            for(int j=0;j<=N4;++j) {
                o1=temp4[j].o1;
                e1=temp4[j].e1;
                o2=temp4[j].o2;
                e2=temp4[j].e2;
                c=temp4[j].cert;
                R.V2[j]=new VertexPair(o1,e1,o2,e2,c);
            }
	    R.age[0]=Q.age[0];
	    R.age[1]=Q.age[1];
	    return(R);
    }




    public static DyadicSquare copy(DyadicSquare Q) {

 
        //copying the list of players: part 1
        int N1=Q.top[0];
        int N2=Q.bot[0];
        int[] temp1=new int[N1+1];
        int[] temp2=new int[N2+1];
        for(int i=0;i<=N1;++i) temp1[i]=Q.top[i];
        for(int i=0;i<=N2;++i) temp2[i]=Q.bot[i];
        
        //copying the list of vertexpairs: part 1
        int o1,e1,o2,e2,c;
        int N3=Q.V1[0].cert;
        VertexPair[] temp3=new VertexPair[N3+1];
        for(int i=0;i<=N3;++i) {
            o1=Q.V1[i].o1;
            e1=Q.V1[i].e1;
            o2=Q.V1[i].o2;
            e2=Q.V1[i].e2;
            c=Q.V1[i].cert;
            temp3[i]=new VertexPair(o1,e1,o2,e2,c);
        }
        
        //copying the list of vertexpairs: part 1
        int N4=Q.V2[0].cert;
        VertexPair[] temp4=new VertexPair[N4+1];
        for(int i=0;i<=N4;++i) {
            o1=Q.V2[i].o1;
            e1=Q.V2[i].e1;
            o2=Q.V2[i].o2;
            e2=Q.V2[i].e2;
            c=Q.V2[i].cert;
            temp4[i]=new VertexPair(o1,e1,o2,e2,c);
        }
        
        /********start of  physical subdivision*******/
	DyadicSquare R=new DyadicSquare(Q.x,Q.y,Q.k);
        /*********end of physical subdivision**************/
        
        //copying the list of players.  Part 2:
            R.top=new int[N1+1];
            R.bot=new int[N2+1];
            for(int j=0;j<=N1;++j) R.top[j]=temp1[j];
            for(int j=0;j<=N2;++j) R.bot[j]=temp2[j];
        
        //copying the list of vertexpairs.  Part 2:
            R.V1=new VertexPair[1000];
            for(int j=0;j<=N3;++j) {
                o1=temp3[j].o1;
                e1=temp3[j].e1;
                o2=temp3[j].o2;
                e2=temp3[j].e2;
                c=temp3[j].cert;
                R.V1[j]=new VertexPair(o1,e1,o2,e2,c);
            }
        
        //copying the list of vertexpairs.  Part 2:
            R.V2=new VertexPair[1000];
            for(int j=0;j<=N4;++j) {
                o1=temp4[j].o1;
                e1=temp4[j].e1;
                o2=temp4[j].o2;
                e2=temp4[j].e2;
                c=temp4[j].cert;
                R.V2[j]=new VertexPair(o1,e1,o2,e2,c);
            }
	    R.age[0]=Q.age[0];
	    R.age[1]=Q.age[1];
	    return(R);
    }
}
    
    





