
/*********************************
   This file contains the
   basic algebraic manipulations
   between our structures
*********************************/


double arg(z)
complex z;
{
double d;
double atan2();
d=atan2(z.y,z.x);
if(z.y<0.0) d=d+2.0*+Pi;
return(d);
}



complex convert(r,s)
     double r,s;
{
  complex z;
  z.x=r;
  z.y=s;
  return(z);
}


complex times(z,w)
     complex z,w;
{
  complex y;
  y.x=z.x*w.x-z.y*w.y;
  y.y=z.x*w.y+z.y*w.x;
  return(y);
}

complex plus(z,w)
     complex z,w;
{
  complex y;
  y.x=z.x+w.x;
  y.y=z.y+w.y;
  return(y);
}

complex minus(z,w)
     complex z,w;
{
  complex y;
  y.x=z.x-w.x;
  y.y=z.y-w.y;
  return(y);
}


complex inverse(z)
complex z;
{
complex w;
double d;
d=sqrt(z.x*z.x+z.y*z.y);
w.x= z.x/(z.x*z.x+z.y*z.y);
w.y=-z.y/(z.x*z.x+z.y*z.y);
return(w);
}


complex divide(p,q)
complex p,q;
{
complex r;
r=times(p,inverse(q));
return(r);
}



complex conjugate(z)
complex z;
{
complex w;
w.x= z.x;
w.y=-z.y;
return(w);
}



double norm(z)
complex z;
{
complex w;
double d, sqrt();
w=times(z,conjugate(z));
d=w.x;
d=sqrt(d);
return(d);
}


double dist(z1,z2)
     complex z1,z2;
{
  double d;
  d=(z1.x-z2.x)*(z1.x-z2.x);
  d=d+(z1.y-z2.y)*(z1.y-z2.y);
  return(sqrt(d));
}


double area(z1,z2,z3) 
     complex z1,z2,z3;
{
  double a;
  complex z[10];
  z[1]=minus(z2,z1);
  z[2]=minus(z3,z1);
  z[3]=conjugate(z[2]);
  z[4]=times(z[1],z[3]);
  a=z[4].y;
  return(a);
}


complex unit(z)
     complex z;
{
  complex w;
  w.x=z.x/norm(z);
  w.y=z.y/norm(z);
  return(w);
}

complex interpolate(z1,z2)
     complex z1,z2;
{
  complex w;
  w=plus(z1,z2);
  w.x=w.x/2.0;
  w.y=w.y/2.0;
  return(w);
}






int mod(k,n)
     int k,n;
{
  int j;
  j=k%n;
  if(j<=0) j=j+n;
  return(j);
}




double pseudorandom(n,p)
     int n,p;
{
  double d,pp,nn;
  pp=p;
  nn=n;
  d=nn*sqrt(pp);
  d=d-floor(d);
  return(d);
}





/*finding the intersection point*/


vector cross(V,W)
     vector V,W;
{
  vector X;
  X.x=V.y*W.z-V.z*W.y;
  X.y=V.z*W.x-V.x*W.z;
  X.z=V.x*W.y-V.y*W.x;
  return(X);
}

vector newvector(x,y,z)
     double x,y,z;
{
  vector v;
  v.x=x;
  v.y=y;
  v.z=z;
  return(v);
}


/*finds the intersection of the line
  from z1 to z3 with the line
  from z2 to z4.  We think of
  z1,z2,z3,z4 as tracing out
  a quadrilateral and we are
  looking for the intersection
  of the diagonals. */

complex intersect(z1,z2,z3,z4)
     complex z1,z2,z3,z4;
{
  vector v1,v2,v3,v4,v5,v6,v7;
  complex z;
  v1=newvector(z1.x,z1.y,1.0);
  v2=newvector(z2.x,z2.y,1.0);	
  v3=newvector(z3.x,z3.y,1.0);
  v4=newvector(z4.x,z4.y,1.0);
  v5=cross(v1,v3);
  v6=cross(v2,v4);
  v7=cross(v5,v6);
  z.x=v7.x/v7.z;
  z.y=v7.y/v7.z;
  return(z);
}


matrix2 inverse_matrix(m)
     matrix2 m;
{
  double d;
  matrix2 z;
  d=m.a[1][1]*m.a[2][2]-m.a[1][2]*m.a[2][1];
  z.a[1][1]=m.a[2][2]/d;
  z.a[1][2]=-m.a[1][2]/d;
  z.a[2][1]=-m.a[2][1]/d;
  z.a[2][2]=m.a[1][1]/d;
  return(z);
}




/*making the triangle*/

triangle triangle_make(z)
     complex z;
{
  double x,y,xx,yy;
  triangle T;
  x=Pi*z.x/2.0;
  y=Pi*z.y/2.0;
  xx=(tan(x)*tan(y))/(tan(x)+tan(y));
  yy=         tan(y)/(tan(x)+tan(y));
  T.z1=convert(0.0,0.0);
  T.z2=convert(0.0,1.0);
  T.z3.x=xx;
  T.z3.y=yy;
  return(T);
}




