

/*this routine computes the combinatorial
  structure of the top and bottom edge paths.
The structure is encoded in 6 words, each
having half the length of the original word:

word1: the list of edges of the top path
word2: the list of triangles intervening
       between consecutive top edges.
word3: the list of angles between
       consecutive top edges.

words4,5,6: the same for the bottom. 
The routine works by testing the word
out on a particular triangle.  We use
the 30-60-90 triangle.  Any triangle
gives the same answer, as long as it
is not isosceles.
*/



unfold edge_structure(w) 
     word w;
{
  word W[5];
  triangle T;
  complex z[5];
  double d[5];
  unfold U;
  int i,count,count2;
  int a,b,c,turn;
  triangle_list X;

 

    U.w[0]=w;
  T=triangle_make(convert(Pi/6.0,Pi/3.0));
  X=apply(w,T);
  count=1;
  count2=1;

  d[1]=dist(T.z3,T.z2);
  d[2]=dist(T.z1,T.z3);
  d[3]=dist(T.z2,T.z1);

  /*compute initial turn, clockwise or counterclockwise*/

  turn=-1;
  a=w.n[1];
  b=w.n[2];
  if((a==1)&&(b==2)) turn=1;
  if((a==2)&&(b==3)) turn=1;
  if((a==3)&&(b==1)) turn=1;




  /*get top vertices*/

  z[1]=get_endpoint(1,X);
  U.z[1]=z[1];
  count=1;
  for(i=1;i<=X.l;++i) {
    z[2]=vertex(1,X.T[i],i);
    d[4]=dist(z[1],z[2]);

    if(d[4]>.01) {
      if(fabs(d[4]-d[1])<.00001) U.w[1].n[count]=1;
      if(fabs(d[4]-d[2])<.00001) U.w[1].n[count]=2;
      if(fabs(d[4]-d[3])<.00001) U.w[1].n[count]=3;
      ++count;
      U.w[0].n[count2]=i;
      ++count2;
    }
    z[1]=z[2];
  }

  /* and one extra */
    z[2]=get_endpoint(3,X);
    d[4]=dist(z[1],z[2]);
    if(d[4]>.01) {
      if(fabs(d[4]-d[1])<.00001) U.w[1].n[count]=1;
      if(fabs(d[4]-d[2])<.00001) U.w[1].n[count]=2;
      if(fabs(d[4]-d[3])<.00001) U.w[1].n[count]=3;
      ++count;
    }

    U.w[1].l=count-1;
    U.w[0].n[count2]=w.l+1;
    U.w[0].l=count2;





    /*get top vertex parameters*/


    if(turn==1) U.w[3].n[1]=6-U.w[1].n[1]-w.n[1];  
    if(turn==-1)  U.w[3].n[1]=6-w.n[1]-w.n[2];

    U.w[2].n[1]=U.w[0].n[1]-1;
    for(i=1;i<count;++i) {
      a=U.w[0].n[i];
      b=U.w[0].n[i+1];
      U.w[2].n[i+1]=b-a+1;

      if(U.w[1].n[i+1]!=U.w[1].n[i]) 
	U.w[3].n[i+1]=6-U.w[1].n[i]-U.w[1].n[i+1];

      if(U.w[1].n[i+1]==U.w[1].n[i]) 
	  U.w[3].n[i+1]=6-U.w[3].n[i]-U.w[1].n[i];
    }

    U.w[2].l=U.w[1].l;
    U.w[3].l=U.w[1].l;

    W[1].n[0]=0;
    W[2].n[0]=0;
    W[3].n[0]=0;    

    for(i=1;i<=U.w[1].l;++i) {
      a=U.w[3].n[i];
      W[1].n[i]=W[1].n[i-1];
      W[2].n[i]=W[2].n[i-1];
      W[3].n[i]=W[3].n[i-1];
      W[a].n[i]=W[a].n[i]+U.w[2].n[i];
    }

    W[1].l=U.w[2].l;
    W[2].l=U.w[2].l;
    W[3].l=U.w[2].l;
    U.w[2]=W[1];
    U.w[3]=W[2];
    U.w[4]=W[3];







    /*get bottom vertices*/

    count2=1;
    z[1]=get_endpoint(2,X);
    count=1;
    for(i=1;i<=X.l;++i) {
      z[2]=vertex(2,X.T[i],i);
      d[4]=dist(z[1],z[2]);

    if(d[4]>.01) {
      if(fabs(d[4]-d[1])<.00001) U.w[5].n[count]=1;
      if(fabs(d[4]-d[2])<.00001) U.w[5].n[count]=2;
      if(fabs(d[4]-d[3])<.00001) U.w[5].n[count]=3;
      ++count;
      U.w[0].n[count2]=i;
      ++count2;
    }
    z[1]=z[2];
  }

    z[2]=get_endpoint(4,X);
    d[4]=dist(z[1],z[2]);
    if(d[4]>.01) {
      if(fabs(d[4]-d[1])<.00001) U.w[5].n[count]=1;
      if(fabs(d[4]-d[2])<.00001) U.w[5].n[count]=2;
      if(fabs(d[4]-d[3])<.00001) U.w[5].n[count]=3;
      ++count;
    }

    U.w[5].l=count-1;
    U.w[0].n[count2]=w.l+1;
    U.w[0].l=count2;

    /*get bottom vertex parameters*/
    U.w[6].n[1]=U.w[0].n[1]-1;

    if(turn==-1)   U.w[7].n[1]=6-U.w[5].n[1]-w.n[1];  
    if(turn==1)  U.w[7].n[1]=6-w.n[1]-w.n[2];


    for(i=1;i<count;++i) {
      a=U.w[0].n[i];
      b=U.w[0].n[i+1];
      U.w[6].n[i+1]=b-a+1;

      if(U.w[5].n[i+1]!=U.w[5].n[i]) 
	U.w[7].n[i+1]=6-U.w[5].n[i]-U.w[5].n[i+1];

      if(U.w[5].n[i+1]==U.w[5].n[i]) 
	  U.w[7].n[i+1]=6-U.w[7].n[i]-U.w[5].n[i];
    }

    U.w[6].l=U.w[5].l;
    U.w[7].l=U.w[5].l;

    W[1].n[0]=0;
    W[2].n[0]=0;
    W[3].n[0]=0;    

    for(i=1;i<=U.w[1].l;++i) {
      a=U.w[7].n[i];
      W[1].n[i]=W[1].n[i-1];
      W[2].n[i]=W[2].n[i-1];
      W[3].n[i]=W[3].n[i-1];
      W[a].n[i]=W[a].n[i]+U.w[6].n[i];
    }

    U.w[6]=W[1];
    U.w[7]=W[2];
    U.w[8]=W[3];

    return(U);
}


unfold assign_geometry(U,zzz) 
     unfold U;
     complex zzz;
{
  triangle T;
  unfold V;
  V=U;

  T=triangle_make(zzz); 
  V.d[1]=dist(T.z3,T.z2);
  V.d[2]=dist(T.z1,T.z3);
  V.d[3]=dist(T.z2,T.z1);
  V.a[1]=Pi*zzz.x/2.0;
  V.a[2]=Pi*zzz.y/2.0;
  V.a[3]=Pi-V.a[1]-V.a[2];
  V.z[1]=T.z1;
  V.z[2]=T.z2;
  return(V);
}




complex top_position(U,k)
     unfold U;
     int k;
{
  triangle T;
  complex z;
  int i;
  double dist;
  int c[4];
  double a[4];
  double d[4];

  z=U.z[1];
  a[1]=U.a[1];
  a[2]=U.a[2];
  a[3]=U.a[3];
  d[1]=U.d[1];
  d[2]=U.d[2];
  d[3]=U.d[3];



  for(i=1;i<=k;++i) {
    dist=d[U.w[1].n[i]];
    c[1]=U.w[2].n[i];
    c[2]=U.w[3].n[i];
    c[3]=U.w[4].n[i];
    a[0]=c[1]*a[1]+c[2]*a[2]+c[3]*a[3];
    a[0]=a[0]+Pi*(i%2);
    z.x=z.x+dist*sin(a[0]);
    z.y=z.y-dist*cos(a[0]);
  }
  return(z);
}






complex bottom_position(U,k)
     unfold U;
     int k;
{
  triangle T;
  complex z;
  int i;
  double dist;
  int c[4];
  double a[4];
  double d[4];

  z=U.z[2];
  a[1]=U.a[1];
  a[2]=U.a[2];
  a[3]=U.a[3];
  d[1]=U.d[1];
  d[2]=U.d[2];
  d[3]=U.d[3];

  for(i=1;i<=k;++i) {
    dist=d[U.w[5].n[i]];
    c[1]=U.w[6].n[i];
    c[2]=U.w[7].n[i];
    c[3]=U.w[8].n[i];
    a[0]=c[1]*a[1]+c[2]*a[2]+c[3]*a[3];
    a[0]=a[0]+Pi*(i%2);
    z.x=z.x+dist*sin(a[0]);
    z.y=z.y+dist*cos(a[0]);
  }
  return(z);
}


int corridor_test(U)
     unfold U;
{
  complex z1,z2,z3,z4;
  int len;
  double dist;
  double a[4];
  double d[4];
  int c[4];
  double min,max,tmin,tmax;
  int i;

  min=-10000.0;
  max=10000.0;  
  len=U.w[1].l;

  a[1]=U.a[1];
  a[2]=U.a[2];
  a[3]=U.a[3];
  d[1]=U.d[1];
  d[2]=U.d[2];
  d[3]=U.d[3];

  z1=top_position(U,0);
  z2=top_position(U,len);
  z3=top_position(U,0);
  z4=bottom_position(U,0);

  for(i=1;i<=len;++i) {
    dist=d[U.w[1].n[i]];
    c[1]=U.w[2].n[i];
    c[2]=U.w[3].n[i];
    c[3]=U.w[4].n[i];
    a[0]=c[1]*a[1]+c[2]*a[2]+c[3]*a[3];
    a[0]=a[0]+Pi*(i%2);
    z3.x=z3.x+dist*sin(a[0]);
    z3.y=z3.y-dist*cos(a[0]);
  
    dist=d[U.w[5].n[i]];
    c[1]=U.w[6].n[i];
    c[2]=U.w[7].n[i];
    c[3]=U.w[8].n[i];
    a[0]=c[1]*a[1]+c[2]*a[2]+c[3]*a[3];
    a[0]=a[0]+Pi*(i%2);
    z4.x=z4.x+dist*sin(a[0]);
    z4.y=z4.y+dist*cos(a[0]);

    tmin=area(z1,z2,z3);
    tmax=area(z1,z2,z4);
    if(tmin>min) min=tmin;
    if(tmax<max) max=tmax;
    if(min>max) return(0);
  }
  return(1);
}





/*these routines get the vertices which define
the corridor.  We have a tolerance of .000001.
This fairly loose tolerance seems to suit
our purposes well. */


word get_all_leaders1(U)
     unfold U;
{
  word w;
  complex z1,z2,z3;
  int len;
  double dist;
  double a[4];
  double d[4];
  int c[4];
  double min,tmin;
  int i;

  min=-10000.0;
  len=U.w[1].l;

  a[1]=U.a[1];
  a[2]=U.a[2];
  a[3]=U.a[3];
  d[1]=U.d[1];
  d[2]=U.d[2];
  d[3]=U.d[3];

  z1=top_position(U,0);
  z2=top_position(U,len);
  z3=top_position(U,0);
  w.l=0;

  for(i=1;i<=len;++i) {
    dist=d[U.w[1].n[i]];
    c[1]=U.w[2].n[i];
    c[2]=U.w[3].n[i];
    c[3]=U.w[4].n[i];
    a[0]=c[1]*a[1]+c[2]*a[2]+c[3]*a[3];
    a[0]=a[0]+Pi*(i%2);
    z3.x=z3.x+dist*sin(a[0]);
    z3.y=z3.y-dist*cos(a[0]);
    tmin=area(z1,z2,z3);
    if(fabs(tmin-min)<.000001) {
      ++w.l;
      w.n[w.l]=i;
    }
    if(tmin>=min+.000001) {
      w.l=1;
      w.n[1]=i;
      min=tmin;
    }

  }
    return(w);
}



word get_all_leaders2(U)
     unfold U;
{
  word w;
  complex z1,z2,z4;
  int len;
  double dist;
  double a[4];
  double d[4];
  int c[4];
  double max,tmax;
  int i;

  max=10000.0;
  len=U.w[1].l;

  a[1]=U.a[1];
  a[2]=U.a[2];
  a[3]=U.a[3];
  d[1]=U.d[1];
  d[2]=U.d[2];
  d[3]=U.d[3];

  z1=top_position(U,0);
  z2=top_position(U,len);
  z4=bottom_position(U,0);
  w.l=0;

  for(i=1;i<=len;++i) {
    dist=d[U.w[5].n[i]];
    c[1]=U.w[6].n[i];
    c[2]=U.w[7].n[i];
    c[3]=U.w[8].n[i];
    a[0]=c[1]*a[1]+c[2]*a[2]+c[3]*a[3];
    a[0]=a[0]+Pi*(i%2);
    z4.x=z4.x+dist*sin(a[0]);
    z4.y=z4.y+dist*cos(a[0]);
    tmax=area(z1,z2,z4); 

   if(fabs(tmax-max)<.000001) {
      ++w.l;
      w.n[w.l]=i;
    }

  if(tmax<=max-.000001) {
      w.l=1;
      w.n[1]=i;
      max=tmax;
    }


  }

    return(w);

}

word get_all_leaders(U,k)
   unfold U;
   int k;
{
  if(k==1) return(get_all_leaders1(U));
  return(get_all_leaders2(U));
}





