word_link psearch(T,DEPTH)
     ptriangle T;
     int DEPTH;
{
  word_link SUCCEED;
  pword_list TRY;
  pword *w;
  int last;
  int pl1,pl2; // for future lexi test
  reflection r;
  word new;

  SUCCEED=NULL;
  pword_list_initialize(&TRY,DEPTH);

  reflect_from_ptriangle(T,&r); // stores the matrices of reflections

  TRY.l=1;

  // this initializes our pword and phull.
  pword_empty(&(TRY.w[0]));
  phull_setup(&(TRY.w[0].h));
  addLetter(&(TRY.w[0]), 0);
  addLetter(&(TRY.w[0]), 1);
  TRY.w[0].h.last_left->z=T.z3;
  TRY.w[0].h.last_right->z=T.z2;
  //phull_insert(&(TRY.w[0].h), T.z3, -1);
  timesEquals(&(TRY.w[0].m), &(r.m[0]));
  phull_insert(&(TRY.w[0].h), eucTimes(&(TRY.w[0].m),T.z1), 1);
  timesEquals(&(TRY.w[0].m), &(r.m[1]));
  // This certainly passes the balance and lexi test
  TRY.w[0].lexi=TRY.w[0].w.first;
  TRY.w[0].lexi_count=0;
  TRY.w[0].h.current=NULL;

  setArea(&(TRY.w[0].h));



  while (TRY.l>0){

    w=&(TRY.w[TRY.l-1]);
    if (pweak_test(w)==1){ // if fails weak test 
      pword_destroy(w);
      TRY.l--;
    } else { // passes weak test

	if (pbalance(w)==0) // balanced word
	  if (pstrong_test(w)==0){ //if passes strong test
	    if (power_test(&(w->w))){ // if not a power of an even word
	      word_copy(&(w->w),&new);
	      if (!word_palindrome(&new)){
		//fprintf(stderr,"psearch: not a palindrome.\n");
		word_simplify(&new);
	      }
	      SUCCEED=word_insert(SUCCEED,&new);
	    }
	  }
	// now we consider adding letters to our word
	last=w->w.last->l;
	
	if ((future_pbalance(w,(last+1)%3)+w->w.l+1<=DEPTH)&&
	    ((pl1=future_plexi_test(w, (last+1)%3))!=-1)){ //if first one passes
	  if ((future_pbalance(w,(last+2)%3)+w->w.l+1<=DEPTH)&&
	      ((pl2=future_plexi_test(w, (last+2)%3))!=-1)){ //and second one passes
	    if (TRY.l<TRY.MAX_DEPTH){ // This should always be true
	      pword_copy(w,&(TRY.w[TRY.l]));
	      addLetter_r(&(TRY.w[TRY.l]),(last+2)%3,&r,&T);
	      if (pl2==0){
		TRY.w[TRY.l].lexi=TRY.w[TRY.l].w.first;
	      TRY.w[TRY.l].lexi_count=0;
	      } else {
		TRY.w[TRY.l].lexi=TRY.w[TRY.l].lexi->next;
		TRY.w[TRY.l].lexi_count++;
	      }
	      TRY.l++;	  
	    }
	    
	    addLetter_r(w,(last+1)%3,&r,&T);
	    
	    //lexi test upkeep
	    if (pl1==0){
	      w->lexi=w->w.first;
	      w->lexi_count=0;
	    } else {
	      w->lexi=w->lexi->next;
	      w->lexi_count++;
	    }	 
	  } else { // only first passes;
	    addLetter_r(w,(last+1)%3,&r,&T);
	    // some lexi upkeep
	    if (pl1==0){
	      w->lexi=w->w.first;
	      w->lexi_count=0;
	    } else {
	      w->lexi=w->lexi->next;
	      w->lexi_count++;
	    }
	  }
	} else if ((future_pbalance(w,(last+2)%3)+w->w.l+1<=DEPTH)&&
		   ((pl2=future_plexi_test(w, (last+2)%3))!=-1)){ //first failed, if second one passes
	  addLetter_r(w,(last+2)%3,&r,&T);
	  // lexi upkeep
	  if (pl2==0){
	    w->lexi=w->w.first;
	    w->lexi_count=0;
	  } else {
	    w->lexi=w->lexi->next;
	    w->lexi_count++;
	}
	} else { // we are at a dead end.
	  pword_destroy(w);
	  TRY.l--;
	}
      }
    //}
  } 

  pwordlist_destroy(&TRY);
  return SUCCEED;  

}








word_link multi_psearch(T,num,DEPTH)
     ptriangle T[];
     int num;
     int DEPTH;
{
  word_link SUCCEED;
  multi_pword_list TRY;
  multi_pword *w;
  int last,i;
  int pl1, pl2; // for future lexi test
  reflection *r;
  word new;

  r=(reflection *) malloc(num*sizeof(reflection));
  SUCCEED=NULL;
  multi_pword_list_initialize(&TRY,DEPTH);

  for (i=0;i<num; i++)
    reflect_from_ptriangle(T[i],&(r[i])); // stores the matrices of reflections

  TRY.l=1;

  // this initializes our pword and phull.
  multi_pword_empty(&(TRY.w[0]),num);
  multi_pword_addLetter(&(TRY.w[0]), 0);
  multi_pword_addLetter(&(TRY.w[0]), 1);
  for (i=0; i<num; i++){
    phull_setup(&(TRY.w[0].h[i]));
    TRY.w[0].h[i].last_left->z=T[i].z3;
    TRY.w[0].h[i].last_right->z=T[i].z2;
    timesEquals(&(TRY.w[0].m[i]), &(r[i].m[0]));
    phull_insert(&(TRY.w[0].h[i]), eucTimes(&(TRY.w[0].m[i]),T[i].z1), 1);
    timesEquals(&(TRY.w[0].m[i]), &(r[i].m[1]));
    TRY.w[0].h[i].current=NULL;
  }    

  // This certainly passes the balance and lexi test    
  TRY.w[0].lexi=TRY.w[0].w.first;
  TRY.w[0].lexi_count=0;

  while (TRY.l>0){
    w=&(TRY.w[TRY.l-1]);
    //phull_print_file(stdout,&(w->h[0]));

    if (multi_pweak_test(w)==1){ // if fails weak test 
      multi_pword_destroy(w);
      TRY.l--;
    } else { // passes weak test
      
	if (multi_pbalance(w)==0){ // balanced word
	  if (multi_pstrong_test(w)==0){ //if passes strong test
	    if (power_test(&(w->w))){ // if not a power of an even word
	      word_copy(&(w->w),&new);
	      word_simplify(&new);
	      SUCCEED=word_insert(SUCCEED,&new);
	    }
	  }
	}
	// now we consider adding letters to our word
	last=w->w.last->l;
	
	if ((future_multi_pbalance(w,(last+1)%3)+w->w.l+1<=DEPTH)&&
	    ((pl1=future_multi_plexi_test(w, (last+1)%3))!=-1)){ //if first one passes
	  if ((future_multi_pbalance(w,(last+2)%3)+w->w.l+1<=DEPTH)&&
	      ((pl2=future_multi_plexi_test(w, (last+2)%3))!=-1)){ //and second one passes
	    if (TRY.l<TRY.MAX_DEPTH){ // This should always be true
	      multi_pword_copy(w,&(TRY.w[TRY.l]));
	      multi_pword_addLetter_r(&(TRY.w[TRY.l]),(last+2)%3,r,T);
	      if (pl2==0){
		TRY.w[TRY.l].lexi=TRY.w[TRY.l].w.first;
		TRY.w[TRY.l].lexi_count=0;
	      } else {
		TRY.w[TRY.l].lexi=TRY.w[TRY.l].lexi->next;
		TRY.w[TRY.l].lexi_count++;
	      }
	      TRY.l++;	  
	    }
	    
	    multi_pword_addLetter_r(w,(last+1)%3,r,T);
	    
	    //lexi test upkeep
	    if (pl1==0){
	      w->lexi=w->w.first;
	      w->lexi_count=0;
	    } else {
	      w->lexi=w->lexi->next;
	      w->lexi_count++;
	    }	 
	  } else { // only first passes;
	    multi_pword_addLetter_r(w,(last+1)%3,r,T);
	    // some lexi upkeep
	    if (pl1==0){
	      w->lexi=w->w.first;
	      w->lexi_count=0;
	    } else {
	      w->lexi=w->lexi->next;
	      w->lexi_count++;
	    }
	  }
	} else if ((future_multi_pbalance(w,(last+2)%3)+w->w.l+1<=DEPTH)&&
		   ((pl2=future_multi_plexi_test(w, (last+2)%3))!=-1)){ //first failed, if second one passes
	  multi_pword_addLetter_r(w,(last+2)%3,r,T);
	  // lexi upkeep
	  if (pl2==0){
	    w->lexi=w->w.first;
	    w->lexi_count=0;
	  } else {
	    w->lexi=w->lexi->next;
	    w->lexi_count++;
	  }
	} else { // we are at a dead end.
	  multi_pword_destroy(w);
	  TRY.l--;
	}
    }
  } 
  
  free(r);

  multi_pword_list_destroy(&TRY);
  return SUCCEED;  

}



// fill_search
// finds the word of minimal length which contains 
// the given triangles
//
// Parameters:
// T --- a list of triangles
// num --- the number of those triangles
// DEPTH --- maximum word length to look for

word fill_search(T,num,DEPTH)
     triangle T[];
     int num;
     int DEPTH;
{
  word SUCCEED;
  multi_pword_list TRY;
  multi_pword *w;
  int last,i;
  int pl1, pl2; // for future lexi test
  reflection *r;
  //word new;

  r=(reflection *) malloc(num*sizeof(reflection));
  word_empty(&SUCCEED);
  multi_pword_list_initialize(&TRY,DEPTH);

  for (i=0;i<num; i++)
    reflect_from_triangle(T[i],&(r[i])); // stores the matrices of reflections

  TRY.l=1;

  // this initializes our pword and phull.
  multi_pword_empty(&(TRY.w[0]),num);
  multi_pword_addLetter(&(TRY.w[0]), 0);
  multi_pword_addLetter(&(TRY.w[0]), 1);
  for (i=0; i<num; i++){
    phull_setup(&(TRY.w[0].h[i]));
    TRY.w[0].h[i].last_left->z=T[i].z[2];
    TRY.w[0].h[i].last_right->z=T[i].z[1];
    timesEquals(&(TRY.w[0].m[i]), &(r[i].m[0]));
    phull_insert(&(TRY.w[0].h[i]), eucTimes(&(TRY.w[0].m[i]),T[i].z[0]), 1);
    timesEquals(&(TRY.w[0].m[i]), &(r[i].m[1]));
    TRY.w[0].h[i].current=NULL;
  }    

  // This certainly passes the balance and lexi test    
  TRY.w[0].lexi=TRY.w[0].w.first;
  TRY.w[0].lexi_count=0;

  while (TRY.l>0){
    w=&(TRY.w[TRY.l-1]);
    //phull_print_file(stdout,&(w->h[0]));

    if (multi_pweak_test(w)==1){ // if fails weak test 
      multi_pword_destroy(w);
      TRY.l--;
    } else { // passes weak test
      
	if (multi_pbalance(w)==0){ // balanced word
	  if (multi_pstrong_test(w)==0){ //if passes strong test
	    if ((SUCCEED.l==0)||(SUCCEED.l>w->w.l)){
	      if (SUCCEED.l!=0)
		word_destroy(&SUCCEED);
	      word_copy(&(w->w),&SUCCEED);
	      DEPTH=w->w.l-2;
	    }
	  }
	}
	// now we consider adding letters to our word
	last=w->w.last->l;
	
	if ((future_multi_pbalance(w,(last+1)%3)+w->w.l+1<=DEPTH)&&
	    ((pl1=future_multi_plexi_test(w, (last+1)%3))!=-1)){ //if first one passes
	  if ((future_multi_pbalance(w,(last+2)%3)+w->w.l+1<=DEPTH)&&
	      ((pl2=future_multi_plexi_test(w, (last+2)%3))!=-1)){ //and second one passes
	    if (TRY.l<TRY.MAX_DEPTH){ // This should always be true
	      multi_pword_copy(w,&(TRY.w[TRY.l]));
	      multi_pword_addLetter_rt(&(TRY.w[TRY.l]),(last+2)%3,r,T);
	      if (pl2==0){
		TRY.w[TRY.l].lexi=TRY.w[TRY.l].w.first;
		TRY.w[TRY.l].lexi_count=0;
	      } else {
		TRY.w[TRY.l].lexi=TRY.w[TRY.l].lexi->next;
		TRY.w[TRY.l].lexi_count++;
	      }
	      TRY.l++;	  
	    }
	    
	    multi_pword_addLetter_rt(w,(last+1)%3,r,T);
	    
	    //lexi test upkeep
	    if (pl1==0){
	      w->lexi=w->w.first;
	      w->lexi_count=0;
	    } else {
	      w->lexi=w->lexi->next;
	      w->lexi_count++;
	    }	 
	  } else { // only first passes;
	    multi_pword_addLetter_rt(w,(last+1)%3,r,T);
	    // some lexi upkeep
	    if (pl1==0){
	      w->lexi=w->w.first;
	      w->lexi_count=0;
	    } else {
	      w->lexi=w->lexi->next;
	      w->lexi_count++;
	    }
	  }
	} else if ((future_multi_pbalance(w,(last+2)%3)+w->w.l+1<=DEPTH)&&
		   ((pl2=future_multi_plexi_test(w, (last+2)%3))!=-1)){ //first failed, if second one passes
	  multi_pword_addLetter_rt(w,(last+2)%3,r,T);
	  // lexi upkeep
	  if (pl2==0){
	    w->lexi=w->w.first;
	    w->lexi_count=0;
	  } else {
	    w->lexi=w->lexi->next;
	    w->lexi_count++;
	  }
	} else { // we are at a dead end.
	  multi_pword_destroy(w);
	  TRY.l--;
	}
    }
  } 
  
  free(r);

  multi_pword_list_destroy(&TRY);
  return SUCCEED;  

}
