void word_reverse(w)
     word *w;
{
  Pletter l,m;

  l=w->first;
  while (l!=w->last){
    m=l->next;
    l->next=l->prev;
    l->prev=m;
    l=l->prev;
  }
  w->last->next=w->last->prev;
  w->last->prev=NULL;
  l=w->first;
  w->first=w->last;
  w->last=l;
}
  
// returns 0 if the word is not a palindrom
// returns 1 if it is and returns it in palindrome form
// ie it starts with a letter of symmetry.
int word_palindrome(w)
     word *w;
{
  Pletter l1,l2,mark,mark2;
  int i,j;

  //fprintf(stderr,"word_palindrome: length %d\n",w->l);

  //Temorarily make the list cyclic
  w->last->next=w->first;
  w->first->prev=w->last;

  mark=w->first; // stores the begining of the best word so far
  for (i=0; i<w->l/2; i++){
    j=1;
    l1=mark->next;
    l2=mark->prev;
    while ((j<w->l/2)&&(l1->l==l2->l)){
      j++;
      l1=l1->next;
      l2=l2->prev;
    }
    if (l1->l==l2->l){ // found it
      mark2=l1;
      j=0;
      l1=mark;
      l2=mark2;
      while ((j<w->l/2)&&(l1->l==l2->l)){
	j++;
	l1=l1->next;
	l2=l2->next;
      }
      if (l2->l<l1->l)
	mark=mark2;
      w->first=mark;
      w->last=mark->prev;
      w->first->prev=w->last->next=NULL;
      //fprintf(stderr,"word_palindrome: This is a palindrome!\n");     
      return 1;
    }
    mark=mark->next;
  }
  w->first->prev=w->last->next=NULL;
  //fprintf(stderr,"word_palindrome: Not a palindrome :(\n");     
  return 0;
}


// This take a pword and turns it into its least lexigraphical
// conjugate/inverse.
// returns 1 if the word is a power of a shorter word
// returns 0 otherwise
int word_simplify(w)
     word *w;
{
  Pletter l,l2,lbest,mark;
  int dir, ret;

  //Temorarily make the list cyclic
  w->last->next=w->first;
  w->first->prev=w->last;

  ret=0;
  //w.last=w->last;  // permenantly stores the w.last position
  mark=w->first; // stores the begining of the best word so far
  dir=1;

  l=mark->next;    // this is what we will iterate
  while (l!=w->first){    
    l2=l;       // we will use l2 to compare to best word so far
    lbest=mark; // iterates through the best word so far
    if (l2->l<lbest->l){
      mark=l;
      dir=0;
    } else if (l2->l==lbest->l) {
      l2=l2->next;
      lbest=lbest->next;

      while ((l2->l==lbest->l)&&(l2!=l)) {
	l2=l2->next;
	lbest=lbest->next;
      }
      if (l2->l<lbest->l){
	mark=l;
	dir=0;
      } else if ((l2->l==lbest->l)&&(dir%2==0)){
	ret=1;
      }
    }    
    l=l->next;
    dir++;
  }
  
  // now mark points toward the start of the least 
  // lexi_ordered cyclic conjugate

  // so now we fix the word so that it starts here
  
  w->first=mark;
  w->last=mark->prev;

  // now we need to check words running in the opposite direction
  // this is even more of a pain

  dir=0;       //direction of best word. 
               // currently the best word moves forward,
               // if we find a better one, it will move backward
  mark=w->first; // stores the begining of the best word so far

  l=w->first;    // this is what we will iterate
  l2=NULL;
  while ((l!=w->first)||(l2==NULL)){    
    l2=l;       // we will use l2 to compare to best word so far
    lbest=mark; // iterates through the best word so far
    if (l2->l<lbest->l){
      mark=l;
      dir=1;
    }
    else if (l2->l==lbest->l) {
      l2=l2->prev;
      
      if (dir==0) 
	lbest=lbest->next;
      else
	lbest=lbest->prev;

      while ((l2->l==lbest->l)&&(l2!=l)) {
	l2=l2->prev;
	
	if (dir==0) 
	  lbest=lbest->next;
	else
	  lbest=lbest->prev;
      }

      if (l2->l<lbest->l){
	mark=l;
	dir=1;
      }
    }    
    l=l->next;
  }

  if (dir!=0){
    // then we found a better word
    // we fix up our word
    // w.first so mark is w.last
    w->last=mark;
    w->first=mark->next;
  }
  w->last->next=w->first->prev=NULL;
  if (dir!=0){
    word_reverse(w);
  }
  return ret;
}



/*
// sort a word list by word length
void pword_list_sort(l)
     pword_list *l;
{
  pword temp;
  int i,j;

  for (i=0; i<l->l-1; i++)
    for (j=i+1; j<l->l; j++)
      if (l->w[j].l < l->w[i].l){
	temp=l->w[i];
	l->w[i]=l->w[j];
	l->w[j]=temp;
	//pword_copy(&(l->w[i]),&temp);
	//pword_destroy(&(l->w[i]));
	//pword_copy(&(l->w[j]),&(l->w[i]));
	//pword_destroy(&(l->w[j]));
	//pword_copy(&temp,&(l->w[j]));
	//pword_destroy(&temp);
      }
}

//This function removes duplicate words from a 
// pword list which is ordered by length and
// for which each pword is put in a standard position
void pword_list_kill_duplicates(l)
     pword_list *l;
{
  int i,j,k;
  Pletter pli,plj;
  i=0;
  while (i<l->l){
    j=i+1;
    while ((j<l->l)&&(l->w[j].l==l->w[i].l)){
      pli=l->w[i].w.first;
      plj=l->w[j].w.first;
      while ((pli->l==plj->l) && (pli!=l->w[i].w.last)){
	pli=pli->next;
	plj=plj->next;
      }
      if ((pli==l->w[i].w.last)&&(pli->l==plj->l)){
	pword_destroy(&(l->w[j]));
	for (k=j+1; k<l->l; k++)
	  l->w[k-1]=l->w[k];
	l->l--;
      } else
	j++;
    }
    i++;
  }
}

// This function takes a pword list and organizes it
void pword_list_simplify(l)
     pword_list *l;
{
  int i;
  for (i=0;i<l->l;i++)
    if (pword_simplify(&(l->w[i]))==1){
      //l->w[i].w.first->l=-1;
      pword_destroy(&(l->w[i]));
      if (i!=l->l-1){
	l->w[i]=l->w[l->l-1];
	//pword_copy(&(l->w[l->l-1]),&(l->w[i]));
	//pword_destroy(&(l->w[l->l-1]));
      }
      l->l--;
      i--;
    }
  pword_list_sort(l);
  pword_list_kill_duplicates(l);
}
*/
