// This code uses the Multi Slalom search algorithm to 
// attempt to fill a region of the space of triangles with
// tiles.

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#define Pi 3.141592653589
#include "plist.c"

void write_rat_tile_data(file,w, z)
     FILE *file;
     word w;
     pcomplex z[2];
{
  fprintf(file,"BEGIN RAT_TILE\n");
  fprintf(file,"word\n");
  word_print_file(file,&w);
  fprintf(file,"end point\n");
  fprintf(file,"%.16f\n",z[0].x);
  fprintf(file,"%.16f\n",z[0].y);
  fprintf(file,"end point\n");
  fprintf(file,"%.16f\n",z[1].x);
  fprintf(file,"%.16f\n",z[1].y);
  fprintf(file,"color\n");
  fprintf(file,"aaa\n");
  fprintf(file,"END TILE\n");
  fflush(file);
}

int main(int argc, char *argv[]){
  FILE *file1, *fopen();
  int line[3], depth, rel[3];
  pcomplex end[2],z,tile_end[2],done[2];
  word w;
  int mesh;
  //triangle T;
  ptriangle PT;

  if (argc<=1){
    printf("Argument expected- \"print\"\n");
    exit(0);
  }
  if (strcmp(argv[1],"print")==0){
    printf("Writing to file \"rat_tile\"\n");
    file1=fopen("rat_tile","w");
    if (file1==NULL){
      printf("Error opening file for writing.");
      exit(0);
    }
    if (argc<=5){
      printf("More arguments expected- e.g. \"print 1 1 1 500\"\n");
      exit(0);
    }  
    line[0]=atoi(argv[2]);
    line[1]=atoi(argv[3]);
    line[2]=atoi(argv[4]);
    depth=atoi(argv[5]);
    mesh=50;
    if (depth<=1){
      printf("Error: depth of %d too small\n", depth);
      exit(0);
    }  

    rel[0]=-line[1];
    rel[1]=line[0];
    rel[2]=line[1]-line[0];
    rat_line_get_endpoints(line, &end);

    // print out the end points
    printf("Detected end points\nA: ");
    pcomplex_tri_print_file(stdout,end[0]);
    printf("B: ");
    pcomplex_tri_print_file(stdout,end[1]);

    // start at midpoint
    z.x=(end[0].x+end[1].x)/2;
    z.y=(end[0].y+end[1].y)/2;

    printf("First search at triangle ");
    pcomplex_tri_print_file(stdout,z);

    PT=ptriangle_make2(z);
    w=rat_fill_psearchwRel(PT,depth, rel);
    if (w.l!=0){
      printf("Tile found! Word is of length %d.\n",w.l);
      word_print_file(stdout,w);
    } else {
       printf("No tile found!!! Abort\n",w.l);
       exit(0);
    }
    rat_plot(z,line,w, mesh, &tile_end);
    write_rat_tile_data(file1,w, tile_end);
    //done[0]=tile_end;
    fclose(file1);
  }

}
