// Given a stable word, there is the corresponding 
// path in the Universal Abelian Cover
// UAC is a thickening of the hexagonal lattice
// This computes the winding numbers at each hexagon
// for the given word

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define Pi     3.141592653589
#define Root3  1.7320508

#include "pcomplex.c"
#include "triangle.c"
#include "pmatrix.c"

//#include "plist.c"

int main(argc, argv)
int argc;
char *argv[];
{
  int len;   // Length of word
  int *w;    // word
  int *grid; // grid for computing windy numbers

  int width,height;
  
  int i,j;
  int x,y,incr;
  int minx,miny,maxx,maxy;

  double r,s;
  double minr,maxr,mins,maxs;
  double temp, tempx, tempy;

  triangle T,T2;
  pcomplex z,z2;
  reflection R;
  matrix M;
  double ang, ang1, ang2;
  
  pcomplex sum;

  scanf("%lf",&(z.x)); // "x-coord" of triangle
  scanf("%lf",&(z.y)); // "x-coord" of triangle
  ang1=z.x*Pi;
  ang2=z.y*Pi;
  T=triangle_make(z);
  triangle_scale(&T, .45/triangle_radius(&T));
  triangle_recenter2(&T);
  reflect_from_triangle(T,&R);
  
  scanf("%d",&width);  // width of the screen
  scanf("%d",&height); // height of the screen
  scanf("%d",&len); // read the length of the word  
  w=(int *) malloc (len*sizeof (int));
  for (i=0; i< len; i++)
    scanf("%d",&(w[i])); // read the word

  // Fix the orientation of the starting triangle 
  M=R.m[w[0]-1];
  for (i=1; i< len; i++){
    timesEquals(&M,&(R.m[w[i]-1]));
  }
  // now M is the translation corresponding to the word.
  ang=atan2(M.m[1][2],M.m[0][2]); // rotation from the horizontal
  M.m[0][0]=M.m[1][1]=cos(ang);
  M.m[1][0]=-sin(ang);
  M.m[0][1]=sin(ang);
  M.m[0][2]=M.m[1][2]=0;
  for (i=0; i<3;i++)
    T.z[i]=eucTimes(&M,T.z[i]);

  reflect_from_triangle(T,&R);

  M=R.m[0];
  timesEquals(&M,&(R.m[1]));
  timesEquals(&M,&(R.m[2]));
  timesEquals(&M,&(R.m[0]));
  timesEquals(&M,&(R.m[1]));
  timesEquals(&M,&(R.m[2]));
  z.x=M.m[0][2];
  z.y=M.m[1][2];
  z=pcomplex_unit(z);
  
  incr=1;
  minx=maxx=x=0;
  miny=maxy=y=0;
  
  r=s=0;
  minr=maxr=0;
  mins=maxs=0;

  // On the first pass we find the bounds for our grid
  for (i=0; i< len; i++){
    switch(w[i]){
    case 2: 
      x+=incr;
      if (x<minx)
	minx=x;
      else if (x>maxx)
	maxx=x;

      r+=((double)incr)/2;
      s-=Root3*incr/2;
      break;
    case 1:
      y+=incr;
      if (y<miny)
	miny=y;
      else if (y>maxy)
	maxy=y;

      r+=((double)incr)/2;
      s+=Root3*incr/2;
      break;
    case 3:
      r-=incr;      
      break;      
    }

    if (r<minr)
	minr=r;
    else if (r>maxr)
	maxr=r;
    if (s<mins)
	mins=s;
    else if (s>maxs)
	maxs=s;
    incr=-incr;
  }
  minx++;
  miny++;
  maxx++;
  maxy++;

  minr-=.5;
  maxr+=.5;
  mins-=Root3/4;
  maxs+=Root3/4;

  // now all the points (x,y) with nonzero windy number 
  // are stored in the box minx<=x<maxx miny<=y<maxy

  //printf("min:%d %d\n",minx, miny);
  //printf("max:%d %d\n",maxx, maxy);

  if (height*(maxr-minr)<width*(maxs-mins)){
    temp=width*(maxs-mins)/height-(maxr-minr);
    maxr+=temp/2;
    minr-=temp/2;
  } else {
    temp=height*(maxr-minr)/width-(maxs-mins);
    maxs+=temp/2;
    mins-=temp/2;    
  }

  // create a (maxx-minx)*(maxy-miny) grid
  grid=(int *) malloc ((maxx-minx)*(maxy-miny)*sizeof (int));

  // clear the grid
  for (i=0; i<(maxx-minx)*(maxy-miny); i++)
    grid[i]=0;

  // the (a,b) point in the grid value is
  // stored as grid[(a-minx)*(maxy-miny)+(b-miny)]

  x=y=0;
  r=s=0;
  incr=1;

  // On the second pass we compute windy numbers
  // and print the coordinates
  for (i=0; i< len; i++){
    // Print coordinates for path
    printf("%lf\n",(r-minr)*width/(maxr-minr));
    printf("%lf\n",height-(s-mins)*height/(maxs-mins));

    // Print triangle's coordinates
    for (j=0; j<3; j++){ 
      printf("%lf\n",(T.z[j].x+r-minr)*width/(maxr-minr));
      printf("%lf\n",height-(T.z[j].y+s-mins)*height/(maxs-mins));
    }

    // manipulate triangle
    reflect_from_triangle(T,&R);
    T.z[w[i]-1]=eucTimes(&(R.m[w[i]-1]),T.z[w[i]-1]);
    triangle_recenter2(&T);

    switch(w[i]){
    case 2: 
      if (incr==1)
	x+=incr;
      for (j=y+1; j<maxy; j++)
	grid[(x-minx)*(maxy-miny)+(j-miny)]+=incr;
      for (j=y; j>=miny; j--)
	grid[(x-minx)*(maxy-miny)+(j-miny)]-=incr;      
      if (incr==-1)
	x+=incr;	
      r+=((double)incr)/2;
      s-=Root3*incr/2;
      break;
    case 1:
      y+=incr;
      r+=((double)incr)/2;
      s+=Root3*incr/2;
      break;
    case 3:
      r-=incr;      
      break;      
    }
    incr=-incr;
  }
  // the grid now stores 2*windy number of each hexagon
  
  printf("%d\n",(maxx-minx)*(maxy-miny));
  sum.x=sum.y=0;

  for (y=miny; y<maxy; y++)
    for (x=minx; x<maxx; x++){
      tempx=((double)(y+x))*3/2-2;
      tempy=((double)(y-x))*Root3/2;
      
      //tempx=-((double)x)*3/2+.5;    
      //tempy=-Root3*y-Root3*x/2+Root3/2;
      z2=pcomplex_rotate(z,-(x)*ang1+(y-1)*ang2);
/*       pcomplex_sum_equals(&sum, */
/* 			  &(pcomplex_times_double */
/* 			    (z2, */
/* 			     (double)grid[(x-minx)*(maxy-miny)+ */
/* 					  (y-miny)]/2))); */
      printf("%lf\n",(tempx-minr)*width/(maxr-minr));
      printf("%lf\n",height-(tempy-mins)*height/(maxs-mins));      
      
      printf("%lf\n",(tempx+z2.x/2-minr)*width/(maxr-minr));
      printf("%lf\n",height-(tempy+z2.y/2-mins)*height/(maxs-mins));      
      
      printf("%d\n",grid[(x-minx)*(maxy-miny)+(y-miny)]/2);
    }
  free(w);
  free(grid);
  return 0;
}
