/*
 * FileLoaderContainer.java
 *
 * Created on November 6, 2005, 9:10 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author  pat
 */
public class FileLoaderContainer extends Container {
    static final FileLoader FL=new FileLoader();
    
    static final double padding=2;
    static final Color
    FileListCanvas_buttonFg=Color.black,
    FileListCanvas_buttonBg=new Color(100,200,100),
    FileListCanvas_selectBg=new Color(255,255,100);
    
    Manager M;
    FileListCanvas FLC;
    FilePlotCanvas FPC;
    ChosenCanvas CC;
    
    boolean plotting;
    
    public class FileListCanvas extends DBCanvas
    implements MouseListener, MouseMotionListener {
        ListenString[] ls;
        ListenString doc;
        
        int selected;
        // translation to scroll by
        int ty, pressed_y;
        
        public FileListCanvas(){
            setBackground(new Color(0,125,0));
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            selected=-1;
            ty=0;
            pressed_y=0;
            doc=new ListenString("?",this);
            doc.setColors(FileListCanvas_buttonFg,FileListCanvas_buttonBg);
            doc.setTop(padding);
            
            ls=new ListenString[FL.file_names.length];
            double
            x=padding,
            y=padding;
            
            for (int i=0; i<ls.length; i++) {
                ls[i]=new ListenString(FL.file_names[i],this);
                ls[i].setLeft(x);
                ls[i].setTop(y);
                ls[i].setColors(FileListCanvas_buttonFg,FileListCanvas_buttonBg);
                y=ls[i].getBottom()+padding;
            }
            addMouseListener(this);
            addMouseMotionListener(this);
        }
        
        public String getName() {
            return FL.getName(selected);
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
            RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            
            doc.setRight(getWidth()-padding);
            doc.render(g);
            
            if (ls.length>0) {
                if (ty<-(ls[ls.length-1].getBottom()+
                padding-getHeight()))
                    ty=-(int)(ls[ls.length-1].getBottom()+
                    padding-getHeight());
            }
            if (ty>0)
                ty=0;
            
            //System.out.println("len="+ls.length);
            for (int i=0; i<ls.length; i++)
                ls[i].render(g,0,ty);
        }
        
        public void document(){
            M.setExplain("This popup allows you to load lists of tiles stored in memory. You can drag the green background to see more file choices. Select a file by clicking in a rectangle.");
        }
        
        public void mouseDragged(MouseEvent e) {
            if (!plotting) {
                if (e.getY()!=pressed_y) {
                    ty=ty+e.getY()-pressed_y;
                    pressed_y=e.getY();
                    repaint();
                }
            }
        }
        
        public void mouseMoved(MouseEvent e) {
        }
        
        public void mouseClicked(MouseEvent e) {
            if (!plotting) {
                if (doc.contains(e.getX(),e.getY()))
                    document();
                for (int i=0; i<ls.length;i++){
                    if (ls[i].contains(e.getX(),e.getY()-ty)) {
                        if (selected!=-1)
                            ls[selected].setColors(FileListCanvas_buttonFg,FileListCanvas_buttonBg);
                        selected=i;
                        ls[selected].setColors(FileListCanvas_buttonFg,FileListCanvas_selectBg);
                        showPlot();
                        repaint();
                    }
                }
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
            pressed_y=e.getY();
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
    }
    static final Color
    FilePlotCanvas_buttonFg=Color.black,
    FilePlotCanvas_buttonBg=new Color(255,200,100);
    
    public class FilePlotCanvas extends PlotCanvas {
        public FilePlotCanvas(Manager M){
            super(M);
        }
        
        public void run() {
            McbFile mf=new McbFile(FLC.getName());
            I=new Interrupter();
            for (ListIterator it=mf.tiles.listIterator();
            (it.hasNext())&&(! I.isInterrupted());) {
                McbTile T=(McbTile)(it.next());
                Tile st=types[i].plot(T.W,I);
                st.setColor(T.C);
                M.plotTile(st);
            }
            donePlot();
        }
    }
    
    
    public class ChosenCanvas extends DBCanvas
    implements MouseListener {
        
        
        ListenString doc,filename,load;
        
        public ChosenCanvas(){
            setBackground(new Color(200,100,0));
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            double x=padding,y=padding;
            
            doc=new ListenString("?", this);
            doc.setColors(FilePlotCanvas_buttonFg, FilePlotCanvas_buttonBg);
            doc.setTop(padding);
            doc.setLeft(padding);
            
            load=new ListenString("load", this);
            load.setTop(doc.getBottom()+padding);
            load.setLeft(padding);
            load.setColors(FilePlotCanvas_buttonFg, FilePlotCanvas_buttonBg);
            
            addMouseListener(this);
        }
        
        public void setSize(){
            setSize((int)(doc.getRight()+padding),(int)(load.getBottom()+padding));
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
            RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            
            doc.setRight(getWidth()-padding);
            filename=new ListenString(FLC.getName(),this);
            filename.setLeft(padding);
            filename.setTop(padding);
            filename.setColors(FileListCanvas_buttonFg,FileListCanvas_selectBg);
            
            filename.render(g);
            doc.render(g);
            load.render(g);
        }
        
        public void document(){
            M.setExplain("Select the type of plot, then click plot. If you wish to change which file to load, select from the green canvas above.");
        }
        
        public void mouseClicked(MouseEvent e) {
            if (doc.contains(e.getX(),e.getY())) {
                document();
                return;
            }
            if (load.contains(e.getX(),e.getY())){
                McbFile mf=new McbFile(FLC.getName());
                String[] list=new String[mf.tiles.size()];
                int i=0;
                for (ListIterator it=mf.tiles.listIterator();
                it.hasNext();i++) {
                    list[i]=((McbTile)(it.next())).W;
                }
                M.setBasicResults(new BasicSearchResults(list,null));
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
    }
    
    /** Creates a new instance of FileLoaderContainer */
    public FileLoaderContainer(Manager M) {
        this.M=M;
        
        setBackground(Color.black);
        setFont(new Font("sanserif", Font.PLAIN, 12));
        FLC=new FileListCanvas();
        
        FLC.setSize(150,200);
        
        setLayout(new BorderLayout());
        add(FLC,"Center");
    }
    
    public void showPlot() {
        if (FPC==null) {
            Container C=new Container();
            C.setLayout(new BorderLayout());
            
            CC=new ChosenCanvas();
            CC.setSize();
            C.add(CC,"North");
            
            FPC=new FilePlotCanvas(M);
            FPC.setSize();
            C.add(FPC,"South");
            
            add(C,"South");
            validate();
        } else {
            CC.repaint();
        }
    }
    
    
    
}
