/*
 * GridLoader.java
 *
 * Created on December 10, 2005, 4:18 PM
 */

import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.io.*;
import java.net.URL;

/**
 *
 * @author  pat
 */
public class GridLoader extends Container {
    public class FileTitle extends DBCanvas {
        ListenString ls;
        public FileTitle(){
            // Colors
            setBackground(new Color(0,100,0));
            // Buttons
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            ls=new ListenString(file_names[i],file_names, this);
            ls.setLeft(4); ls.setTop(4);
            ls.setColors(Color.black,Color.white);
            ls.showBorder=false;
            
            setSize((int)(ls.getRight()+5),(int)(ls.getBottom()+5));
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            ls.render(g);
        }
    }
    
    public class GridViewer extends DBCanvas {
        AffineTransform square;
        Color grid_color=Color.black;
        
        public GridViewer() {
            setSize(200,200);
            setBackground(Color.white);
        }
        
        /** Create the AffineTransform, square,
         * which sends the [0,1]x[0,1] square to the interior of canvas.
         * It adds a 5% border.
         */
        public void resetSquare(){
            
            // set transform to be the identity affine transform
            square=new AffineTransform();
            
            // Steps 1 & 2 take the [0,1]x[0,1] square to the window
            // by some euclidean transform
            // Steps 3 4 & 5 add a 5% border.
            
            // Step 5 translate 0,0 back to the center
            square.translate(getWidth()/2.0,getHeight()/2.0);
            
            // Step 4: scale by 90%
            square.scale(.9, .9);
            
            // Step 3 translate the center to the point 0,0
            square.translate(-getWidth()/2.0,-getHeight()/2.0);
            
            int size;
            if (getWidth()<getHeight())
                size=getWidth();
            else
                size=getHeight();
            
            // STEP 2:
            // translate the [0,w]x[0,h] box to the viewing area
            // [0,w]x[0,h].
            square.translate(0, // x component
            size+0); //  y component
            
            // STEP 1:
            // scale the [0,1]x[0,1] box to the width of the canvas
            // these function takes double values!
            square.scale(size, // scale in the x direction
            -size ); // scale in the y direction
            
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            if (square==null) {
                resetSquare();
            }

            g.setColor(grid_color);
            for (int j=0; j<2; j++) {
                for (int i=0; i<grids[j].lines.length; i++) {
                    if (grids[j].lines[i]!=null) {
                        g.draw(square.createTransformedShape(grids[j].lines[i]));
                    } else {
                        System.out.println("Warning null line");
                    }
                }
            }
            
        }
    }
    
    String[] file_names;
    RationalGrid[] grids;
    FileTitle FT;
    GridViewer GV;
    int i=0;
    
    /** Creates a new instance of GridLoader */
    public GridLoader() {
        LinkedList ll=new LinkedList();
        try {
            String thisLine;
            
            InputStream is = getClass().getResourceAsStream("/Files/Grids/");
            
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            if (((thisLine = br.readLine()) == null)) {
                // fall back on the file list
                is = getClass().getResourceAsStream("/Files/grid_files");
                br = new BufferedReader(new InputStreamReader(is));
                thisLine = br.readLine();
            }
            if (thisLine!=null)
                do {
                    //System.out.println(thisLine);
                    ll.add(thisLine);
                } while ((thisLine = br.readLine()) != null);
            else
                System.out.println("No Memory files found.");
        }
        catch (Exception e) {
            System.out.println("Error reading Memory files...");
            e.printStackTrace();
        }
        file_names=new String[ll.size()];
        int i=0;
        for (ListIterator it=ll.listIterator(); it.hasNext();i++){
            file_names[i]=(String)it.next();
            //System.out.println(file_names[i]);
        }
        
        setLayout(new BorderLayout());
        FT=new FileTitle();
        load(file_names[0]);
        GV=new GridViewer();
        
        add(FT,"North");
        add(GV,"Center");
    }
    
    
    public void load(String name) {
        grids=new RationalGrid[2];
        String[] terms;
        int num=0;
        try {
            String thisLine;
            InputStream is = getClass().getResourceAsStream("Files/Grids/"+name);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            
            for (int i=0; i<2; i++) {
                grids[i]=new RationalGrid();
                
                thisLine = br.readLine(); num++;
                terms=thisLine.split(" ");
                grids[i].zero=new RationalLine(
                Integer.parseInt(terms[0]),
                Integer.parseInt(terms[1]),
                Integer.parseInt(terms[2]));
                
                thisLine = br.readLine(); num++;
                terms=thisLine.split(" ");                
                grids[i].infinite=new RationalLine(
                Integer.parseInt(terms[0]),
                Integer.parseInt(terms[1]),
                Integer.parseInt(terms[2]));
                
                thisLine = br.readLine(); num++;
                terms=thisLine.split(" ");
                grids[i].start=Integer.parseInt(terms[0]);
                grids[i].end=Integer.parseInt(terms[1]);
                
                grids[i].computeLines();
            }
        } catch (Exception e) {
            System.out.println("Error reading from Files/Grids/"+name+
            ". Here is some debugging info:");
            System.out.println("Error occured when reading line "+num+" from file.");
            e.printStackTrace();
            grids=null;
        }
    }
}
