/*
 * GridLoader.java
 *
 * Created on December 10, 2005, 4:18 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;
import java.io.*;
import java.net.URL;

/**
 *
 * @author  pat
 */
public class GridManagerPopup extends Container {
    static final int padding=4;
    
    int mode=0;
    static final String[] MODES={"grid editor", "grid coordinates", "grid loader", "grid saver"};
    static final boolean[] ALLOWED_MODES={true,true,true,canSave()};
    
    static final Color bgColor=new Color(0,50,100);
    
    public class ModeCanvas extends DBCanvas implements MouseListener {
        ListenString[] modeLS=new ListenString[2];
        
        public ModeCanvas() {
            setFont(new Font("sanserif", Font.PLAIN, 12));
            setBackground(bgColor);
            
            modeLS[0]=new ListenString("mode:",this);
            modeLS[0].setLeft(padding); modeLS[0].setTop(padding);
            modeLS[0].setColors(Color.white,bgColor);
            modeLS[0].showBorder=false;
            
            modeLS[1]=new ListenString(MODES[mode],MODES,this);
            modeLS[1].setLeft(modeLS[0].getRight()+padding); modeLS[1].setTop(padding);
            modeLS[1].setColors(Color.black, Color.yellow);
            
            setSize((int)(modeLS[1].getRight()+5),(int)(modeLS[1].getBottom()+5));
            addMouseListener(this);
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            modeLS[0].render(g);
            modeLS[1].render(g);
        }
        
        public void mouseClicked(MouseEvent e) {
            if (modeLS[1].contains(e.getX(),e.getY())) {
                restructure();
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
    }
    
    public class GridSaver extends DBCanvas
    implements MouseListener, FocusListener, KeyListener {
        boolean selected=false;
        ListenString[] LS=new ListenString[3];
        
        public GridSaver() {
            setFont(new Font("sanserif", Font.PLAIN, 12));
            setBackground(bgColor);
            LS[0]=new ListenString("filename:", this);
            LS[0].showBorder=false;
            LS[1]=new ListenString("MMMMMMMMMMMM", this);
            LS[2]=new ListenString("save", this);
            double x=padding, y=padding;
            for (int i=0; i<LS.length; i++) {
                LS[i].setColors(Color.white,bgColor);
                LS[i].setLeft(x);
                LS[i].setTop(y);
                y=LS[i].getBottom()+padding;
                if (i==1) {
                    y+=2*padding;
                }
            }
            LS[1].str="filename";
            LS[2].setColors(Color.white,Color.blue);
            addMouseListener(this);
            addFocusListener(this);
            addKeyListener(this);
        }
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            for (int i=0; i<LS.length; i++) {
                LS[i].render(g);
            }
        }
        
        public void selectColors() {
            if (! selected) {
                LS[1].setColors(Color.white,bgColor);
            } else {
                LS[1].setColors(Color.black,Color.white);
            }
        }
        
        private void save() {
            if (LS[1].str.length()!=0) {
                try {
                    PrintWriter out
                    = new PrintWriter(new BufferedWriter(
                    new FileWriter("Files/Grids/"+LS[1].str)));
                    for (int i=0; i<2; i++) {
                        M.GM.grids[i].save(out);
                    }
                    out.close();
                    /** update the file list */
                    Process P=Runtime.getRuntime().exec("Files/java_update");
                    P.waitFor();
                } catch (Throwable t) {
                    System.out.println("Error saving grid file");
                    t.printStackTrace();
                }
                
            }
        }
        
        public void mouseClicked(MouseEvent e) {
            if (LS[1].contains(e.getX(), e.getY())) {
                selected=!selected;
                selectColors();
                repaint();
                return;
            }
            if (LS[2].contains(e.getX(), e.getY())) {
                save();
            }
            if (selected) {
                selected=!selected;
                selectColors();
                repaint();
                return;
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
        public void keyPressed(java.awt.event.KeyEvent keyEvent) {
        }
        
        public void keyReleased(java.awt.event.KeyEvent keyEvent) {
        }
        
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar()==KeyEvent.VK_TAB) {
                if (!selected) {
                    selected=true;
                    selectColors();
                    repaint();
                }
                return;
            }
            if (selected) {
                String temp=TextProcess.Filename(LS[1].str, e);
                if (temp.length()>12) {
                    temp=temp.substring(0,12);
                }
                if (! LS[1].str.equals(temp)) {
                    LS[1].str=temp;
                    repaint();
                    return;
                }
            }
            
        }
        
        public void focusGained(java.awt.event.FocusEvent focusEvent) {
        }
        
        public void focusLost(java.awt.event.FocusEvent focusEvent) {
            if (selected) {
                selected=false;
                selectColors();
                repaint();
                return;
            }
        }
    }
    
    public static Color[] LINE_COLORS={Color.red,new Color(200,100,0), Color.blue, new Color(0,150,0)};
    
    public static String[] INDICES={"\"horizontal\"","\"vertical\""};
    
    public class GridEditor extends Container implements ParameterSpaceRenderer {
        
        int index=0;
        
        public class IndexSelector extends DBCanvas
        implements MouseListener, KeyListener, FocusListener {
            ListenString[] indexLS=new ListenString[2];
            ListenString grab[]=new ListenString[2];
            ListenString send[]=new ListenString[2];
            ListenString neg[]=new ListenString[2];
            ListenString eq[]=new ListenString[2];
            ListenString forLS[]=new ListenString[4];
            ListenString drawLS[]=new ListenString[5];
            ListenString selectedLS[]=new ListenString[4];
            int selected=-1;
            
            public IndexSelector() {
                setFont(new Font("sanserif", Font.PLAIN, 12));
                setBackground(bgColor);
                
                indexLS[0]=new ListenString("lines:",this);
                indexLS[0].setLeft(padding); indexLS[0].setTop(padding);
                indexLS[0].setColors(Color.white,bgColor);
                indexLS[0].showBorder=false;
                
                indexLS[1]=new ListenString(INDICES[mode],INDICES,this);
                indexLS[1].setLeft(indexLS[0].getRight()+padding); indexLS[1].setTop(padding);
                indexLS[1].setColors(Color.black, Color.yellow);
                
                double x=padding, y=indexLS[0].getBottom()+3*padding;
                for (int i=0; i<2; i++) {
                    grab[i]=new ListenString("grab",this);
                    grab[i].setLeft(x); grab[i].setTop(y);
                    x=grab[i].getRight()+padding;
                    
                    send[i]=new ListenString("send",this);
                    send[i].setLeft(x); send[i].setTop(y);
                    x=send[i].getRight()+padding;
                    
                    neg[i]=new ListenString("negate",this);
                    neg[i].setLeft(x); neg[i].setTop(y);
                    x=neg[i].getRight()+padding;
                    
                    x=padding;
                    y=send[i].getBottom()+padding;
                    eq[i]=new ListenString(M.GM.grids[index].getParams(i).toStringEquation(),this);
                    eq[i].setLeft(x); eq[i].setTop(y);
                    x=padding;
                    y=eq[i].getBottom()+3*padding;
                }
                
                forLS[0]=new ListenString("for i=",this);
                forLS[0].showBorder=false;
                forLS[1]=new ListenString("start",this);
                forLS[2]=new ListenString(" to ",this);
                forLS[2].showBorder=false;
                forLS[3]=new ListenString("end",this);
                for (int i=0; i<forLS.length; i++) {
                    forLS[i].setTop(y);
                    forLS[i].setColors(Color.white,bgColor);
                }
                y=forLS[0].getBottom()+padding;
                
                drawLS[0]=new ListenString("draw: i*",this);
                drawLS[1]=new ListenString("999",this);
                drawLS[2]=new ListenString("*B+",this);
                drawLS[3]=new ListenString("999",this);
                drawLS[4]=new ListenString("*A=0",this);
                drawLS[0].showBorder=false;
                drawLS[2].showBorder=false;
                drawLS[4].showBorder=false;
                x=padding;
                for (int i=0; i<drawLS.length; i++) {
                    drawLS[i].setTop(y);
                    drawLS[i].setColors(Color.white,bgColor);
                    drawLS[i].setLeft(x+1);
                    x=drawLS[i].getRight();
                }
                
                
                selectedLS[0]=forLS[1];
                selectedLS[1]=forLS[3];
                selectedLS[2]=drawLS[1];
                selectedLS[3]=drawLS[3];
                
                indexChanged();
                
                setSize((int)(drawLS[4].getRight()+5),(int)(drawLS[0].getBottom()+5));
                addMouseListener(this);
                addKeyListener(this);
                addFocusListener(this);
            }
            
            public void setSelectedColors() {
                for (int i=0; i<selectedLS.length; i++) {
                    selectedLS[i].setColors(Color.white,bgColor);
                }
                if (selected!=-1)
                    selectedLS[selected].setColors(Color.black, Color.white);
            }
            
            public void indexChanged(){
                indexLS[1].str=INDICES[index];
                for (int i=0; i<2; i++) {
                    grab[i].setColors(Color.white,LINE_COLORS[2*index+i]);
                    send[i].setColors(Color.white,LINE_COLORS[2*index+i]);
                    neg[i].setColors(Color.white,LINE_COLORS[2*index+i]);
                    eq[i].setColors(Color.white,LINE_COLORS[2*index+i]);
                }
                if (index==0) {
                    drawLS[2].str="*B+";
                    drawLS[4].str="*A=0";
                } else {
                    drawLS[2].str="*D+";
                    drawLS[4].str="*C=0";
                }
                
                M.spaceChanged();
            }
            
            public void paint(Graphics gfx) {
                Graphics2D g=(Graphics2D) gfx;
                
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
                
                for (int i=0; i<2; i++) {
                    indexLS[i].render(g);
                    grab[i].render(g);
                    send[i].render(g);
                    neg[i].render(g);
                    eq[i].str=""+((char)('A'+2*index+i))+"="+
                    M.GM.grids[index].getParams(i).toStringFunction();
                    eq[i].size();
                    eq[i].render(g);
                }
                
                forLS[1].str=""+M.GM.grids[index].start;
                forLS[3].str=""+M.GM.grids[index].end;
                forLS[1].size();
                forLS[3].size();
                double x=padding-1;
                for (int i=0; i<forLS.length; i++) {
                    forLS[i].setLeft(x+1);
                    forLS[i].makeIntegral();
                    forLS[i].render(g);
                    x=forLS[i].getRight();
                }
                drawLS[1].str=""+M.GM.grids[index].q;
                drawLS[3].str=""+M.GM.grids[index].p;
                drawLS[1].size();
                drawLS[3].size();
                x=padding-1;
                for (int i=0; i<drawLS.length; i++) {
                    drawLS[i].setLeft(x+1);
                    drawLS[i].makeIntegral();
                    drawLS[i].render(g);
                    x=drawLS[i].getRight();
                }
            }
            
            public void mouseClicked(MouseEvent e) {
                if (indexLS[1].contains(e.getX(),e.getY())) {
                    reindex();
                }
                for (int i=0; i<2; i++) {
                    if (grab[i].contains(e.getX(),e.getY())) {
                        RationalLine L=M.getRationalLine();
                        if (L!=null) {
                            if (i==0) {
                                M.GM.grids[index].zero=new RationalLine(L);
                            } else {
                                M.GM.grids[index].infinite=new RationalLine(L);
                            }
                            M.GM.grids[index].computeLines();
                            M.spaceChanged();
                            repaint();
                            return;
                        }
                    }
                    if (send[i].contains(e.getX(),e.getY())) {
                        M.setRationalLine(M.GM.grids[index].getParams(i));
                        repaint();
                        return;
                    }
                    if (neg[i].contains(e.getX(),e.getY())) {
                        M.GM.grids[index].getParams(i).neg();
                        M.GM.grids[index].computeLines();
                        M.spaceChanged();
                        repaint();
                        return;
                    }
                }
                for (int i=0; i<selectedLS.length; i++) {
                    if (selectedLS[i].contains(e.getX(),e.getY())) {
                        if (selected==i) {
                            selected=-1;
                        } else {
                            selected=i;
                        }
                        setSelectedColors();
                        repaint();
                        return;
                    }
                }
                if (selected!=-1) {
                    selected=-1;
                    setSelectedColors();
                    repaint();
                    return;
                }
            }
            
            public void mouseEntered(MouseEvent e) {
            }
            
            public void mouseExited(MouseEvent e) {
            }
            
            public void mousePressed(MouseEvent e) {
            }
            
            public void mouseReleased(MouseEvent e) {
            }
            
            public void keyPressed(java.awt.event.KeyEvent keyEvent) {
            }
            
            public void keyReleased(java.awt.event.KeyEvent keyEvent) {
            }
            
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar()==KeyEvent.VK_TAB) {
                    selected=(selected+1)%selectedLS.length;
                    setSelectedColors();
                    repaint();
                    return;
                }
                if (selected>-1) {
                    if (e.getKeyChar()==KeyEvent.VK_ENTER) {
                        selected=-1;
                        setSelectedColors();
                        repaint();
                        return;
                    }
                    
                    int x=0;
                    switch (selected) {
                        case 0:
                            x=M.GM.grids[index].start;
                            break;
                        case 1:
                            x=M.GM.grids[index].end;
                            break;
                        case 2:
                            x=M.GM.grids[index].q;
                            break;
                        case 3:
                            x=M.GM.grids[index].p;
                            break;
                    }
                    int temp;
                    if (selected<2)
                        temp=TextProcess.Integer(x,e);
                    else
                        temp=TextProcess.NonnegativeInteger(x,e);
                    if (temp>=1000)
                        temp= 999;
                    if (temp<=-1000)
                        temp= -999;
                    
                    if (x==temp)
                        return;
                    
                    switch (selected) {
                        case 0:
                            M.GM.grids[index].start=temp;
                            break;
                        case 1:
                            M.GM.grids[index].end=temp;
                            break;
                        case 2:
                            M.GM.grids[index].q=temp;
                            break;
                        case 3:
                            M.GM.grids[index].p=temp;
                            break;
                    }
                    M.GM.grids[index].computeLines();
                    M.spaceChanged();
                    repaint();
                    return;
                }
                
            }
            
            public void focusGained(java.awt.event.FocusEvent focusEvent) {
            }
            
            public void focusLost(java.awt.event.FocusEvent focusEvent) {
                if (selected!=-1) {
                    selected=-1;
                    setSelectedColors();
                    repaint();
                    return;
                }
            }
            
        }
        
        IndexSelector IS=new IndexSelector();
        
        public GridEditor(){
            IS=new IndexSelector();
            
            setLayout(new BorderLayout());
            
            add(IS,"Center");
            M.addRendererTop(this);
            M.spaceChanged();
        }
        
        public void reindex() {
            index=(index+1)%INDICES.length;
            IS.indexChanged();
            IS.repaint();
        }
        
        public void render(Graphics2D g, AffineTransform T) {
            //System.out.println("rendering");
            Stroke s=g.getStroke();
            g.setStroke(new BasicStroke(3));
            for (int i=0; i<2; i++) {
                
                RationalLine L=M.GM.grids[index].getParams(i);
                if (L!=null) {
                    Line2D.Double l=L.toLineSegment();
                    if (l!=null) {
                        g.setColor(LINE_COLORS[2*index+i]);
                        g.draw(T.createTransformedShape(l));
                    } else {
                        System.err.println("Warning attempted to render invalid line");
                    }
                }
                
            }
            g.setStroke(s);
        }
    }
    
    public class GridLoader extends Container {
        public class FileList extends StringListCanvas {
            FileList() {
                setColors(bgColor, new Color(100,100,255), Color.yellow, Color.black);
                
                LinkedList ll=new LinkedList();
                try {
                    String thisLine;
                    
                    InputStream is = getClass().getResourceAsStream("/Files/Grids/");
                    
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    if (((thisLine = br.readLine()) == null)) {
                        // fall back on the file list
                        is = getClass().getResourceAsStream("/Files/grid_files");
                        br = new BufferedReader(new InputStreamReader(is));
                        thisLine = br.readLine();
                    }
                    if (thisLine!=null)
                        do {
                            //System.out.println(thisLine);
                            ll.add(thisLine);
                        } while ((thisLine = br.readLine()) != null);
                    else
                        System.out.println("No Grid files found.");
                }
                catch (Exception e) {
                    System.out.println("Error reading Grid files...");
                    e.printStackTrace();
                }
                String[] file_names=new String[ll.size()];
                int i=0;
                for (ListIterator it=ll.listIterator(); it.hasNext();i++){
                    file_names[i]=(String)it.next();
                }
                setNames(file_names);
            }
            
            public void deselect(){}
            public void select(String str){
                if (LS[1].str.length()!=0) {
                    try {
                        InputStream is = getClass().getResourceAsStream("Files/Grids/"+str);
                        BufferedReader br = new BufferedReader(
                        new InputStreamReader(is));
                        M.GM.grids[0]=RationalGrid.load(br);
                        M.GM.grids[1]=RationalGrid.load(br);
                        br.close();
                        M.spaceChanged();
                    } catch (Throwable t) {
                        System.out.println("Error saving grid file");
                        t.printStackTrace();
                    }
                    
                }
            }
        }
        
        FileList FL;
        
        public GridLoader() {
            setLayout(new BorderLayout());
            FL=new FileList();
            add(FL,"Center");
        }
        
    }
    
    public class GridCoordinates extends DBCanvas
    implements HearingParameter, MouseListener, FocusListener, KeyListener {
        ListenString[] LS, selectLS;
        
        int[] a=new int[2];
        double[] b=new double[2];
        String[] bS=new String[2];
        int selected=-1;
        Complex Z;
        int padding=4;
        
        public GridCoordinates() {
            setFont(new Font("sanserif", Font.PLAIN, 12));
            setBackground(bgColor);
            LS=new ListenString[12];
            double x=padding,y=3*padding;
            for (int i=0; i<2; i++) {
                x=padding;
                LS[3*i]=new ListenString("999",this);
                LS[3*i].setTop(y);
                LS[3*i].setLeft(padding);
                LS[3*i+1]=new ListenString("+",this);
                LS[3*i+1].showBorder=false;
                LS[3*i+1].setTop(y);
                LS[3*i+2]=new ListenString(".2345523",this);
                LS[3*i+2].setTop(y);
                y=LS[3*i].getBottom()+padding;
                x=padding;
                LS[6+3*i]=new ListenString("negate",this);
                LS[6+3*i].setLeft(x);
                LS[6+3*i].setTop(y);
                x=padding+LS[6+3*i].getRight();
                LS[6+3*i+1]=new ListenString("+1",this);
                LS[6+3*i+1].setLeft(x);
                LS[6+3*i+1].setTop(y);
                x=padding+LS[6+3*i+1].getRight();
                LS[6+3*i+2]=new ListenString("-1",this);
                LS[6+3*i+2].setLeft(x);
                LS[6+3*i+2].setTop(y);
                y=LS[6+3*i+2].getBottom()+3*padding;
            }
            for (int i=0; i<6; i++) {
                LS[i].setColors(Color.white,bgColor);
            }
            for (int i=6; i<12; i++) {
                LS[i].setColors(Color.white,new Color(0,100,70));
            }
            selectLS=new ListenString[4];
            selectLS[0]=LS[0];
            selectLS[1]=LS[2];
            selectLS[2]=LS[3];
            selectLS[3]=LS[5];
            
            addMouseListener(this);
            addKeyListener(this);
            addFocusListener(this);
            Z=M.getZ();
            zChanged();
            M.hearParameter(this);
        }
        
        public void zChanged() {
            for (int i=0; i<2; i++) {
                double x=M.GM.grids[1-i].getI(Z);
                a[i]=(int)(Math.floor(x));
                LS[3*i+0].str=""+a[i];
                b[i]=(x-a[i]);
                b[i]=(Math.round(b[i]*100000000))/100000000.0;
                LS[3*i+2].str=bS[i]=""+b[i];
                LS[3*i+0].size();
                LS[3*i+2].size();
                LS[3*i+1].setLeft(LS[3*i].getRight()+1);
                LS[3*i+2].setLeft(LS[3*i+1].getRight()+1);
            }
            repaint();
        }
        
        public void zChanged2() {
            for (int i=0; i<2; i++) {
                LS[3*i+0].str=""+a[i];
                LS[3*i+2].str=bS[i];
                LS[3*i+0].size();
                LS[3*i+2].size();
                LS[3*i+1].setLeft(LS[3*i].getRight()+1);
                LS[3*i+2].setLeft(LS[3*i+1].getRight()+1);
            }
            repaint();
        }
        
        public void cleanup(){
            M.remove(this);
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            for (int i=0; i<LS.length; i++) {
                LS[i].render(g);
            }
        }
        
        public void select(int i){
            if (selected!=-1)
                deselect();
            selectLS[i].setColors(Color.black,Color.yellow);
            selected=i;
        }
        
        public void deselect(){
            selectLS[selected].setColors(Color.white,bgColor);
            selected=-1;
        }
        
        public void parameterChanged() {
            if (! M.getZ().equals(Z)){
                Z=new Complex(M.getZ());
                zChanged();
            }
        }
        public void mouseClicked(MouseEvent e) {
            for (int i=0; i<selectLS.length; i++) {
                if (selectLS[i].contains(e)) {
                    if (selected==i)
                        deselect();
                    else
                        select(i);
                    repaint();
                    return;
                }
            }
            for (int i=0; i<2; i++) {
                if (LS[6+3*i].contains(e)) {
                    if (i==0) {
                        set(-(a[0]+b[0]),a[1]+b[1]);
                    } else {
                        set(a[0]+b[0],-(a[1]+b[1]));
                    }
                }
                if (LS[6+3*i+1].contains(e)) {
                    a[i]=a[i]+1;
                    set2();
                }
                if (LS[6+3*i+2].contains(e)) {
                    a[i]=a[i]-1;
                    set2();
                }
            }
            if (selected!=-1) {
                deselect();
                repaint();
                return;
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
        public void keyPressed(java.awt.event.KeyEvent keyEvent) {
        }
        
        public void keyReleased(java.awt.event.KeyEvent keyEvent) {
        }
        
        public void set2() {
            double[] A=M.GM.grids[1].getLine(a[0]+b[0]),
            B=M.GM.grids[0].getLine(a[1]+b[1]),
            C=NumberTheory.cross(A,B);
            Z=new Complex(2*C[0]/(C[0]+C[1]+C[2]), 2*C[1]/(C[0]+C[1]+C[2]));
            //Z.print();
            if ((Z.x>=0) && (Z.x<=1) && (Z.y>=0) && (Z.y<=1)) {
                M.setParameter(2*C[0]/(C[0]+C[1]+C[2]), 2*C[1]/(C[0]+C[1]+C[2]));
            }
            zChanged2();
        }
        
        public void set(double r, double s) {
            double[] A=M.GM.grids[1].getLine(r),
            B=M.GM.grids[0].getLine(s),
            C=NumberTheory.cross(A,B);
            Z=new Complex(2*C[0]/(C[0]+C[1]+C[2]), 2*C[1]/(C[0]+C[1]+C[2]));
            //Z.print();
            if ((Z.x>=0) && (Z.x<=1) && (Z.y>=0) && (Z.y<=1)) {
                M.setParameter(2*C[0]/(C[0]+C[1]+C[2]), 2*C[1]/(C[0]+C[1]+C[2]));
            }
            zChanged();
        }
        
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar()==KeyEvent.VK_TAB) {
                select((selected+1)%selectLS.length);
                repaint();
                return;
            }
            if (selected>-1) {
                if (e.getKeyChar()==KeyEvent.VK_ENTER) {
                    deselect();
                    repaint();
                    return;
                }
                switch (selected) {
                    case 0:
                        a[0]=TextProcess.Integer(a[0],e);
                        set2();
                        return;
                    case 1:
                        bS[0]=TextProcess.Interval(bS[0],e);
                        if (bS[0].length()>10)
                            bS[0]=bS[0].substring(0,10);
                        b[0]=Double.parseDouble(bS[0]);
                        set2();
                        return;
                    case 2:
                        a[1]=TextProcess.Integer(a[1],e);
                        set2();
                        return;
                    case 3:
                        bS[1]=TextProcess.Interval(bS[1],e);
                        if (bS[1].length()>10)
                            bS[1]=bS[1].substring(0,10);
                        b[1]=Double.parseDouble(bS[1]);
                        set2();
                        return;
                }
                
                //
                //                int x=0;
                //                switch (selected) {
                //                    case 0:
                //                        x=M.GM.grids[index].start;
                //                        break;
                //                    case 1:
                //                        x=M.GM.grids[index].end;
                //                        break;
                //                    case 2:
                //                        x=M.GM.grids[index].q;
                //                        break;
                //                    case 3:
                //                        x=M.GM.grids[index].p;
                //                        break;
                //                }
                //                int temp;
                //                if (selected<2)
                //                    temp=TextProcess.Integer(x,e);
                //                else
                //                    temp=TextProcess.NonnegativeInteger(x,e);
                //                if (temp>=1000)
                //                    temp= 999;
                //                if (temp<=-1000)
                //                    temp= -999;
                //
                //                if (x==temp)
                //                    return;
                //
                //                switch (selected) {
                //                    case 0:
                //                        M.GM.grids[index].start=temp;
                //                        break;
                //                    case 1:
                //                        M.GM.grids[index].end=temp;
                //                        break;
                //                    case 2:
                //                        M.GM.grids[index].q=temp;
                //                        break;
                //                    case 3:
                //                        M.GM.grids[index].p=temp;
                //                        break;
                //                }
                //                M.GM.grids[index].computeLines();
                //                M.spaceChanged();
                //                repaint();
                //                return;
            }
            
        }
        
        public void focusGained(java.awt.event.FocusEvent focusEvent) {
        }
        
        public void focusLost(java.awt.event.FocusEvent focusEvent) {
            if (selected!=-1) {
                deselect();
                repaint();
                return;
            }
        }
        
    }
    
    
    RationalGrid[] grids;
    ModeCanvas MC;
    GridCoordinates GC;
    GridEditor GE;
    GridSaver GS;
    GridLoader GL;
    Manager M;
    
    public GridManagerPopup(Manager M) {
        setBackground(bgColor);
        this.M=M;
        setLayout(new BorderLayout());
        MC=new ModeCanvas();
        add(MC,"North");
        setup();
    }
    
    public void destroy() {
        switch (mode) {
            case 0:
                M.remove(GE);
                M.PSM.showBorder=true;
                M.spaceChanged();
                this.remove(GE);
                GE=null;
                break;
            case 1:
                GC.cleanup();
                this.remove(GC);
                GC=null;
                break;
            case 2:
                this.remove(GL);
                GL=null;
                break;
            case 3:
                this.remove(GS);
                GS=null;
                break;
        }
    }
    
    public void cleanup(){
        destroy();
    }
    
    public void setup(){
        switch (mode) {
            case 0: // editor
                M.PSM.showBorder=false;
                GE=new GridEditor();
                M.PSM.raise("LineSelector");
                add(GE,"Center");
                break;
            case 1: // coordinates
                GC=new GridCoordinates();
                add(GC,"Center");
                break;
            case 2: // saver
                GL=new GridLoader();
                add(GL,"Center");
                break;
            case 3: // saver
                GS=new GridSaver();
                add(GS,"Center");
                break;
        }
        validate();
    }
    
    public void restructure(){
        destroy();
        mode=(mode+1)%MODES.length;
        while(! ALLOWED_MODES[mode]) {
            mode=(mode+1)%MODES.length;
        }
        MC.modeLS[1].str=MODES[mode];
        setup();
        MC.repaint();
    }
    
    public static boolean canSave(){
        SecurityManager SM=System.getSecurityManager();
        if (SM==null) {
            //System.out.println("No SecurityManager Present!");
            return true;
        }
        return false;
    }
    
}