public class HexPosition {
    public int p[];
    
    /** Initialize to the origin */
    public HexPosition(){
        p=new int[3];
        p[0]=p[1]=p[2]=0;
    }

     public HexPosition(HexPosition hp){
        p=new int[3];
        p[0]=hp.p[0];
        p[1]=hp.p[1];
        p[2]=hp.p[2];
     }
    
    /** Return true if the vertex represented is even.
     * <br>The vertices of the hexagonal grid can be colored black and
     * white, so no two adjacent vertices are the same color.
     * Even vertices are those that are the same color as the origin.
     */
    public boolean even(){
        return (p[0]+p[1]+p[2])%2==0;
    }
    
    /** Move the vertex along the edge marked by i (i=0,1,2)*/
    public void shift(int i){
        if (even())
            p[i]++;
        else
            p[i]--;
    }
    
    /** Compute the path distance to the origin*/
    public int dist(){
        int ret=0;
        if  (p[0]>=0)
            ret+=p[0];
        else
            ret-=p[0];
        if  (p[1]>=0)
            ret+=p[1];
        else
            ret-=p[1];
        if  (p[2]>=0)
            ret+=p[2];
        else
            ret-=p[2];
        return ret;
    }
    
    public String toString(){
        return "("+p[0]+", "+p[1]+", "+p[2]+")";
    } 
}
