/*
 * LineSelectorCanvas.java
 *
 * Created on December 10, 2005, 10:24 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.BoxLayout;

/**
 *
 * @author  pat
 */
public class LineSelector_1 extends Container implements ParameterSpaceRenderer {
    static final int padding=4;
    
    // Colors
    static final Color
    buttonBg=new Color(127,204,255),
    buttonFg=Color.black,
    selectedBg=Color.white,
    selectedFg=Color.black,
    modeBg=new Color(255,255,128),
    optionBg=new Color(255,200,128);
    
    private static Color[] grab_color={Color.red, Color.orange};
    
    private class GrabCanvas extends DBCanvas implements MouseListener {
        ListenString[] grabLS=new ListenString[2];
        
        public GrabCanvas(){
            setBackground(optionBg);
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            double x=padding,y=padding;
            grabLS[0]=new ListenString("(999/999, 999/999)", this);
            grabLS[0].setLeft(x); grabLS[0].setTop(y);
            grabLS[0].setColors(buttonFg,grab_color[0]);
            
            y=grabLS[0].getBottom()+padding;
            grabLS[1]=new ListenString("(999/999, 999/999)", this);
            grabLS[1].setLeft(x); grabLS[1].setTop(y);
            grabLS[1].setColors(buttonFg,grab_color[1]);
            
            addMouseListener(this);
            setSize();
            setGrab(0);
            setGrab(1);
        }
        
        public void setGrab(int i) {
            if (grab[i]!=null) {
                grabLS[i].str=grab[i].toMcbString();
            } else {
                grabLS[i].str="null";
            }
        }
        
        public void grab(int i) {
            grab[i]=M.getRationalTriangle();
            setGrab(i);
            if ((grab[0]!=null) && (grab[1]!=null)) {
                L=new RationalLine(grab[0], grab[1]);
                updateLine();
            }
            repaintAll();
        }
        
        public void setSize(){
            int x=0,y=0,temp;
            for (int i=0; i<grabLS.length; i++){
                temp=(int)(grabLS[i].getRight());
                if (temp>x)
                    x=temp;
                temp=(int)(grabLS[i].getBottom());
                if (temp>y)
                    y=temp;
            }
            //temp=(int)(doc.getRight());
            //if (temp>x)
            //    x=temp;
            setSize(x+padding,y+padding);
        }
        
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            for (int i=0; i<grabLS.length; i++) {
                grabLS[i].render(g);
            }
            
            //Dimension D=this.getSize();
            //g.setColor(new Color(100,255,100));
            //g.drawRect(0,0,D.width-1,D.height-1);
        }
        
        public void mouseClicked(MouseEvent e) {
            for (int i=0; i<grabLS.length; i++) {
                if (grabLS[i].contains(e.getX(),e.getY())){
                    grab(i);
                }
            }
        }
        
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
    }
    
    private class Equation1Canvas extends DBCanvas
    implements MouseListener, FocusListener, KeyListener {
        ListenString[] eq=new ListenString[6];
        
        int selected=-1;
        
        public Equation1Canvas() {
            setBackground(optionBg);
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            eq[0]=new ListenString("a", this);
            eq[0].setLeft(4);
            eq[1]=new ListenString("x+", this);
            eq[2]=new ListenString("b", this);
            eq[3]=new ListenString("y+", this);
            eq[4]=new ListenString("c", this);
            eq[5]=new ListenString("z=0", this);
            
            eq[1].showBorder=false;
            eq[3].showBorder=false;
            eq[5].showBorder=false;
            
            for (int i=0; i<eq.length; i++) {
                eq[i].setTop(4);
                eq[i].setColors(Color.black,Color.white);
            }
            
            setSize(200,(int)(eq[0].getBottom())+4);
            addMouseListener(this);
            addFocusListener(this);
            addKeyListener(this);
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            eq[0].str=Integer.toString(L.x[0]);
            eq[0].size();
            eq[2].str=Integer.toString(L.x[1]);
            eq[2].size();
            eq[4].str=Integer.toString(L.x[2]);
            eq[4].size();
            
            eq[0].render(g);
            for (int i=1; i<eq.length; i++) {
                eq[i].setLeft(eq[i-1].getRight()+1);
                eq[i].render(g);
            }
            
            //Dimension D=this.getSize();
            //g.setColor(new Color(100,255,100));
            //g.drawRect(0,0,D.width-1,D.height-1);
        }
        
        public void deselect(){
            E1C.eq[E1C.selected].setColors(Color.black, Color.white);
            E1C.selected=-1;
        }
        
        public void mouseClicked(MouseEvent e) {
            boolean clicked=false;
            for (int i=0; i<5; i+=2) {
                if (eq[i].contains(e.getX(),e.getY())) {
                    if (selected!=-1)
                        deselect();
                    clicked=true;
                    selected=i;
                    eq[selected].setColors(Color.black, Color.yellow);
                    repaintAll();
                    return;
                }
            }
            if (selected!=-1) {
                deselect();
                repaint();
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
        public void focusGained(java.awt.event.FocusEvent focusEvent) {
        }
        
        public void focusLost(java.awt.event.FocusEvent focusEvent) {
            if (selected!=-1) {
                deselect();
                repaint();
            }
        }
        
        public void keyPressed(KeyEvent E) {
        }
        
        public void keyReleased(KeyEvent E) {
        }
        
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar()==KeyEvent.VK_TAB) {
                if (selected==-1) {
                    selected=0;
                } else {
                    selected=(selected+2)%6;
                }
                repaint();
                return;
            }
            if (e.getKeyChar()==KeyEvent.VK_ENTER) {
                if (selected!=-1) {
                    deselect();
                    repaint();
                }
                return;
            }
            if (selected!=-1) {
                int x=L.x[selected/2];
                int temp=x;
            }
            
        }
    }

    int mode;
    
    Manager M;
    
    //ModeCanvas MC;
    GrabCanvas GC;
    Equation1Canvas E1C;
    RationalTriangle[] grab=new RationalTriangle[2];
    RationalLine L;
    
    /** Creates a new instance of LineSelectorCanvas */
    public LineSelector_1(Manager M) {
        this.M=M;
        
        setBackground(Color.black);
        setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        
        //MC=new ModeCanvas();
        //MC.setSize();
        GC=new GrabCanvas();
        add(GC);
        E1C=new Equation1Canvas();
        add(E1C);
        
        M.addRendererTop(this);
        
        L=M.getRationalLine();
        if (L==null)
            L=new RationalLine(1,-1,0);
        updateLine();
        
    }
    
    public void repaintAll(){
        GC.repaint();
        E1C.repaint();
    }
    
    public void updateLine() {
        if (L.isBoundaryValid()) {
            if (L!=M.getRationalLine()) {
                M.setRationalLine(L);
                M.spaceChanged();
            }
        } else {
            if (M.getRationalLine()!=null) {
                M.setRationalLine(null);
                M.spaceChanged();
            }
        }
        repaintAll();
    }
    
    public void removeManagement(){
        M.remove(this);
    }
    
    private static void renderPoint(Graphics2D g, AffineTransform transform,
    Complex Z, Color C) {
        Point2D.Double pt=new Point2D.Double();
        transform.transform(new Point2D.Double(Z.x,Z.y),pt);
        
        Stroke temp=g.getStroke();
        g.setStroke(new BasicStroke(3));
        g.setColor(Color.black);
        g.draw(new Line2D.Double(pt.getX()-5, pt.getY()-5, pt.getX()+5, pt.getY()+5));
        g.draw(new Line2D.Double(pt.getX()-5, pt.getY()+5, pt.getX()+5, pt.getY()-5));
        g.setStroke(temp);
        
        g.setColor(C);
        g.draw(new Line2D.Double(pt.getX()-5, pt.getY()-5, pt.getX()+5, pt.getY()+5));
        g.draw(new Line2D.Double(pt.getX()-5, pt.getY()+5, pt.getX()+5, pt.getY()-5));
    }
    
    public void render(Graphics2D g, AffineTransform T){
        //System.out.println("rendering");
        RationalLine L=M.getRationalLine();
        if (L!=null) {
            Line2D.Double l=L.toLineSegment();
            if (l!=null) {
                g.setColor(Color.white);
                g.draw(T.createTransformedShape(l));
            } else {
                System.err.println("Warning attempted to render invalid line");
            }
        }
        for (int i=0; i<2; i++) {
            if (grab[i]!=null) {
                renderPoint(g, T, grab[i].toComplex(),  grab_color[i]);
            }
        }
    }
    
    
}
