/*
 * ListenString.java
 *
 * Created on October 29, 2005, 10:35 PM
 */

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;

/**
 * Drawing strings in a box is particularly annoying.
 * This class represents a computationally intense way to solve the problem.
 *
 * @author  pat
 */
public class ListenString {
    public Color fgColor, bgColor;
    
    public String str;
    private Rectangle2D.Double bounds,rect;
    private double x,y;
    public boolean showBorder;
    private Component thisComponent;
    
    /**
     * Creates a new instance of ListenString, using the default font
     * of thisComponent. Usually thisComponent will be called as "this"
     */
    public ListenString(String str, Component thisComponent){
        this.str=str;
        this.thisComponent=thisComponent;
        rect=new Rectangle2D.Double();
        size();
        
        fgColor=Color.white;
        bgColor=Color.black;
        x=y=0;
        showBorder=true;
    }

    /** Creates a new instance of ListenString, using the default font
     * of thisComponent. Usually thisComponent will be called as "this."
     * In this version the height and width of the component are specified */
    public ListenString(String str, Component thisComponent, double width, double height){
        this.str=str;
        this.thisComponent=thisComponent;
        rect=new Rectangle2D.Double();
        size();
        rect.width=width;
        rect.height=height;
        
        fgColor=Color.white;
        bgColor=Color.black;
        x=y=0;
        showBorder=true;
    }
        
    public void size(){
        double x=rect.x, y=rect.y;
        FontMetrics fm=thisComponent.getFontMetrics(thisComponent.getFont());
        Rectangle2D temp=fm.getStringBounds(str,thisComponent.getGraphics());
        bounds=new Rectangle2D.Double(temp.getX()-3, temp.getY()-1,
        temp.getWidth()+6,temp.getHeight()+2);
        rect=new Rectangle2D.Double(x,y, 
        //bounds.getX(), bounds.getY(),        
        bounds.getWidth(),bounds.getHeight());        
    }
    
    public void makeIntegral(){
        rect.x=(int)(rect.x);
        rect.y=(int)(rect.y);
        rect.width=(int)(rect.width);
        rect.height=(int)(rect.height);        
    }

    /**
     * Creates a new instance of ListenString, using the default font
     * of thisComponent. Usually thisComponent will be called as "this". The
     * box constructed will be big enough for any string in the array pos.
     */    
    public ListenString(String str, String[] pos, Component thisComponent){
        this.str=str;
        FontMetrics fm=thisComponent.getFontMetrics(thisComponent.getFont());
        Rectangle2D temp=fm.getStringBounds(str,thisComponent.getGraphics()),
        temp2;
        for (int i=0; i<pos.length; i++) {
            temp2=fm.getStringBounds(pos[i],thisComponent.getGraphics());
            if (temp2.getWidth()>temp.getWidth()) 
                temp=temp2;            
        }        
        
        bounds=new Rectangle2D.Double(temp.getX()-3, temp.getY()-1,
        
        temp.getWidth()+6,temp.getHeight()+2);
        rect=new Rectangle2D.Double(bounds.getX(), bounds.getY(),
        bounds.getWidth(),bounds.getHeight());
        
        fgColor=Color.white;
        bgColor=Color.black;
        x=y=0;
        showBorder=true;
    }
    
    /** Move the button so that its lefthand side has x-coordinate x. */
    public void setLeft(double x){
        this.x=x-bounds.getX();
        rect.x=x;
    }
    
    /** Move the button so that its horizontal center has x-coordinate x. */
    public void setHorizontalCenter(double x){
        this.x=x-bounds.getX()-bounds.getWidth()/2;
        rect.x=x-bounds.getWidth()/2;
    }
    
    
    /** Move the button so that its top has y-coordinate y. */
    public void setTop(double y){
        this.y=y-bounds.getY();
        rect.y=y;
    }
    
    /** Move the button so that its righthand side has x-coordinate x. */
    public void setRight(double x){
        this.x=x-bounds.getMaxX();
        rect.x=x-bounds.getWidth();
    }
    
    /** Move the button so that its bottom has y-coordinate y. */
    public void setBottom(double y){
        this.y=y-bounds.getMaxY();
        rect.y=y-bounds.getHeight();
    }
    
    public double getLeft(){
        return rect.x;
    }
    public double getRight(){
        return rect.x+rect.width;
    }
    public double getHorizontalCenter(){
        return rect.x+rect.width/2;
    }
    public double getTop(){
        return rect.y;
    }
    public double getBottom(){
        return rect.y+rect.height;
    }
    
    public double getWidth(){
        return rect.width;
    }

    public double getHeight(){
        return rect.height;
    }
    
    public void setColors(Color fgColor, Color bgColor){
        this.fgColor=fgColor;
        this.bgColor=bgColor;
    }
    
    public boolean contains(double x, double y){
        return rect.contains(x,y);
    }      
    public boolean contains(MouseEvent e){
        return rect.contains(e.getX(),e.getY());
    }      
    
    public void render(Graphics2D g){
        g.setColor(bgColor);
        g.fill(rect);
        g.setColor(fgColor);
        if (showBorder)
            g.draw(rect);
        g.drawString(str,(float)x,(float)y);
    }
    
    /** render under a translation by (tx,ty) */
    public void render(Graphics2D g, double tx, double ty){
        g.setColor(bgColor);
        Rectangle2D.Double r=new Rectangle2D.Double(
        rect.getX()+tx, rect.getY()+ty,
        rect.getWidth(), rect.getHeight());        
        g.fill(r);
        g.setColor(fgColor);
        if (showBorder)
            g.draw(r);
        g.drawString(str,(float)(x+tx),(float)(y+ty));
    }
    
    
}
