import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class ListenTriangleEnhanced extends ListenTriangle {
    Color[] C=new Color[9];
    int[] on=new int[9];
    int history;
    int parity;
    int[] b=new int[4];
    int[] c=new int[4];


    public ListenTriangleEnhanced() {
	for(int i=0;i<=8;++i) this.on[i]=0;
    }

    public ListenTriangleEnhanced enhance(ListenTriangle T) {
	ListenTriangleEnhanced X=new ListenTriangleEnhanced();
	X.z[0]=T.z[0];
	X.z[1]=T.z[1];
	X.z[2]=T.z[2];
	X.history=this.history;
	for(int i=0;i<=8;++i) X.C[i]=this.C[i];
	for(int i=0;i<=8;++i) X.on[i]=this.on[i];
	return(X);
    }


    /**scales by r and translates by w*/

    public ListenTriangleEnhanced scaleE(Complex w,double r) {
	ListenTriangleEnhanced T=new ListenTriangleEnhanced();
	T.history=this.history;
	for(int i=0;i<=8;++i) T.on[i]=this.on[i];
	for(int i=0;i<=8;++i) T.C[i]=this.C[i];
	for(int i=0;i<=2;++i) {
	T.z[i].x=r*z[i].x+w.x;
        T.z[i].y=r*z[i].y+w.y;
	T.b[i]=this.b[i];
	T.c[i]=this.c[i];
	}
	return(T);
    }



    public void renderSmooth(Graphics2D g) {
	renderSmooth(g,C[0],C[0]);
	for(int i=1;i<=3;++i)	edgeRenderEnhanced(g,i,C[i],on[i]);
	for(int i=5;i<8;++i) {
	g.setColor(C[i]);
	if(on[i]==1) g.fillOval((int)(z[i-5].x-2),(int)(z[i-5].y-2),4,4);
	}
    }


    /**draws the selected edge */
    public void edgeRenderEnhanced(Graphics2D g,int k,Color C1,int q) {
	    Polygon P=new Polygon();
            float X[]={(float)(z[0].x),(float)(z[1].x),(float)(z[2].x)};
	    float Y[]={(float)(z[0].y),(float)(z[1].y),(float)(z[2].y)};

	    GeneralPath path=new GeneralPath();
	    int a1=(k+1)%3;
	    int a2=(k+2)%3;
	    path.moveTo(X[a1],Y[a1]);
	    path.lineTo(X[a2],Y[a2]);
	    g.setColor(C1);
	    if(q==2) g.setStroke(new BasicStroke((float)1.4));
	    if(q==1) g.setStroke(new BasicStroke((float)2.7));
	    g.draw(path);
	    if(q==1) g.setStroke(new BasicStroke((float)1.0));
    } 






    /**this routine modifies either the edges or vertices of a
       triangle depending on where it is clicked.*/


    public int modify(Point p,Color COL,int D) {
	int i,j,k,G1,G2;
	double x0,x1,x2,y0,y1,y2;
	double test;
	G1=0;
	G2=0;
	double d=0;
	int done=0;
	Complex P=new Complex(p.x,p.y);

       
	/**check near vertex*/

	for(i=0;i<=2;++i) {
	    if(Complex.dist(P,z[i])<D) done=5+i;
	}

	if(done==0) {
	Complex[] u=new Complex[10];

	for(i=0;i<=2;++i) {
	    j=i;
	    k=i+1;
	    if(j>=3) j=j-3;
	    if(k>=3) k=k-3;
	    u[1]=Complex.minus(z[j],z[k]);
	    u[2]=Complex.unit(u[1]);
	    u[3]=Complex.divide(u[1],u[2]);
	    u[4]=Complex.minus(P,z[k]);
	    u[5]=Complex.divide(u[4],u[2]);
	    if((u[5].y*u[5].y<50)&&(u[5].x>0)&&(u[5].x<Complex.norm(u[1]))) done=i+2;
	}

	if(done==0) {
	int outside=0;
	for(i=0;i<=2;++i) {
	    x0=p.x;
	    y0=p.y;
	    j=i;
	    k=i+1;
	    if(j>=3) j=j-3;
	    if(k>=3) k=k-3;
	    x1=z[j].x;
	    y1=z[j].y;
            x2=z[k].x;
	    y2=z[k].y;
	    test=x0*y1+x1*y2+x2*y0-y0*x1-y1*x2-y2*x0;
	    if(test>0) G2=1;
	    if(test<=0) G2=-1;
	    if((G1!=0)&&(G1!=G2)) outside=1;
	    G1=G2;
	}
	done=1-outside;
	}}

	    if(done==3) {
              this.C[3]=COL;
	      this.on[3]=1;
	    }

	    if(done==4) {
              this.C[1]=COL;
	      this.on[1]=1;
	    }

	    if(done==2) {
              this.C[2]=COL;
	      this.on[2]=1;
	    }

	    if(done==5) {
              this.C[5]=COL;
	      this.on[5]=1;
	    }

	    if(done==6) {
              this.C[6]=COL;
	      this.on[6]=1;
	    }

	    if(done==7) {
              this.C[7]=COL;
	      this.on[7]=1;
	    }
	    return(done);
    }


    int modify(double A,Complex B,Point p,Color COL,int d) {
	ListenTriangleEnhanced temp=this.scaleE(B,A);
	int done=temp.modify(p,COL,d);
	for(int i=0;i<=8;++i) this.C[i]=temp.C[i];
	for(int i=0;i<=8;++i) this.on[i]=temp.on[i];
	return(done);
    }

    public void print() {
	System.out.println("combinatorial data");
	System.out.println(this.b[0]+" "+this.b[1]+" "+this.b[2]);
	System.out.println(this.c[0]+" "+this.c[1]+" "+this.c[2]);
    }






}
