/*
 * PatTitleCanvas.java
 *
 * Created on November 3, 2005, 11:24 AM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class PatTitleCanvas extends DBCanvas implements MouseListener {
    Manager M;
    ListenSquare L;    

    
    /** Creates a new instance of PatTitleCanvas */
    public PatTitleCanvas(Manager M) {
        this.M=M;
        setBackground(new Color(0,0,255));
        addMouseListener(this);
	setSize(155,40);
	L=new ListenSquare(105,21,45,16,Color.white);
	L.on=1;
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
	g.setColor(Color.white);        
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString("Web McBilliards",5,13);
        g.setFont(new Font("Helvetica",Font.PLAIN,10));
	g.drawString("Pat Hooper",5,25);	
        g.drawString("Rich Schwartz",5,36);
	g.drawString("12 Jan 06",105,13);
	L.render(g,new Color(50,100,255));
	g.drawString("? info ?",112,32);
	g.setColor(new Color(50,150,255));
	g.drawRect(0,0,154,39);
    }
    
    public void document() {

        M.setExplain("Web McBilliards\n\nby Pat Hooper and Rich Schwartz\n\n This applet is a web-based version of our program McBilliards.  Ths purpose of this applet is to let the user explore periodic billiard paths in triangles.  The window you are currently reading is the info window. You scroll the text using the light blue arrow keys above\n\nVarious parts of the applet have little boxes with question marks in them.  If you click on these info boxes, this window will document the corresponding part of the appet. \n\n We already mentioned that you can scroll the text by clicking on the light blue arrow keys.  Here are some other control features of this window:\n \n You can change the scroll amount by clicking on the darker blue arrow keys.\n \n You can change the width of the text by clicking on the red arrow keys.\n \n You can change the font size by clicking on the green arrow keys.");
    }
    
    public void mouseClicked(MouseEvent e) {
        e.consume();
        Point X=new Point();
        X.x=e.getX();
        X.y=e.getY();
        if(L.inside(X)==1) document();
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
}
