/*
 * PlotCanvas.java
 *
 * Created on October 30, 2005, 4:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.lang.*;

/**
 *
 * @author  pat
 */
public class PlotCanvas extends DBCanvas
implements MouseListener, Runnable{
    
    public class PlotTypeMenu extends DBCanvas
    implements MouseListener, HearingPopup {
        ListenString[] LS;
        ListenString title;
        PopupMenu PM;
        
        public PlotTypeMenu(int X, int Y) {
            setBackground(menuBg);
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            double x=4, y=4;
            title=new ListenString("mode", this);
            title.setColors(Color.white, menuBg);
            title.showBorder=false;
            title.setLeft(x);
            title.setTop(y);
            y=title.getBottom()+4;
            LS=new ListenString[names.length];
            
            for (int i=0; i< LS.length; i++) {
                LS[i]=new ListenString(names[i],this);
                LS[i].setColors(buttonFg, types[i].getColor());
                LS[i].setLeft(x);
                LS[i].setTop(y);
                y=LS[i].getBottom();
            }
            setSize();
            addMouseListener(this);
            PM=new PopupMenu(PlotCanvas.this,this,X,Y,this);
        }
        
        private void setSize(){
            int x=0,y=0,temp;
            for (int i=0; i<LS.length; i++){
                temp=(int)(LS[i].getRight());
                if (temp>x)
                    x=temp;
                temp=(int)(LS[i].getBottom());
                if (temp>y)
                    y=temp;
            }
            setSize(x+5,y+5);
        }
        
        public void onClose(){
        }
        
        public void paint(Graphics gfx){
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            title.render(g);
            for (int i=0; i<LS.length; i++) {
                LS[i].render(g);
            }
            //doc.render(g);
            Dimension D=this.getSize();
            g.setColor(new Color(100,255,100));
            g.drawRect(0,0,D.width-1,D.height-1);
        }
        
        public void mouseClicked(java.awt.event.MouseEvent mouseEvent) {
            for (int j=0; j<LS.length; j++) {
                if (LS[j].contains(mouseEvent)) {
                    i=j;
                    PlotCanvas.this.repaint();
                }
            }
            PM.forceClose();
        }
        
        public void mouseEntered(java.awt.event.MouseEvent mouseEvent) {
        }
        
        public void mouseExited(java.awt.event.MouseEvent mouseEvent) {
        }
        
        public void mousePressed(java.awt.event.MouseEvent mouseEvent) {
        }
        
        public void mouseReleased(java.awt.event.MouseEvent mouseEvent) {
        }
        
        /** called when the menu closes */
        public void popupClosed(Component C) {
            PTM=null;
        }
        
    }
    
    Manager M;
    
    // buttons
    ListenString plotType, plot,doc,doc2;
    
    PlottingInterface[] types;
    String[] names;
    boolean[] enabled;
    
    // currently selected plot type
    int i;
    
    /** This is the width taken up by the default buttons*/
    int half_width, height;
    
    // Colors
    Color buttonBg, buttonFg;
    
    // constants
    final int padding=4;
    
    // The thread is used when plotting.
    Thread T=null;
    
    private static Color
    bgColor=new Color(100,0,100),
    menuBg=new Color(50,0,100);
    
    /** The plot-type menu */
    PlotTypeMenu PTM;
    
    /** Allows the user to interupt a plot */
    Interrupter I;
    
    /** Creates a new instance of PlotCanvas */
    public PlotCanvas(Manager M) {
        this.M=M;
        
        int num=6;
        types=new PlottingInterface[num];
        names=new String[num];
        enabled=new boolean[num];
        types[0]=new PlottingFill(M,this);
        types[1]=new PlottingPack(M,this);
        types[2]=new PlottingCover(M,this);
        types[3]=new PlottingZone(M,this);   
        types[4]=new PlottingBilliardLike(M);    
        types[5]=new PlottingPoly2(M,this);
        
        
        for (int i=0; i<types.length; i++){
            names[i]=types[i].name();
            enabled[i]=types[i].canRun();
        }
        
        this.i=0; // default to "fill plot"
        
        // Colors
        setBackground(new Color(100,0,100));
        
        setBackground(new Color(30,60,250));
        buttonBg=new Color(0,250,250);
        buttonFg=Color.black;
        
        // Buttons
        setFont(new Font("Helvetica",Font.PLAIN,12));
        
        double x,y;
        x=y=padding;
        plotType=new ListenString(names[i],names,this);   //Rich changed the string here
        plotType.setLeft(2);
        plotType.setTop(y);
        plotType.setColors(buttonFg, buttonBg);
        
        half_width=(int)plotType.getRight()+padding;
        
        y=plotType.getBottom()+padding;
        String[] options={"plot","stop"};
        plot=new ListenString("plot", options, this);
        doc2=new ListenString("?",this);     //Pat added
        doc=new ListenString("?",this);     //Pat added
        plot.setLeft(2);
        plot.setTop(y);
        plot.setColors(buttonFg, buttonBg);
        doc2.setLeft(2+plot.getRight());      //Pat added
        doc2.setTop(y);                       //Pat added
        doc2.setColors(buttonFg, buttonBg);   //Pat added
        
        height=(int)plot.getBottom()+padding;
        
        addMouseListener(this);
    }
    
    /** find the next enabled plot type */
    public void inc(){
        i=(i+1)%types.length;
        while (!enabled[i])
            i=(i+1)%types.length;
    }
    
    /** set the canvas size to some minimal but appropriate size. */
    public void setSize(){
        int[] sz=new int[2], ret;
        sz[0]=0;
        sz[1]=height;
        for (int i=0; i<types.length; i++) {
            ret=types[i].getSize();
            if (sz[0]<ret[0])
                sz[0]=ret[0];
            if (sz[1]<ret[1])
                sz[1]=ret[1];
        }
        setSize(sz[0]+half_width, sz[1]);
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        //g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
        //RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        
        plotType.str=names[i];
        plotType.setColors(buttonFg, types[i].getColor());
        plotType.render(g);
        plot.render(g);
        doc2.render(g);
        Dimension D=this.getSize();
        
        Graphics gfx2=gfx.create(half_width,0,D.width-half_width,D.height);
        types[i].paint(gfx2);
        
        g.setColor(new Color(100,180,255));
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    public void plot() {
        plot.str="stop";
        repaint();
        T=new Thread(this);
        T.setName(""+getClass().getName()+" Thread");
        T.start();
    }
    
    public void donePlot() {
        plot.str="plot";
        repaint();
        T=null;
    }
    
    public void run() {
        try {
            I=new Interrupter();
            Tile tile=types[i].plot(M.getWord(), I);
            if (tile!=null) {                
                M.plotTile(tile);
            } else {
                System.err.println("No tile found.");
            }
        } catch (Throwable t) {
            System.err.println("Some error occurred while plotting");
            System.err.flush();
            t.printStackTrace();
        }
        donePlot();
    }
    
    public void interrupt() {
        if (I!=null) {
            I.interrupt();
            donePlot();
        }
    }
    
    public void mouseClicked(MouseEvent e) {
        if (e.getX()>half_width) {
            e.translatePoint(-half_width,0);
            types[i].mouseClicked(e);
            return;
        }
        
        if (plot.contains(e.getX(),e.getY())) {
            if (T==null) {
                plot();
            } else {
                // interupt the plot
                interrupt();
            }
        } else if (plotType.contains(e.getX(),e.getY())) {
            if (PTM==null) {
                PTM=new PlotTypeMenu(
                (int)(plotType.getLeft()),(int)(plotType.getTop()));
            } else {
                PTM.PM.forceClose();
            }
            
            //inc();
            repaint();
        } else if(doc.contains(e.getX(),e.getY())) {
            document();
        } else if(doc2.contains(e.getX(),e.getY())) {
            types[i].document();
        }
    }
    
    public void mouseEntered(MouseEvent e) {
        if (e.getX()>half_width) {
            e.translatePoint(-half_width,0);
            types[i].mouseEntered(e);
            return;
        }
    }
    
    public void mouseExited(MouseEvent e) {
        if (e.getX()>half_width) {
            e.translatePoint(-half_width,0);
            types[i].mouseExited(e);
            return;
        }
    }
    
    public void mousePressed(MouseEvent e) {
        if (e.getX()>half_width) {
            e.translatePoint(-half_width,0);
            types[i].mousePressed(e);
            return;
        }
        
        
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void document() {
        M.setExplain("This is the plot window...");
    }
}

