/*
 * PlotCanvas.java
 *
 * Created on October 30, 2005, 4:36 PM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class PlottingBilliardLike implements PlottingInterface {
    Manager M;
    
    public PlottingBilliardLike(Manager M) {
        this.M=M;
    }
    
    /** Return the name of the plot technique */
    public String name(){
        return "b-like";
    }
    
    /** Returns true if the plot can be run. This is useful for example
     * if the plot relies on C code which may or may not be available
     */
    public boolean canRun(){
        return true;
    }
    
    /** draw the buttons etc. */
    public void paint(Graphics gfx){
        /** we don't need any new buttons! */
    }
    
    /** Return smallest area that the drawing will take up
     * @return an interger array of length 2 */
    public int[] getSize(){
        int[] sz=new int[2];
        sz[0]=0;
        sz[1]=0;
        return sz;
    }
    
    /** Run the algorithm to plot the tile. */
    public Tile plot(String word, Interrupter I){
        return BLikeTile.plot(word,M.getColor(), I);
    }
    
    /** Send documentation on this particular type of plotting
     * to the Explain Window. */
    public void document(){
        M.setExplain("This window is the McBilliards plotter.  Given a word W we are interested in the region O(W) in parameter space which corresponds to triangles having a periodic billiard path of combinatorial type W.  We call O(W) an 'orbit tile'. \n\nRight now the plotter is set to plot an object called the billiard-like tile, and denoted BL(W). Using combinatorial and topological methods, we (meaning Pat) produce a convex subset BL(W) which is guaranteed to contain O(W).  The billiard-like plotter draws BL(W) given W. \n\n  BL(W) can be described as follows:  Given a triangle T  let UAC(T) denote the universal abelian cover of the Euclidean orbifold modelled on T.  This space UAC(T) is naturally triangulated by copies of T. As it turns out, W describes a closed loop L(W) in UAC(T).  The point in parameter space belongs to the billiard like tile BL(W) if and only if \n\n -- L(W) is simple; \n\n -- For each edge e of the tiling of UAC(T), the algebraic intersection number of e and L(W) eauals the geometric intersection number. \n\n The McBilliards plotter, true plot, uses BL(W) as the starting point when it searches for O(W). \n\n If you are running web McBilliards as a stand-alone Java program, then this window currently also supports newton plot. This is the tile plotter for the original McBilliards.  It essentially gives the same result as true plot, but is much slower. You can use newton plot to check the results of true plot.   ");
    }
    
    /** These are taken from MouseListener */
    public void mouseClicked(MouseEvent e){}
    
    public void mouseEntered(MouseEvent e){}
    
    public void mouseExited(MouseEvent e){}
    
    public void mousePressed(MouseEvent e){}
    
    public void mouseReleased(MouseEvent e){}
    
    public Color getColor() {
        return new Color(250,150,255);
    }
    
}
