import java.awt.*;
import java.awt.event.*;

/** (Made by Pat, modified by Rich) This is the super class that handles Rich's plots.*/

public abstract class PlottingDyadic implements PlottingInterface {
    Manager M;
    Canvas containing_canvas;
    ListenSquare L;
    ListenSquare L2;
    IntegerSelector I1;
    
    public PlottingDyadic(Manager M, Canvas C) {
        this.M=M;
        containing_canvas=C;
        L=new ListenSquare(7,4,42,16,Color.white); // toggle show squares
        L2=new ListenSquare(58,6,12,12,new Color(80,130,255)); // toggle show squares
	L2.on=1;
        I1=new IntegerSelector(7,23,32,16,1,1,25,1);
    }
    
    /** Return the name of the plot technique */
    public abstract String name();
    
    /** Returns true if the plot can be run. This is useful for example
     * if the plot relies on C code which may or may not be available
     */
    public boolean canRun(){
        return true;
    }
    
    /** draw the buttons etc. */
    public void paint(Graphics gfx){
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        Color C1=new Color(250,0,255);
        L.render2(g,C1);  
        L2.render(g,C1);
        g.setColor(Color.black);
        if(L.on==0) g.drawString("solid",10,16);
        if(L.on==1) g.drawString("seams",10,16);
        if(L.on==2) g.drawString("local",10,16);
        I1.render(g,C1,Color.black,Color.white);
    }
    
    /** Return smallest area that the drawing will take up
     * @return an integer array of length 2 */
    public int[] getSize(){
        int[] sz=new int[2];
        sz[0]=80;
        sz[1]=30;
        return sz;
    }
    
    /** Send documentation on this particular type of plotting
     * to the Explain Window. */
    public abstract void document();
    public abstract Color getColor();
    
    /** Run the algorithm to plot the tile. */

    public Tile plot(String word, Interrupter I){
        int mode=getRigor();  

	if(mode<4) {
            DyadicPlotter DP=new DyadicPlotter(mode, L.on, I1.val, L2.on, word, M.getColor(), I);
	    DP.Z=M.getZ();
	    DyadicTile DT=DP.basicPlot();
	    if(L.on==2) M.setParameter(DP.Z.x,DP.Z.y);
	    return DT;
	}

	if(mode==4) return DyadicPlotter.zonePlot(L.on,word,I1.val,M.getColor(),M.getZ(), I);


	//these modes are for the 100 degree result
	if(mode==5) {
	    int n=M.getN();
	    if(n==0) return(null);
	    RationalPolygonPlotter DP=new RationalPolygonPlotter(M.getPOLY(),word,M.getColor());
	   return DP.specialPlot();
	}

	if(mode==6) {
	    int n=M.getN();
	    if(n==0) return(null);
	    Deg100Verifier DP=new Deg100Verifier(M.getPOLY(),L.on,L2.on,word,M.getColor(),M.getZ());
	    DyadicTile DT=DP.basicPlot();
	    M.boxes=DT.boxes;
	    M.depth=DT.depth;
	    M.time=DT.time;
	    M.exceptions[0][0]=DT.exceptions[0][0];
	    for(int i=1;i<=DT.exceptions[0][0];++i) {
	      M.exceptions[i][0]=DT.exceptions[i][0];
	      M.exceptions[i][1]=DT.exceptions[i][1];
	    }

 	    return DT;
	}


	if(mode==7) {
	    Deg100Cover DP=new Deg100Cover(M.getAllPOLY());
 	    return DP.basicPlot();
	}



        return null;
    }
    
    public abstract int getRigor();
    
    /** These are taken from MouseListener */
    public void mouseClicked(MouseEvent e){
        e.consume();
        Point X=new Point();
        X.x=e.getX();
        X.y=e.getY();
        I1.modify(X);
        containing_canvas.repaint();
    }
    
    public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}
    public void mousePressed(MouseEvent e){
        e.consume();
        Point X=new Point();
        X.x=e.getX();
        X.y=e.getY();
        if(L.inside(X)==1) {
            ++L.on;
            if(L.on==3) L.on=0;
        }
	if(L2.inside(X)==1) L2.on=1-L2.on;  
        containing_canvas.repaint();
    }
    public void mouseReleased(MouseEvent e){}




}
