/*
 * PlottingCautious.java
 *
 * Created on December 1, 2005, 9:05 AM
 */

import java.awt.*;

/**
 *
 * @author  pat
 */
public class PlottingRigorousIgnore extends PlottingDyadic {
    
    /** Creates a new instance of PlottingCautious */
    public PlottingRigorousIgnore(Manager M, Canvas C) {
        super(M,C);
    }
    
    public String name() {
        return "rigorous (1)";
    }
        
    public Color getColor() {
        return new Color(255,100,0);
    }


    public void document() {
        M.setExplain("This window is the McBilliards plotter. Given a word W, we are interesed in drawing the region O(W) in parameter space such that the corresponding triangles have a periodic billiard path with W as the combinatorial type. We call O(W) the 'orbit tile', or just the 'tile' for short. \n\n  Right now the plotter is limited to plotting words of length 1000. There are 4 versions of the plotter, and you could think of them as moving along a spectrum from slow and rigorous to fast and risky. \n\nRight now the mode is set to the rigorous plotter.  This plotter produces a finite union of dyadic squares which definitely line in O(W).  Were this algorithm to run (with the same output) on a machine with no roundoff error, the union of dyadic squares would provably lie in O(W).  The same result could be obtained if the algorithm were run using interval arithmetic.   \n\n Our plotters are based on a dyadic subdivision algorithm, which we now describe.  The basic object for the algorithm is a square with dyadic rational coordinates. Such a square comes equipped with a finite list of vertices, some on the top of the unfolding and some on the bottom.  Before anything else is done, we run a kind of elimination tournament for the top and bottom vertices separately.  Each match of the tournament works like this.  We compute the defining function for the pair of vertices.  (The function vanishes iff the vertices have the same height.)  We then use calculus to try to verify that the function is either positive or negative throughout the square. Essentially we produce a guaranteed upper bound for the second partial derivatives and then use this to bound the variation of the gradients.  If our calculus argument succeeds, then the match has a winner and we eliminate the loser.  Once the top and bottom tournaments are done, we have a playoff round where we match up all the top vertex winners with all the bottom vertex winners. There are several cases: \n\n 1. If all the top vertices win their matches in the playoffs then we include the square as part of the tile. \n\n 2. If one top vertex loses a playoff match then we eliminate the square. \n\n 3. If neither of the above happens - often the matches are inconclusive - then we subdivide the square and repeat the whole business. \n\n 4. If the square is smaller than a certain cutoff, we eliminate the square. The number on the display controls the base 2 logarithm of the size of the cutoff.\n\n This plotter and the others all take as a starting point the so-called billiard-like tile BL(W), produced by Pat's combinatorial analysis.  BL(W) is a convex rational polygon guaranteed to contain O(W).  To speed our algorithm up, we simply throw out any dyadic square which is disjoint from BL(W).");
    }

    public int getRigor() {
        return 0;
    }    


    
}
