/*
 * PlottingCautious.java
 *
 * Created on December 1, 2005, 9:05 AM
 */

import java.awt.*;

/**
 *
 * @author  pat
 */
public class PlottingSensible extends PlottingDyadic {
    
    /** Creates a new instance of PlottingCautious */
    public PlottingSensible(Manager M, Canvas C) {
        super(M,C);
    }
    
    public void document() {
        M.setExplain("This window is the McBilliards plotter. Given a word W, we are interesed in drawing the region O(W) in parameter space such that the corresponding triangles have a periodic billiard path with W as the combinatorial type. We call O(W) the 'orbit tile', or just the 'tile' for short. \n\n  Right now the plotter is limited to plotting words of length 1000. There are 4 versions of the plotter, and you could think of them as moving along a spectrum from slow and rigorous to fast and risky.  \n\nRight now the mode is set to the fast plotter.  This plotter has the same kind of output as the cautious plotter, but does not produce a rigorous bound on the second derivatives of the defining functions.  Rather it uses the absolute values of the second derivatives, when they are evaluated at the center of mass of BL(W), Pat's billiard-like tile.  In general this plotter is faster than the cautious plotter but just as accurate.");
    }
    
    public String name() {
        return "fast";
    }
    
    public Color getColor() {
        return new Color(255,100,0);
    }
    
    public int getRigor() {
        return 3;
    }
    
}
