import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class PolygonChopper {
    int[][][] denominator=new int[3][3][1000];
    CombinatorialTriangle[] CT;
    int[] top;
    int[] bot;
    int[][] numerator;
    int sign,spine,palindrome;
    VertexPair V;



    public PolygonChopper(String W) {
        CT=CombinatorialTriangle.unfold(W);
        CT=CombinatorialTriangle.assignTails(CT);
        palindrome=Spine.palindromeTest(CT);
	if(awkwardWord(W)==1) palindrome=0;
        this.denominator[0]=Function.computeDenominator(0,CT);
        this.denominator[1]=Function.computeDenominator(1,CT);
        this.denominator[2]=Function.computeDenominator(2,CT);
	top=Spine.completeList(1,CT);
	bot=Spine.completeList(2,CT);
    }


    
    /**for some reason the signs of our functions aren't
     * computed right when our word is a palindrome starting
     * with 12 or 21.  In this case, we just turn off the
     * palindromic enhancement.*/
    
    public int awkwardWord(String X) {
        int d1=1+Spine.getDigit(X,0);
        int d2=1+Spine.getDigit(X,1);
        if(d1*d2==2) return(1);
        return(0);
    }


    //FUNCTION EVALUATON ROUTINES


    public int[][] getSignedNumerator(VertexPair V) {
        int[][]f=new int[0][0];
        if(palindrome==0) {
            spine=Spine.spineNumber(V,CT);
            sign=Spine.getSign(V,CT,denominator[spine]);
        }
        
        if(palindrome==1) {
            spine=Spine.spineNumber(V,CT);
            f=PalindromeFunction.getFunction(denominator[spine],V,CT);
        }
        return(f);
    }



    public double evaluate(Complex Z) {
        if(palindrome==0) {
            double val=Spine.evaluate(sign,V,CT,denominator[spine],Z);
            return(val);
        }
        if(palindrome==1) return(PalindromeFunction.evaluate(numerator,Z));
        return(0);
    }
   
    public double[] getValues(VertexPair V,SmallPolygon P) {
        double[] x=new double[P.N];
        numerator=getSignedNumerator(V);
        for(int i=0;i<P.N;++i) x[i]=evaluate(P.Z[i]);
        return(x);
    }
    

    /**these routines take into account the spine type and give the
       normalized value of the spine type*/

    public double medianEvaluate(Complex Z) {
            double d=1;
	    if(spine==0) d=Math.sin(Math.PI*Z.x/2);
	    if(spine==1) d=Math.sin(Math.PI*Z.y/2);
	    if(spine==2) d=Math.sin(Math.PI*(2-Z.x-Z.y)/2);
	    d=d*d;

        if(palindrome==0) {
            double val=Spine.evaluate(sign,V,CT,denominator[spine],Z);
            return(val/d);
        }
        if(palindrome==1) return(PalindromeFunction.evaluate(numerator,Z)/d);
        return(0);
    }
   
    public double[] getMedianValues(VertexPair V,SmallPolygon P) {
        double[] x=new double[P.N];
        numerator=getSignedNumerator(V);
        for(int i=0;i<P.N;++i) x[i]=medianEvaluate(P.Z[i]);
        return(x);
    }
    
    

    //BASIC CHOPPING ROUTINES
    
    
    
    public SmallPolygon chopPolygon(VertexPair V,SmallPolygon P) {
        double[] u=getValues(V,P);
        
        Complex[] w=new Complex[1000];
        int count=0;
        int j=0;
        double t=0;
        for(int i=0;i<P.N;++i) {
            if(u[i]>-.00000000001) {
                w[count]=new Complex(P.Z[i].x,P.Z[i].y);
                ++count;
            }
            j=i+1;
            if(j==P.N) j=0;
            if(u[i]*u[j]<0) {
                t=u[i]/(u[i]-u[j]);
                w[count]=new Complex();
                w[count].x=(1-t)*P.Z[i].x+t*P.Z[j].x;
                w[count].y=(1-t)*P.Z[i].y+t*P.Z[j].y;
                ++count;
            }
        }
        SmallPolygon Q=new SmallPolygon(w,count);
        return(Q);
    }



    
    public SmallPolygon negativeChopPolygon(VertexPair V,SmallPolygon P) {
        double[] u=getValues(V,P);
	for(int i=0;i<P.N;++i) u[i]=-u[i];
        
        Complex[] w=new Complex[1000];
        int count=0;
        int j=0;
        double t=0;
        for(int i=0;i<P.N;++i) {
            if(u[i]>-.00000000001) {
                w[count]=new Complex(P.Z[i].x,P.Z[i].y);
                ++count;
            }
            j=i+1;
            if(j==P.N) j=0;
            if(u[i]*u[j]<0) {
                t=u[i]/(u[i]-u[j]);
                w[count]=new Complex();
                w[count].x=(1-t)*P.Z[i].x+t*P.Z[j].x;
                w[count].y=(1-t)*P.Z[i].y+t*P.Z[j].y;
                ++count;
            }
        }
        SmallPolygon Q=new SmallPolygon(w,count);
        return(Q);
    }


    public SmallPolygon chopSquare(DyadicSquare Q) {
        Complex[] Z=Q.toPolygon();
	SmallPolygon P=new SmallPolygon(Z,4);
	return(chopPolygon(P,Q));
    }




    public SmallPolygon chopPolygon(SmallPolygon PP,DyadicSquare Q) {
        SmallPolygon P=new SmallPolygon();
        P=PP;
        for(int i=1;i<=Q.top[0];++i) {
            for(int j=1;j<=Q.bot[0];++j) {
                V=new VertexPair(1,top[Q.top[i]],2,bot[Q.bot[j]]);
                P=chopPolygon(V,P);
            }
        }
        return(P);
    }


    public SmallPolygon medianChopPolygon(VertexPair V0,SmallPolygon PP,DyadicSquare Q) {
        SmallPolygon P=new SmallPolygon();
	P=PP;

	for(int i=1;i<=Q.top[0];++i) {
	    V=new VertexPair(1,V0.e1,1,top[Q.top[i]]);
	    if(V.e1>V.e2)   P=chopPolygon(V,P);
	    if(V.e1<V.e2)   P=negativeChopPolygon(V,P);
	}

	for(int i=1;i<=Q.bot[0];++i) {
	    V=new VertexPair(2,V0.e2,2,bot[Q.bot[i]]);
	    if(V.e1<V.e2)   P=chopPolygon(V,P);
	    if(V.e1>V.e2)   P=negativeChopPolygon(V,P);
	}

        return(P);
    }
    
    public SmallPolygon medianChopSquare(VertexPair V0,DyadicSquare Q) {
        Complex[] Z=Q.toPolygon();
	SmallPolygon P=new SmallPolygon(Z,4);
	return(medianChopPolygon(V0,P,Q));
    }





    public int testBelonging(DyadicSquare INIT,Complex Z) {
        double test;
        for(int i=1;i<=INIT.top[0];++i) {
            for(int j=1;j<=INIT.bot[0];++j) {
                V=new VertexPair(1,top[INIT.top[i]],2,bot[INIT.bot[j]]);
                int spine=Spine.spineNumber(V,CT);
                numerator=getSignedNumerator(V);
                test=evaluate(Z);
                if(test<-0.0000000001) return(0); //small cutoff
            }
        }
        return(1);
    }
    
    



}