/*
 * PopupListCanvas.java
 *
 * Created on October 30, 2005, 8:59 PM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class PopupListCanvas extends DBCanvas
implements HearingPopup, MouseListener {
    Manager M;
    SpaceTileManager STM;
    
    ListenString[] ls;
    ListenString doc;
    Component[] c;
     
    // Colors
    Color buttonBg, buttonFg, selectedBg, selectedFg;
    
    // Constants
    int padding;
    
    /** Creates a new instance of PopupListCanvas */
    public PopupListCanvas(Manager M) {
        this.M=M;
        this.STM=STM;
        
        // Colors
        setBackground(new Color(0,100,0));
        buttonFg=Color.black;
        selectedFg=Color.black;
        buttonBg=new Color(100,255,100);
        selectedBg=Color.yellow;
        
        
        // Buttons
        setFont(new Font("sanserif", Font.PLAIN, 12));
        padding=4;
        
        ls=new ListenString[5];
        c=new Component[5];
        
        double x=padding,y=padding;
        
        x=padding;
        y=padding;
        ls[0]=new ListenString("unfolding", this);
        ls[0].setLeft(x); ls[0].setTop(y);
        
        x=ls[0].getRight()+padding;
        ls[3]=new ListenString("where am i", this);
        ls[3].setLeft(x); ls[3].setTop(y);
        
        x=ls[3].getRight()+padding;
        doc=new ListenString("?", this);
        doc.setLeft(x); doc.setTop(y);
        
        y=ls[0].getBottom()+padding;
        x=padding;
        ls[2]=new ListenString("memory", this);
        ls[2].setLeft(x); ls[2].setTop(y);        
        
        x=ls[2].getRight()+padding;
        ls[4]=new ListenString("word window", this);
        ls[4].setLeft(x); ls[4].setTop(y);
                
        x=ls[4].getRight()+padding;
        ls[1]=new ListenString("more", this);
        ls[1].setLeft(x); ls[1].setTop(y);        

        for (int i=0; i<ls.length; i++){
            ls[i].setColors(buttonFg, buttonBg);
            //ls[i].showBorder=false;
        }
        doc.setColors(buttonFg, buttonBg);
        //doc.showBorder=false;
        
        addMouseListener(this);
    }
    
    public void setSize(){
        int x=0,y=0,temp;
        for (int i=0; i<ls.length; i++){
            temp=(int)(ls[i].getRight());
            if (temp>x)
                x=temp;
            temp=(int)(ls[i].getBottom());
            if (temp>y)
                y=temp;
        }
        temp=(int)(doc.getRight());
        if (temp>x)
            x=temp;
        setSize(x+padding,y+padding);
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        //g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
        //RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        
        
        for (int i=0; i<ls.length; i++) {
            ls[i].render(g);
        }
        doc.render(g);
	Dimension D=this.getSize();
	g.setColor(new Color(100,255,100));
	g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    public void popupClosed(Component C) {
        for (int i=0; i<c.length; i++) {
            if (c[i]==C) {
                // process components that require specific attention
                switch (i){
                    case 0: // unfolding;
                        ((UnfoldContainer)C).removeManagement();
                        break;
                    case 1: // more popups
                        ((MorePopupsCanvas)C).closeAll();
                }
                M.remove(C);
                c[i]=null;
                ls[i].setColors(buttonFg, buttonBg);
                repaint();
                return;
            }
        }
    }
    
    private void show(int i){
        switch (i){
            case 0: // unfolding
                UnfoldContainer U=new UnfoldContainer(M);
                new PopupWindow("Unfolding", U, this);
                c[i]=U;
                break;
            case 1:
                MorePopupsCanvas MPC=new MorePopupsCanvas(M, STM);
                MPC.setSize();
                new PopupWindow("More Popups", MPC, this);
                c[i]=MPC;
                break;
            case 2:
                FileLoaderContainer FLC=new FileLoaderContainer(M);
                new PopupWindow("Memory", FLC, this);
                c[i]=FLC;
                break;
	    case 3:
	        WhereAmICanvas W=new WhereAmICanvas(M);
	        W.setSize(200,200);
	        new PopupWindow("Where am I?",W,this);
		c[i]=W;
		break;
            case 4:
                TwistWordContainer TWC=new TwistWordContainer(M); 
                new PopupWindow("Word",TWC,this);
                c[i]=TWC;
		break;
        }
        ls[i].setColors(selectedFg, selectedBg);
    }
    
    public void mouseClicked(MouseEvent e) {
        for (int i=0; i<ls.length; i++) {
            if (ls[i].contains(e.getX(),e.getY())){
                if (c[i]==null) {
                    // create the popup
                    show(i);
                    repaint();
                }
            }
        }
        if (doc.contains(e.getX(),e.getY()))
            document();
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void document(){
        M.setExplain("You can select a popup from this window. Press one of these buttons and a new window will appear.");
    }
}
