/*
 * PopupWindow.java
 *
 * Created on October 30, 2005, 1:04 PM
 */

import java.awt.*;
import java.awt.event.*;

/**
 * This class is meant to hold a single canvas, which it places in a
 * popup window. Note that popup windows can be resized.
 *
 * @author  pat
 */
public class PopupWindow extends Frame
implements ComponentListener, WindowListener {
    
    String windowName;
    public Component C;
    public HearingPopup HP;
    PopupMenu PM;
    
    /** Creates a new instance of ResizableFrame */
    public PopupWindow(String windowName, Component C, HearingPopup HP) {
        super(windowName);
        
        // this allows us to detect the TAB key
        setFocusTraversalKeys(KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS,
        java.util.Collections.EMPTY_SET);
        
        this.windowName=windowName;
        this.C=C;
        this.HP=HP;
        add(C);
        pack();
        addComponentListener(this);
        addWindowListener(this);
        setVisible(true);
    }
        
    public void forceClose() {
        // dispose of the window
        dispose();
        // notify that the window has closed, so the component is no longer
        // displayed.
        HP.popupClosed(C);
        
        // remove all references to C
        C=null;
        removeAll();
        System.gc();
    }
    
    ////////////////// ComponentListener
    
    public void componentHidden(ComponentEvent e) {
    }
    
    public void componentMoved(ComponentEvent e) {
    }
    
    public void componentResized(ComponentEvent e) {
        C.setSize(C.getWidth() - (getInsets().left + getInsets().right),
        C.getHeight() - (getInsets().top + getInsets().bottom));
        getLayout().layoutContainer(this);
    }
    
    /* Resize the Window so the width and
     * height are as specified by the constructor */
    public void componentShown(ComponentEvent e) {
        //System.out.println("Component's size: "+C.getWidth()+"x"+C.getHeight());
        setSize(C.getWidth() + (getInsets().left + getInsets().right),
        C.getHeight() + (getInsets().top + getInsets().bottom));
        getLayout().layoutContainer(this);
    }
    
    
    public void windowActivated(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowClosed(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowClosing(java.awt.event.WindowEvent windowEvent) {
        // dispose of the window
        dispose();
        // notify that the window has closed, so the component is no longer
        // displayed.
        HP.popupClosed(C);
        
        // remove all references to C
        C=null;
        removeAll();
        System.gc();
    }
    
    public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowIconified(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowOpened(java.awt.event.WindowEvent windowEvent) {
    }
    
}
