/*
 * SearchControl.java
 *
 * Created on November 16, 2005, 11:45 AM
 */

/**
 *
 * @author  pat
 */
public class SearchControl implements BasicSearcher {
    Manager M;
    int type;
    Thread T;
    BasicSearcher BS;
    int depth;
    
    static final String[] seek_types={"basic","scaled","c:basic",
    "c:palindrome","c:odd square"};
    static final boolean[] seek_enabled={
        true,
        false,
        ExternSearch.canRunSlalom(),
        ExternSearch.canRunPalindrome(),
        ExternSearch.canRunOddSquare()
    };
    
    /** Creates a new instance of SearchControl */
    public SearchControl(Manager M, BasicSearcher BS) {
        this.M=M;
        this.BS=BS;
        type=0;
        while (! seek_enabled[type]) {
            type=type+1;
        }
        depth=50;
    }
    
    public int getDepth(){
        return depth;
    }
    
    public void setDepth(int d) {
        depth=d;
    }
    
    /** Move to the next search type */
    public void inc() {
        type=(type+1)%seek_types.length;
        while (! seek_enabled[type]) {
            type=(type+1)%seek_types.length;
        }
    }
    
    /** Return the name of the currently selected search */
    public String getSearchType() {
        return seek_types[type];
    }
    
    public void startSearch(){
        if (T==null) {
            switch (type) {
                case 0:
                    T=new BasicSearch(new Complex(M.getX(),M.getY()),depth,this);
                    break;
                case 1:
                    T=new ScaledSearch(new Complex(M.getX(),M.getY()),depth,this);
                    break;
                case 2:
                    T=ExternSearch.SlalomSearch(new Complex(M.getX(),M.getY()),depth,this);
                    break;
                case 3:
                    T=ExternSearch.PalindromeSearch(new Complex(M.getX(),M.getY()),depth,this);
                    break;
                case 4:
                    T=ExternSearch.OddSquareSearch(new Complex(M.getX(),M.getY()),depth,this);
                    break;                     
            }
        } else {
            System.err.println("Warning: Attempted to search while already seeking... -SearchControl");
        }
    }
    
    public void interrupt() {
        if (T!=null) {
            try {
                T.interrupt();
            } catch (Throwable t) {
                System.err.println("error in interrupt");
                System.err.flush();
                t.printStackTrace();
            }
            T=null;
        }
    }
    
    public void doneBasicSearch(BasicSearchResults results) {
        T=null;
        BS.doneBasicSearch(results);
    }
    
    public boolean searching() {
        return T!=null;
    }
}
