/*
 * TextProcess.java
 *
 * Created on December 13, 2005, 10:48 AM
 */

import java.awt.event.*;

/**
 * This is file contains a bunch of static methods that take a keyEvent
 * and use it to modify a value.
 *
 * @author  pat
 */
public class TextProcess {
    
    public static int Integer(int x, KeyEvent e) {
        if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE)
            return x/10;
        if (e.getKeyChar()==KeyEvent.VK_DELETE)
            return 0;
        int ch=(int)(e.getKeyChar()-'0');
        if ((ch>=0)&&(ch<10))
            return 10*x+ch;
        if (e.getKeyChar()=='-')
            return -x;
        return x;
    }
    
    /** deals with values in the interval [0,1) */
    public static String Interval(String s, KeyEvent e) {
        if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE) {
            if (s.length()>2) {
                return s.substring(0,s.length()-1);
            } else {
                return "0.";
            }
        }
        if (e.getKeyChar()==KeyEvent.VK_DELETE)
            return "0.";
        if ((e.getKeyChar()>='0') && (e.getKeyChar()<='9')) {
            return s+e.getKeyChar();
        }
        return s;        
    }
    
    public static int NonnegativeInteger(int x, KeyEvent e) {
        if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE)
            return x/10;
        if (e.getKeyChar()==KeyEvent.VK_DELETE)
            return 0;
        int ch=(int)(e.getKeyChar()-'0');
        if ((ch>=0)&&(ch<10))
            return 10*x+ch;
        return x;
    }
    
    public static String Filename(String s, KeyEvent e) {
        if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE) {
            if (s.length()>0) {
                return s.substring(0,s.length()-1);
            } else {
                return s;
            }
        }
        if (e.getKeyChar()==KeyEvent.VK_DELETE)
            return "";
        char c=e.getKeyChar();
        if ((c>='a')&&(c<='z')) {
            return s+c;
        }
        if ((c>='A')&&(c<='Z')) {
            return s+c;
        }
        if ((c>='0')&&(c<='9')) {
            return s+c;
        }
        if (c=='_') {
            return s+c;
        }
        return s;
    }
    
    //    static String String(String s, KeyEvent e){
    //    }
    
}
