/*
 * TwistWordContainer.java
 *
 * Created on November 11, 2005, 9:28 AM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class TwistWordContainer extends Container {
    static String[] modes={"standard","projection","normal","dot"};
    public class TwistWordController extends DBCanvas 
    implements MouseListener {
        int m;
        
        ListenString t1,mode, doc;
        public TwistWordController(){
            setBackground(Color.blue);
            
            setFont(new Font("sanserif", Font.PLAIN, 12));
            int padding=4;
            
            double x=padding,y=padding;
            t1=new ListenString("mode:", this);
            t1.setLeft(x); t1.setTop(y);
            t1.showBorder=false;
            t1.setColors(Color.white,getBackground());
            
            x=padding+t1.getRight();
            m=Main.mode;
            mode=new ListenString(modes[m],modes, this);
            mode.setLeft(x); mode.setTop(y);
            mode.setColors(Color.white,new Color(100,100,255));
            
            x=padding+mode.getRight();
            doc=new ListenString("?", this);
            doc.setLeft(x); doc.setTop(y);
            doc.setColors(Color.white,new Color(60,60,255));
            
            setSize((int)(doc.getRight()+padding),
            (int)(doc.getBottom()+padding));
            
            addMouseListener(this);
        }
        
        public void paint(Graphics gfx){
            Graphics2D g=(Graphics2D) gfx;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
            RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            
            t1.render(g);
            mode.render(g);
            doc.render(g);
        }
        
        public void mouseClicked(MouseEvent e) {
            if (mode.contains(e.getX(),e.getY())) {
                m=(m+1)%modes.length;
                mode.str=modes[m];
                Main.mode=m;
                Main.draw();
                Main.repaint();
                repaint();
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
    }
    
    
    TwistWordCanvas Main;
    TwistWordController Cont;
    
    /** Creates a new instance of TwistWordContainer */
    public TwistWordContainer(Manager M) {
        Main=new TwistWordCanvas(M);
        Main.setSize(200,200);
    
        Cont=new TwistWordController();        
        
        setLayout(new BorderLayout());
        add(Main,"Center");
        add(Cont,"South");
        validate();
    }
    
}
