import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;



/*This class draws the unfolding of a word relative to a triangle.  It
  is the analog of the unfol window in McBilliards.*/


public class UnfoldCanvas extends DBCanvas
implements MouseListener, MouseMotionListener, HearingSelectTile, HearingParameter {
    // This Canvas's controller
    UnfoldControlCanvas UC;
    // This canvas's container
    UnfoldContainer UContainer;
    
    
    ListenTriangleEnhanced[] T=new ListenTriangleEnhanced[1001];
    CombinatorialTriangle[] CT=new CombinatorialTriangle[1001];
    String W;
    Tile ST;
    Complex Z;
    Manager M;
    Corridor C;
    double A;
    Complex B;
    Complex START,END;
    int mode;
    ListenSquare L;
    int dyadic;
    
    // turn true as soon as this component has been painted
    boolean painted_once=false;
    
    public UnfoldCanvas(Manager M, UnfoldContainer ucont) {
        // add the manager
        this.M=M;
        // listen for changes to the word
        M.hearSelectTile(this);
        //listen for changes to the point in the parameter space
        M.hearParameter(this);
        
        dyadic=0;
        UContainer=ucont;
        
        
        
        for(int i=0;i<=1000;++i) T[i]=new ListenTriangleEnhanced();
        C=new Corridor();
        A=1.0;
        B=new Complex();
        mode=2;
        START=new Complex();
        END=new Complex();
        L=new ListenSquare(0,0,12,12,Color.white);
        addMouseListener(this);
        addMouseMotionListener(this);
        
        // get the triangle and the word
        Z=M.getZ();
        W=M.getWord();
        ST=M.getSelectedTile();
    }
    
    public boolean shouldBoxAnalyze() {
        if (ST.getClass().getName()=="DyadicTile") { // check to see if the tile is a DyadicTile
            DyadicTile DT=(DyadicTile)(ST);
            if (DT.record_active==1) {
                return true;
                //System.out.println("Show BAC");
            }
        }
        return false;
    }
    
    public void addUnfoldControlCanvas(UnfoldControlCanvas UC){
        this.UC=UC;
        doUnfold();
    }
    
    public void mousePressed(MouseEvent e) {
        e.consume();
        START.x=e.getX();
        START.y=e.getY();
        Point X=new Point();
        X.x=e.getX();
        X.y=e.getY();
        if(mode==2) UC.recolor(X,W.length());
    }
    
    
    public void mouseReleased(MouseEvent e) {
        UC.spineFunction();
    }
    
    
    
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        e.consume();
        Point X=new Point();
        X.x=e.getX();
        X.y=e.getY();
        if(L.inside(X)==1) document();
        if(L.inside(X)==0) {
            
            if(M.mouse==1) {
                if(e.getButton()==MouseEvent.BUTTON1) mode=1;
                if(e.getButton()==MouseEvent.BUTTON2) mode=2;
                if(e.getButton()==MouseEvent.BUTTON3) mode=3;
            }
            if(M.mouse==0) mode=M.mode;
            if(mode==1) {
                double u=Math.sqrt(2.0);
                A=A*u;
                B.x=u*B.x-(u-1)*X.x;
                B.y=u*B.y-(u-1)*X.y;
            }
            if(mode==3) {
                double u=Math.sqrt(0.5);
                A=A*u;
                B.x=u*B.x-(u-1)*X.x;
                B.y=u*B.y-(u-1)*X.y;
            }
        }
        repaint();
        UC.repaint();
    }
    
    public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {
        
        Point X=new Point();
        e.consume();
        END.x=e.getX();
        END.y=e.getY();
        
        if(e.getButton()==MouseEvent.BUTTON1) mode=1;
        if(e.getButton()==MouseEvent.BUTTON2) mode=2;
        if(e.getButton()==MouseEvent.BUTTON3) mode=3;
        if(M.mouse==0) mode=M.mode;
        
        if(mode==2) {
            B.x=B.x+END.x-START.x;
            B.y=B.y+END.y-START.y;
            START.x=END.x;
            START.y=END.y;
        }
        
        repaint();
        UC.repaint();
    }
    
    
    
    
    /**drawing routines*/
    
    public void paint(Graphics gfx) {
        if (!painted_once) {
            painted_once=true;
            doUnfold();
        }
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        L.infoRender(g);
        Dimension D=this.getSize();
        drawUnfold(g);
        if(UC.L[10].on==1) drawBilliardPath(g);
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    
    public void drawUnfold(Graphics2D g) {
        int n=W.length();
        ListenTriangleEnhanced[] T2=new ListenTriangleEnhanced[1000];
        for(int i=1;i<=n;++i) {
            T2[i]=T[i].scaleE(B,A);
        }
        for(int i=1;i<=n;++i)	{
            T2[i].renderSmooth(g);
        }
    }
    
    
    public void setLeaders() {
        if(W.length()>0) {
            int v1=CT[C.i1].c[1];
            if(v1>W.length()/2) {v1=1;C.i1=1;}
            
            UC.v1[1]=1;
            UC.v1[2]=C.i1;
            UC.v1[3]=v1;
            UC.v1[4]=C.ii1;
            
            int v2=CT[C.i2].c[2];
            if(v2>W.length()/2) {v2=1;C.i2=1;}
            UC.v2[1]=2;
            UC.v2[2]=C.i2;
            UC.v2[3]=CT[C.i2].c[2];
            UC.v2[4]=C.ii2;
            
            
            //*an exceptional case*/
            int last=Spine.lastDigit(W);
            if((UC.v1[2]==W.length())&&(UC.v1[4]==last)) {UC.v1[2]=1;UC.v1[3]=1;}
            if((UC.v2[2]==W.length())&&(UC.v2[4]==last)) {UC.v2[2]=1;UC.v2[3]=1;}
            T[C.i1].C[5+C.ii1]=UC.L[5].C;
            T[C.i2].C[5+C.ii2]=UC.L[5].C;
            UC.spineFunction();
        }
    }
    
    public void drawBilliardPath(Graphics g) {
        if(C.t1>C.t2) {
            g.setColor(UC.L[4].C);
            Dimension D=this.getSize();
            g.drawLine(0,(int)(A*C.t1+B.y),D.width,(int)(A*C.t1+B.y));
            g.drawLine(0,(int)(A*C.t2+B.y),D.width,(int)(A*C.t2+B.y));
        }
    }
    
    
    /**geometric unfolding */
    
    
    public  static ListenTriangle[] rawUnfold(ListenTriangle A,String W) {
        ListenTriangle[] T1=new ListenTriangle[1000];
        for(int i=0;i<=999;++i) T1[i]=new ListenTriangle();
        T1[0]=A;
        int n=W.length();
        int digit=-1;
        String S=new String();
        if(n>1) {
            for(int i=0;i<=n;++i) {
                if(i<n)  S=W.substring(i,i+1);
                if(i==n) S=W.substring(0,1);
                if(S.compareTo("1")==0) digit=0;
                if(S.compareTo("2")==0) digit=1;
                if(S.compareTo("3")==0) digit=2;
                T1[i+1]=T1[i].reflect(digit);
            }}
        return(T1);
    }
    
    public static ListenTriangle[] rotateHorizontal(ListenTriangle[] T1,int n) {
        Complex z=new Complex();
        ListenTriangle[] T2=new ListenTriangle[1000];
        z=z.minus(T1[0].z[0],T1[n].z[0]);
        z=z.unit(z);
        z.x=-z.x;
        for(int i=0;i<=n+1;++i) T2[i]=T1[i].rotate(z);
        return(T2);
    }
    
    public ListenTriangle[] fitRectangle(double X,double Y,double offsetX,double offsetY,ListenTriangle[] T2,int n) {
        double mx=1000000;
        double my=1000000;
        double Mx=-1000000;
        double My=-1000000;
        
        for(int i=1;i<=n;++i) {
            for(int j=0;j<=2;++j) {
                if(mx>T2[i].z[j].x) mx=T2[i].z[j].x;
                if(my>T2[i].z[j].y) my=T2[i].z[j].y;
                if(Mx<T2[i].z[j].x) Mx=T2[i].z[j].x;
                if(My<T2[i].z[j].y) My=T2[i].z[j].y;
            }
        }
        
        ListenTriangle[] T3=new ListenTriangle[1000];
        
        double s=X/(Mx-mx);
        double ss=Y/(My-my);
        
        if(s>ss) s=ss;
        s=s*1;
        Complex z1=new Complex(-s*mx+offsetX,Y/2-s*(My+my)/2.0+offsetY);
        for(int i=0;i<=n+1;++i) T3[i]=T2[i].scale(z1,s);
        return(T3);
    }
    
    
    
    public void doUnfold(String W,Complex z) {
	if(W!="") {
        CT=CombinatorialTriangle.unfold(W);
        CT=CombinatorialTriangle.assignTails(CT);
        Dimension D=this.getSize();
        int x=D.width-10;
        int y=D.height-10;
        int n=W.length();
        ListenTriangle[] T1=rawUnfold(ListenTriangle.init(z),W);
        ListenTriangle[] T2=rotateHorizontal(T1,n);
        ListenTriangle[] T3=fitRectangle(x,y,5,5,T2,n);
        
        for(int i=0;i<=n+1;++i)  {
            T[i]=T[i].enhance(T3[i]);
            if(T[i].on[0]==0) T[i].C[0]=UC.L[2].C;
            for(int q=1;q<=8;++q) {if(T[i].on[q]==0) T[i].C[q]=UC.L[3].C;}
        }
        C.compute(W,T3,n);
        if(UC.L[20].on==1) setLeaders();
	}
    }
    
    
    
    public static VertexPair getLeaders(String W,Complex z) {
        int n=W.length();
        Corridor CC=new Corridor();
        ListenTriangle[] T1=rawUnfold(ListenTriangle.init(z),W);
        ListenTriangle[] T2=rotateHorizontal(T1,n);
        CC.compute(W,T2,n);
        VertexPair V=new VertexPair(1,CC.i1,2,CC.i2);
        return(V);
    }
    
    
    
    public static int checkPositive(String W,Complex z) {
        Corridor CC=new Corridor();
        int n=W.length();
        ListenTriangle[] T1=rawUnfold(ListenTriangle.init(z),W);
        ListenTriangle[] T2=rotateHorizontal(T1,n);
        CC.compute(W,T2,n);
        if(CC.t1-CC.t2>0) return(1);
        return(-1);
    }
    
    public static int checkPositive(String W,DyadicSquare Q) {
        Complex[] z=Q.toPolygon();
        int test=0;
        for(int i=0;i<4;++i) {
            test=checkPositive(W,z[i]);
            if(test==-1) return(0);
        }
        return(1);
    }
    
    
    
    
    
    
    public void doUnfold() {
        doUnfold(this.W,this.Z);
    }
    
    public void document() {
        M.setExplain("This is the unfolding window.  Given a word W and a triangle T we produce the finite union of triangles U(W,T) by reflecting T iteratively, according to the digits of W. We call U(W,T) the unfolding.  To see this in action, just press any of the red buttons on the the word section window.  (These buttons are the ones with white figure drawn on them.)  W has the property that the first and last sides of U(W,T) are parallel independent of the choice T. We always rotate the picture so that the axis of the translation identifying the first and last sides is horizontal. \n\n The unfolding has a row of top vertices and a row of bottom vertices. W describes a periodic billiard path for T if and only if a straight horizontal line separates the top and bottom vertices.  In this case, we draw the strip whose boundaries are the highest and lowest lines with this property. Any staight line in the strip corresponds to a periodic billiard path of combinatorial type W.  You can see these lines drawn if you select a typical word, say word 1, and then push the straight+ button\n\n If you click button 2 on the unfolding you can select pieces of it.  You select a triangle by clicking near the center of the triangle; you select an edge by clicking near the center of the edge; you select a vertex by clicking near the vertex.  After you select one of these objects, some numbers will appear which show some of the data associated to your choice. You should click on the info button near this display to get information about it.");
    }
    
    /* Set the word used by this object */
    public void setWord(String w) {
        W=w;
        doUnfold();
        repaint();
        UC.repaint();
    }
    
    /* Set the point in the parameter space used by this object */
    public void parameterChanged(){
        Z=M.getZ();
        doUnfold();
        repaint();
        UC.repaint();
    }
    
    public void selectTile(Tile st) {
        //pick out the word
        W=st.getStringWord();
        //pick out the Tile
        ST=st;
        
        doUnfold();
        repaint();
        UC.repaint();
        

        if (ST.getClass().getName()=="DyadicTile") { // check to see if the tile is a DyadicTile
            DyadicTile DT=(DyadicTile)(ST);
            if (DT.record_active==1) {
                UContainer.showBoxAnalyzer();
            } else {
                UContainer.hideBoxAnalyzer();
            }
        }else {
            UContainer.hideBoxAnalyzer();
        }
    }
    
    public void selectedTileModified() {
    }
    
}

