import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**
 * This class is based on Rich's WordIconCanvas. I wanted this to handle
 * searches, so now it can take an Array of strings.
 */
public class WordDisplayCanvas extends DBCanvas
implements MouseListener, HearingBasicResults {
    Manager M;
    String[] list;
    
    WordIcon[] W=new WordIcon[10];
    ListenTriangle[] L=new ListenTriangle[2];
    ListenSquare DO;
    int start;    
    Complex z;
    
    public WordDisplayCanvas(Manager M) {
        this.M=M;
        M.hearBasicResults(this);
        
        list=new String[0];
       
        setBackground(Color.black);
        Color C0=Color.black;
        Color C1=Color.white;
        Color C2=Color.white;
        addMouseListener(this);
        DO=new ListenSquare(124,94,12,12,Color.black);
        DO.on=1;
        
        for (int i=0; i<5; i++){
            W[i]=new WordIcon(5+50*i,5,45,50,"",0);
            W[i+5]=new WordIcon(5+50*i,145,45,50,"",1);
        }
        
        L[0]=new ListenTriangle();
        L[0].z[0].x=90;
        L[0].z[0].y=100;
        L[0].z[1].x=120;
        L[0].z[1].y=80;
        L[0].z[2].x=120;
        L[0].z[2].y=120;
        
        L[1]=new ListenTriangle();
        L[1].z[0].x=170;
        L[1].z[0].y=100;
        L[1].z[1].x=140;
        L[1].z[1].y=80;
        L[1].z[2].x=140;
        L[1].z[2].y=120;
        
        start=0;

        setSize(255, 200);
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
              
        Color C1=new Color(180,0,0);
        Color C2=new Color(80,0,0);
        Color C3=new Color(255,0,0);
        Color C4=Color.white;
        Color C5=Color.white;  
        Color C6=new Color(0,0,180);
        Color C7=new Color(0,0,80);
        Color C8=new Color(0,0,255); 
        Color C9=new Color(0,180,0);
        Color C10=new Color(0,80,0);
        Color C11=new Color(0,255,0);
        
        setWords();
        for(int i=0;i<=9;++i)
	    W[i].pathRender(g,C1,C2,C3,C4,C5,C6,C7,C8,C9,C10,C11);
        L[0].renderSmooth(g,new Color(30,30,30),Color.white);
        L[1].renderSmooth(g,new Color(30,30,30),Color.white);
        
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
        g.setColor(new Color(180,180,180));
        g.drawString(""+list.length,195,105);
        Integer I2=new Integer(start);
        Integer I3=new Integer(start+9);
        g.drawString(I2.toString(),5,88);
        g.drawString("thru",5,105);
        g.drawString(I3.toString(),5,122);
        
        DO.infoRender(g);
    }
    
    public void setWords() {
        for(int i=0;i<10;++i) 
            if (start+i<list.length) 
                W[i].W=list[start+i];
            else
                W[i].W="";
     }
    
    
    
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();
        selectWord(X);
        doShift(X);
        //M.U.doUnfold();
        if(DO.inside(X)==1) document();
        repaint();
    }
    
    
    public void document() {
        M.setExplain("This is the word selection window.  Each word is some string in the digits 1,2,3.  Each of the 10 red buttons represents a word using an icon.  The icon is a hexagonal path in the plane.  The path is made by dividing the three kinds of edges in the hexagonal grid into types depending on the direction of the edge, and then following these edges according to the digits in the word.  The fact that the paths are all closed indicates that the words we are considering are all stable:  They describe periodic billiard paths in open sets of triangles.  If there are more than 10 possible words you can use the arrow keys to cycle through the list.  If you click on one of the red buttons you focus the applet on that word.");
    }
    
    
    public void doShift(Point X) {
        int doo;
        doo=0;
        if(L[0].inside(X)==1) {
            start=start-10;
            if(start<0) start=0;
            doo=1;
        }
        if(L[1].inside(X)==1) {
            start=start+10;
            if(start>=list.length) start=start-10;
            doo=1;
        }
        if(doo==1) {
            for(int i=0;i<10;++i) W[i].on=0;
        }
    }
    
    public void selectWord(Point X) {
        int test=-1;
        int lim=list.length-start;
        if(lim>10) lim=10;
        
        for(int i=0;i<lim;++i) {
            if(W[i].inside(X)==1) test=i;
        }
        if(test>=0) {
            for(int i=0;i<lim;++i) {
                W[i].on=0; }
            W[test].on=1;
            M.selectTile(new SearchTile(W[test].W));
            //if (z!=null) 
            //    M.setParameter(z);
        }       
    }

    public Complex getZ(){
        return z;
    }
    
    public String getWord() {
        for (int i=0; i<10; i++){
            if (W[i].on==1)
                return W[i].W;
        }
        return null;
    }
    
    /** Set the search results */
    public void setBasicResults(BasicSearchResults results){
        list=results.words;
        if (results.z!=null) 
            z=new Complex(results.z);
        else 
            z=null;
        start=0;
        setWords();
        for (int i=0; i<10; i++){
            W[i].on=0;
        }
        repaint();
    }
    
}
