import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This picture paints a picture of a right triangle with sides A and B.*/

 public class PictureCanvas extends Canvas {
     BigInteger a,b,c,s,t;
     double x,y;

     public PictureCanvas(BigInteger s,BigInteger t,BigInteger a,BigInteger b,BigInteger c) {
	 this.s=s;
	 this.t=t;
	 this.a=a;
	 this.b=b;
	 this.c=c;
	 setValue();
	}

     public void recompute1(BigInteger x) {
	 this.s=x;
	 setValue();
     }

     public void recompute2(BigInteger x) {
	 this.t=x;
	 setValue();
     }



     public void setValue() {
	 int test=1;
	 if(t.compareTo(new BigInteger("0"))==0) test=0;
	 if(s.compareTo(t)!=1) test=0;
	 BigInteger ms=s.mod(new BigInteger("2"));
	 BigInteger mt=t.mod(new BigInteger("2"));
	 if(ms.compareTo(new BigInteger("1"))!=0) test=0;
	 if(mt.compareTo(new BigInteger("1"))!=0) test=0;

	 if(test==1) {
	     this.a=s.multiply(t);
	     BigInteger temp=s.multiply(s);
	     temp=temp.subtract(t.multiply(t));
             temp=temp.divide(new BigInteger("2"));
	     this.b=temp;
	     temp=s.multiply(s);
	     temp=temp.add(t.multiply(t));
	     temp=temp.divide(new BigInteger("2"));
	     this.c=temp;

	     BigDecimal aa=new BigDecimal(a);
	     BigDecimal bb=new BigDecimal(b);
	     BigDecimal cc=new BigDecimal(c);
	     aa=aa.multiply(new BigDecimal(new BigInteger("1000000000")));
	     bb=bb.multiply(new BigDecimal(new BigInteger("1000000000")));
	     BigDecimal xx=aa.divide(cc,BigDecimal.ROUND_HALF_DOWN);
	     BigDecimal yy=bb.divide(cc,BigDecimal.ROUND_HALF_DOWN);
	     this.x=xx.doubleValue()/1000000000.0;
	     this.y=yy.doubleValue()/1000000000.0;
	 }
	 repaint();
     }



    public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.red);
      g.fillArc(-190,10,380,380,0,90);
      g.setColor(Color.blue);
      GeneralPath gp=new GeneralPath();
      gp.moveTo((float)(0.0),(float)(200.0));
      gp.lineTo((float)(0.0+190*x),(float)(200.0-190.0*y));
      gp.lineTo((float)(0.0+190*x),(float)(200.0));
      gp.closePath();
      g.fill(gp);

      g.setColor(new Color(255,150,0));
      g.fillRect(0,210,600,61);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.setColor(Color.black);
      g.drawString("A "+a.toString(),10,225);
      g.drawString("B "+b.toString(),10,245);
      g.drawString("C "+c.toString(),10,265);

      String[] s=new String[10];
       s[0]="Instructions: click on the magenta bars and use the keyboard to enter";
       s[1]="odd integers S and T with S>T>0.  (Up to 35 digit numbers are allowed.)";
       s[2]="The program computes:";
       s[3]="A=st";
       s[4]="B=(s^2-t^2)/2";
       s[5]="C=(s^2+t^2)/2";
       s[6]="This gives a Pythagorean triple A^2+B^2=C^2";
       s[7]="If S,T have no common factors then neither do A,B,C";
       s[8]="Click on the blue bar to divide out by the common factors.";
      for(int i=0;i<=8;++i) g.drawString(s[i],170+5*i,18+15*i);
    }                 

 }
    

